/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) recvjob.c: version 25.1 created on 12/2/91 at 16:13:04	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)recvjob.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 * @(#)recvjob.c	25.1
 */

#ifndef lint
/* static char sccsid[] = "@(#)recvjob.c	5.4 (Berkeley) 6/6/86"; */
#endif /* not lint */

/*
 * Receive printer jobs from the network, queue them and
 * start the printer daemon.
 */

#include "lp.h"
#ifdef	DISK_USAGE
#  include "sys/fs/s5param.h"
#  include "sys/fs/s5filsys.h"
#endif

#define ack()	(void) t_snd(Daemon, "", 1, 0);
#define	MAXSPOOL	1000	/* max local requests for one daemon to spool */

char    tfname[40];		/* tmp copy of cf before linking */
char    dfname[40];		/* data files */
int	minfree;		/* keep at least minfree blocks available */
char	*ddev;			/* disk device (for checking free space) */
int	dfd;			/* file system device descriptor */
extern int	remote;		/* 0 - printer is local
				 * 1 - printer is remote
				 */

extern int	t_errno;
extern char	*find_dev();

recvjob()
{
	struct stat stb;
	char *bp = pbuf;
	int status;
	struct sigaction	act;
	extern void rcleanup();

	/*
	 * Perform lookup for printer name or abbreviation
	 */
	init();

	(void) close(2);			/* set up log file */
	if (open(LF, O_WRONLY|O_APPEND, 0664) < 0) {
		syslog(LOG_ERR, "%s: %m", LF);
		(void) open("/dev/null", O_WRONLY);
	}

	if (chdir(SD) < 0)
		frecverr("%s: %s: %m", printer, SD);

	if (stat(LO, &stb) == 0) {
		if (stb.st_mode & 010) {
			syslog(LOG_WARNING, "%s: queue disabled", printer);
			/* queue is disabled */
			(void) t_snd(Daemon, "\1", 1, 0);
			drop_connect(Daemon);
			exit(1);
		}
	} else if (stat(SD, &stb) < 0)
		frecverr("%s: %s: %m", printer, SD);

#ifdef	DISK_USAGE
	minfree = read_number("minfree");
	ddev = find_dev(stb.st_dev, S_IFBLK);
	if ((dfd = open(ddev, O_RDONLY)) < 0)
		syslog(LOG_WARNING, "%s: %s: %m", printer, ddev);
#endif
	sigemptyset(&act.sa_mask);
	act.sa_handler = rcleanup;
	act.sa_flags = 0;
	(void) sigaction(SIGTERM, &act, NULL);
	(void) sigaction(SIGPIPE, &act, NULL);

	if (readjob())
		printjob();
}

#ifdef	DISK_USAGE
#include <sys/sysmacros.h>	/* SCO needs for major() & minor() */

char *
find_dev(dev, type)
	register dev_t dev;
	register int type;
{
	register DIR *dfd = opendir("/dev");
	struct dirent *dir;
	struct stat stb;
	char devname[MAXNAMLEN+6];
	char *dp;

	strcpy(devname, "/dev/");
	while ((dir = readdir(dfd))) {
		strcpy(devname + 5, dir->d_name);
		if (stat(devname, &stb))
			continue;
		if ((stb.st_mode & S_IFMT) != type)
			continue;
		if (dev == stb.st_rdev) {
			closedir(dfd);
			dp = (char *)malloc(strlen(devname)+1);
			strcpy(dp, devname);
			return(dp);
		}
	}
	closedir(dfd);
	frecverr("cannot find device %d, %d", major(dev), minor(dev));
	/*NOTREACHED*/
}
#endif

/*
 * Read printer jobs sent by lpd and copy them to the spooling directory.
 * Return the number of jobs successfully transfered.
 */
readjob()
{
	register int size, nfiles;
	register char *cp;
	char	*cf_files[MAXSPOOL];
	int	index = 0;
	int flags = 0;

	ack();
	nfiles = 0;
	for (;;) {
		if (index >= MAXSPOOL - 1) {
			/*
			 * Force another connection to handle the rest
			 */
			(void) t_snddis(Daemon, (struct t_call *) NULL);
			(void) t_unbind(Daemon);
			(void) t_close(Daemon);

			/*
			 * take care of files queued
			 */
			cf_files[index] = (char *) NULL;
			local_print(cf_files);
			return(0);
		}

		/*
		 * Read a command to tell us what to do
		 */
		cp = line;
		do {
			if ((size = t_rcv(Daemon, cp, 1, &flags)) != 1) {
				if (t_errno != TLOOK
					|| ((flags = t_look(Daemon)) != T_ORDREL
						&& flags != T_DISCONNECT))
				{
					frecverr("%s: readjob: t_look: %d",
						printer, flags);
				}

				(void) t_rcvdis(Daemon, (struct t_call *) NULL);
				(void) t_unbind(Daemon);
				(void) t_close(Daemon);
				if (index) {
					cf_files[index] = (char *) NULL;
					local_print(cf_files);
				}
				return(nfiles);
			}
		} while (*cp++ != '\n');
		*--cp = '\0';
		cp = line;
		switch (*cp++) {
		case '\1':	/* cleanup because data sent was bad */
			rcleanup();
			continue;

		case '\2':	/* read cf file */
			size = 0;
			while (*cp >= '0' && *cp <= '9')
				size = size * 10 + (*cp++ - '0');
			if (*cp++ != ' ')
				break;
			/*
			 * host name has been authenticated, we use our
			 * view of the host name since we may be passed
			 * something different than what gethostbyaddr()
			 * returns
			 */

			/* 
			 * This patch is required to match the 14
			 * char restriction on file names ( POSIX )
			 * RLS
			*/
			if( strlen( from ) > 8 )
				from[ 8 ] = '\0';	

			strcpy(cp + 6, from);
			strcpy(tfname, cp);
			tfname[0] = 't';
#ifdef	DISK_USAGE
			if (!chksize(size)) {
				(void) t_snd(Daemon, "\2", 1, 0);
				continue;
			}
#endif
			if (!readfile(tfname, size)) {
				rcleanup();
				continue;
			}
			if (remote) {
				if (link(tfname, cp) < 0)
					frecverr("%s: %m", tfname);
				(void) unlink(tfname);
				tfname[0] = '\0';
				nfiles++;
			}
			else {
				cf_files[index++] = strdup(tfname);
			}

			continue;

		case '\3':	/* read df file */
			size = 0;
			while (*cp >= '0' && *cp <= '9')
				size = size * 10 + (*cp++ - '0');
			if (*cp++ != ' ')
				break;
#ifdef	DISK_USAGE
			if (!chksize(size)) {
				(void) t_snd(Daemon, "\2", 1, 0);
				continue;
			}
#endif
			strcpy(dfname, cp);
			/* REE - truncate filename to 14 char */
			dfname[14] = NULL;
			(void) readfile(dfname, size);
			continue;
		}
		frecverr("protocol screwup");
	}
}

/*
 * Read files send by lpd and copy them to the spooling directory.
 */
readfile(file, size)
	char *file;
	int size;
{
	register char *cp;
	char buf[BUFSIZ];
	register int i, j, amt;
	int fd, err, flags = 0;

	fd = open(file, O_WRONLY|O_CREAT, FILMOD);
	if (fd < 0)
		frecverr("%s: %m", file);
	ack();
	err = 0;
	for (i = 0; i < size; i += BUFSIZ) {
		amt = BUFSIZ;
		cp = buf;
		if (i + amt > size)
			amt = size - i;
		do {
			j = t_rcv(Daemon, cp, amt, &flags);
			if (j <= 0)
				frecverr("%s: readfile: t_rcv: %d: %m",
					printer, t_errno);
			amt -= j;
			cp += j;
		} while (amt > 0);
		amt = BUFSIZ;
		if (i + amt > size)
			amt = size - i;
		if (write(fd, buf, amt) != amt) {
			err++;
			break;
		}
	}
	(void) close(fd);
	if (err)
		frecverr("%s: write error", file);
	if (noresponse()) {		/* file sent had bad data in it */
		(void) unlink(file);
		return(0);
	}
	ack();
	return(1);
}

noresponse()
{
	char resp;
	int flags = 0;

	if (t_rcv(Daemon, &resp, 1, &flags) != 1)
		frecverr("%s: noresponse: t_rcv: %d: %m", printer, t_errno);
	if (resp == '\0')
		return(0);
	return(1);
}

#ifdef	DISK_USAGE
/*
 * filesystem block sizes - indexed by filesystem types (disgusting)
 */
int fsbsize[] = { 512, 512, 1024, 2048, 4096, 0, 1024, 4096 };

/*
 * Check to see if there is enough space on the disk for size bytes.
 * 1 == OK, 0 == Not OK.
 */
chksize(size)
	int size;
{
	struct stat stb;
	register char *ddev;
	int spacefree;
	struct filsys *fs;
	char fbuf[BSIZE], *p;

	if (dfd < 0 || lseek(dfd, (long)SUPERBOFF, 0) < 0)
		return(1);

	if (read(dfd, fbuf, BSIZE) != BSIZE)
		return(1);

	/*
	 * Unsure why this is needed
	 */
	p = &fbuf[512];
	fs = (struct filsys *) p;
	
	/* validate s_type */
	if (fs.s_type < 0 || fs.s_type > (sizeof(fsbsize)/sizeof(fsbsize[0]))-1)
		fs.s_type = 0;	/* default */

	spacefree = fs.s_tfree * fsbsize[fs.s_type] / 1024;
	size = (size + 1023) / 1024;

	if (minfree + size > spacefree)
		return(0);
	return(1);
}

read_number(fn)
	char *fn;
{
	char lin[80];
	register FILE *fp;

	if ((fp = fopen(fn, "r")) == NULL)
		return (0);
	if (fgets(lin, 80, fp) == NULL) {
		fclose(fp);
		return (0);
	}
	fclose(fp);
	return (atoi(lin));
}
#endif	/* DISK_USAGE */

/*
 * Remove all the files associated with the current job being transfered.
 */
void
rcleanup()
{
	if (tfname[0])
		(void) unlink(tfname);
	if (dfname[0])
		do {
			do
				(void) unlink(dfname);
			while (dfname[2]-- != 'A');
			dfname[2] = 'z';
		} while (dfname[0]-- != 'd');
	dfname[0] = '\0';
}

frecverr(msg, a1, a2)
	char *msg;
{
	rcleanup();
	syslog(LOG_ERR, msg, a1, a2);
	(void) t_snd(Daemon, "\1", 1, 0);
	drop_connect(Daemon);
	exit(1);
}
