/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) printjob.c: version 25.1 created on 12/2/91 at 16:12:59	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)printjob.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 * @(#)printjob.c	25.1
 */

#ifndef lint
/* static char sccsid[] = "@(#)printjob.c	5.2 (Berkeley) 9/17/85"; */
#endif /* not lint */

/*
 * printjob -- print jobs in the queue.
 *
 *	NOTE: the lock file is used to pass information to lpq and lprm.
 *	it does not need to be removed because file locks are dynamic.
 */

#include "lp.h"

#define DORETURN	0	/* absorb fork error */
#define DOABORT		1	/* abort if dofork fails */

/*
 * Error tokens
 */
#define REPRINT		-2
#define ERROR		-1
#define	OK		0
#define	FATALERR	1
#define	NOACCT		2
#define	FILTERERR	3
#define	ACCESS		4

char	title[80];		/* ``pr'' title */
FILE	*cfp;			/* control file */
int	pfd;			/* printer file descriptor */
int	lfd;			/* lock file descriptor */
int	pid;			/* pid of lpd process */
int	prchild;		/* id of pr process */
int	child;			/* id of any filters */
int	tof;			/* true if at top of form */
int	remote;			/* true if sending files to remote */
dev_t	fdev;			/* device of file pointed to by symlink */
ino_t	fino;			/* inode of file pointed to by symlink */

char	fromhost[32];		/* user's host machine */
char	logname[32];		/* user's login name */
char	jobname[100];		/* job or file name */
char	class[32];		/* classification field */
char	width[10] = "-w";	/* page width in characters */
char	length[10] = "-l";	/* page length in lines */
char	pxwidth[10] = "-x";	/* page width in pixels */
char	pxlength[10] = "-y";	/* page length in pixels */
char	indent[10] = "-i0";	/* indentation size in characters */
char	Tmpfile[] = "errsXXXXXX"; /* file name for filter output */

printjob()
{
	struct stat stb;
	register struct queue *q, **qp;
	struct queue **queue;
	register int i, nitems;
	long pidoff;
	int count = 0, tfd;
	char buf[BUFSIZ];
	struct sigaction	act;
	extern void abortpr();

	init();					/* set up capabilities */
	if (Daemon >= 0)
		(void) t_snd(Daemon, "", 1, 0);	/* ack that daemon is started */

	(void) close(2);			/* set up log file */
	if (open(LF, O_WRONLY|O_APPEND, 0664) < 0) {
		syslog(LOG_ERR, "%s: %m", LF);
		(void) open("/dev/null", O_WRONLY);
	}
	setgid(getegid());
#ifdef	A1000
	pid = setpgid();			/* for use with lprm */
#else
	pid = setsid();				/* for use with lprm */
#endif
	sigemptyset(&act.sa_mask);
	act.sa_handler = abortpr;
	act.sa_flags = 0;
	(void) sigaction(SIGHUP, &act, NULL);
	(void) sigaction(SIGINT, &act, NULL);
	(void) sigaction(SIGQUIT, &act, NULL);
	(void) sigaction(SIGTERM, &act, NULL);

	(void) mktemp(Tmpfile);

	/*
	 * uses short form file names
	 */
	if (chdir(SD) < 0) {
		syslog(LOG_ERR, "%s: %m", SD);
		drop_connect(Daemon);
		exit(1);
	}
	if (stat(LO, &stb) == 0 && (stb.st_mode & 0100)) {
		drop_connect(Daemon);
		exit(0);		/* printing disabled */
	}
	lfd = open(LO, O_WRONLY|O_CREAT, 0644);
	if (lfd < 0) {
		syslog(LOG_ERR, "%s: %s: %m", printer, LO);
		drop_connect(Daemon);
		exit(1);
	}
	if (fcntl(lfd, F_SETLK, EXCL_LOCK) < 0) {
		/* see if active deamon present */
		if (errno == EACCES || errno == EAGAIN) {
#ifdef	DEBUG
			syslog(LOG_WARNING,
				"%s: daemon already present", printer);
#endif
			drop_connect(Daemon);
			exit(0);
		}

		syslog(LOG_ERR, "%s: %s: %m", printer, LO);
		drop_connect(Daemon);
		exit(1);
	}

	/*
	 * The following code is attempting to truncate the lock
	 * file while maintaining the exclusive lock.  A hole exists
	 * between the unlink() and link().
	 */
	(void) sprintf(buf, "%s.1", LO);
	tfd = open(buf, O_WRONLY|O_CREAT|O_TRUNC, 0644);

	if (tfd < 0 || fcntl(tfd, F_SETLK, EXCL_LOCK) < 0) {
		syslog(LOG_ERR, "%s: %s: %m", printer, buf);
		drop_connect(Daemon);
		exit(1);
	}

	(void) unlink(LO);
	if (link(buf, LO) < 0) {
		syslog(LOG_ERR, "%s: link: %s: %m", printer, buf);
		drop_connect(Daemon);
		exit(1);
	}

	(void) unlink(buf);
	(void) close(lfd);
	lfd = tfd;
	/* end of truncation code */

	/*
	 * write process id for others to know
	 */
	sprintf(line, "%u\n", pid);
	pidoff = i = strlen(line);
	if (write(lfd, line, i) != i) {
		syslog(LOG_ERR, "%s: %s: %m", printer, LO);
		drop_connect(Daemon);
		exit(1);
	}
	/*
	 * search the spool directory for work and sort by queue order.
	 */
	if ((nitems = getq(&queue)) < 0) {
		syslog(LOG_ERR, "%s: can't scan %s", printer, SD);
		drop_connect(Daemon);
		exit(1);
	}
	if (nitems == 0) {		/* no work to do */
#ifdef	DEBUG
		syslog(LOG_WARNING, "%s: no work in spool directory", printer);
#endif
		drop_connect(Daemon);
		exit(0);
	}
	if (stb.st_mode & 01) {		/* reset queue flag */
		if (chmod(LO, stb.st_mode & 0776) < 0)
			syslog(LOG_ERR, "%s: %s: %m", printer, LO);
	}
	openpr();			/* open remote */
again:
	/*
	 * we found something to do now do it --
	 *    write the name of the current control file into the lock file
	 *    so the spool queue program can tell what we're working on
	 */
	for (qp = queue; nitems--; free((char *) q)) {
		q = *qp++;
		if (stat(q->q_name, &stb) < 0)
			continue;
	restart:
		(void) lseek(lfd, pidoff, 0);
		(void) sprintf(line, "%s\n", q->q_name);
		i = strlen(line);
		if (write(lfd, line, i) != i)
			syslog(LOG_ERR, "%s: %s: %m", printer, LO);
		i = sendit(q->q_name);
		/*
		 * Check to see if we are supposed to stop printing or
		 * if we are to rebuild the queue.
		 */
		if (fstat(lfd, &stb) == 0) {
			/* stop printing before starting next job? */
			if (stb.st_mode & 0100)
				goto done;
			/* rebuild queue (after lpc topq) */
			if (stb.st_mode & 01) {
				for (free((char *) q); nitems--; free((char *) q))
					q = *qp++;
				if (chmod(LO, stb.st_mode & 0776) < 0)
					syslog(LOG_WARNING, "%s: %s: %m",
						printer, LO);
				break;
			}
		}
		if (i == OK)		/* file ok and printed */
			count++;
		else if (i == REPRINT) { /* try reprinting the job */
			syslog(LOG_INFO, "restarting %s", printer);
			(void) t_unbind(pfd);
			(void) t_close(pfd);	/* close printer */
			openpr();		/* try to reopen printer */
			goto restart;
		}
	}
	free((char *) queue);
	/*
	 * search the spool directory for more work.
	 */
	if ((nitems = getq(&queue)) < 0) {
		syslog(LOG_ERR, "%s: can't scan %s", printer, SD);
		drop_connect(Daemon);
		exit(1);
	}
	if (nitems == 0) {		/* no more work to do */
	done:
#ifdef	DEBUG
		syslog(LOG_WARNING, "%s: no more work to do", printer);
#endif
		(void) unlink(Tmpfile);
		drop_connect(Daemon);
		exit(0);
	}
	goto again;
}

/*
 * The remaining part is the reading of the control file (cf)
 * and performing the various actions.
 */
printit(file)
	char *file;
{
	register int i;
	char *cp, *p;
	int bombed = OK;

	/*
	 * open control file; ignore if no longer there.
	 */
	if ((cfp = fopen(file, "r")) == NULL) {
		syslog(LOG_INFO, "%s: %s: %m", printer, file);
		return(OK);
	}
	strcpy(width+2, "0");
	strcpy(indent+2, "0");

	/*
	 *      read the control file for work to do
	 *
	 *      file format -- first character in the line is a command
	 *      rest of the line is the argument.
	 *      valid commands are:
	 *
	 *		S -- "stat info" for symbolic link protection
	 *		J -- "job name" on banner page
	 *		C -- "class name" on banner page
	 *              L -- "literal" user's name to print on banner
	 *		T -- "title" for pr
	 *		H -- "host name" of machine where lpr was done
	 *              P -- "person" user's login name
	 *              I -- "indent" amount to indent output
	 *              f -- "file name" name of text file to print
	 *		l -- "file name" text file with control chars
	 *		p -- "file name" text file to print with pr(1)
	 *		t -- "file name" troff(1) file to print
	 *		n -- "file name" ditroff(1) file to print
	 *		d -- "file name" dvi file to print
	 *		g -- "file name" plot(1G) file to print
	 *		v -- "file name" plain raster file to print
	 *		c -- "file name" cifplot file to print
	 *		1 -- "R font file" for troff
	 *		2 -- "I font file" for troff
	 *		3 -- "B font file" for troff
	 *		4 -- "S font file" for troff
	 *		N -- "name" of file (used by lpq)
	 *              U -- "unlink" name of file to remove
	 *                    (after we print it. (Pass 2 only)).
	 *		M -- "mail" to user when done printing
	 *
	 *      getline reads a line and expands tabs to blanks
	 */

	/* pass 1 */

	while (getline(cfp))
		switch (line[0]) {
		case 'H':
			strcpy(fromhost, line+1);
			if (class[0] == '\0')
				strncpy(class, line+1, sizeof(class)-1);
			continue;

		case 'P':
			strncpy(logname, line+1, sizeof(logname)-1);
			if (RS) {			/* restricted */
				if (getpwnam(logname) == (struct passwd *)0) {
					bombed = NOACCT;
					sendmail(line+1, bombed);
					goto pass2;
				}
			}
			continue;

		case 'S':
#ifdef	SYMBOLIC_LINK
			cp = line+1;
			i = 0;
			while (*cp >= '0' && *cp <= '9')
				i = i * 10 + (*cp++ - '0');
			fdev = i;
			cp++;
			i = 0;
			while (*cp >= '0' && *cp <= '9')
				i = i * 10 + (*cp++ - '0');
			fino = i;
#endif	/* SYMBOLIC_LINK */
			continue;

		case 'J':
			if (line[1] != '\0')
				strncpy(jobname, line+1, sizeof(jobname)-1);
			else
				strcpy(jobname, " ");
			continue;

		case 'C':
			if (line[1] != '\0')
				strncpy(class, line+1, sizeof(class)-1);
			else if (class[0] == '\0') {
				Gethostname(class, sizeof(class));
			}
			continue;

		case 'T':	/* header title for pr */
			strncpy(title, line+1, sizeof(title)-1);
			continue;

		case '1':	/* troff fonts */
		case '2':
		case '3':
		case '4':
			continue;

		case 'W':	/* page width */
			strncpy(width+2, line+1, sizeof(width)-3);
			continue;

		case 'I':	/* indent amount */
			strncpy(indent+2, line+1, sizeof(indent)-3);
			continue;

		default:	/* some file to print */
			/* REE - truncate to 14 char filename */
			*(line+15)=NULL;
			switch (i = print(line[0], line+1)) {
			case ERROR:
				if (bombed == OK)
					bombed = FATALERR;
				break;
			case REPRINT:
				(void) fclose(cfp);
				return(REPRINT);
			case FILTERERR:
			case ACCESS:
				bombed = i;
				sendmail(logname, bombed);
			}
			title[0] = '\0';
			continue;

		case 'N':
		case 'L':
		case 'U':
		case 'M':
			continue;
		}

	/* pass 2 */

pass2:
	fseek(cfp, 0L, 0);
	while (getline(cfp))
		switch (line[0]) {
		case 'M':
			if (bombed < NOACCT)	/* already sent if >= NOACCT */
				sendmail(line+1, bombed);
			continue;

		case 'U':
			/* REE - truncate filename to 14 char */
			*(line+15) = NULL;
			(void) unlink(line+1);
		}
	/*
	 * clean-up in case another control file exists
	 */
	(void) fclose(cfp);
	(void) unlink(file);
	return(bombed == OK ? OK : ERROR);
}

/*
 * Print a file.
 * Set up the chain [ PR [ | {IF, OF} ] ] or {IF, RF, TF, NF, DF, CF, VF}.
 * Return -1 if a non-recoverable error occured,
 * 2 if the filter detected some errors (but printed the job anyway),
 * 1 if we should try to reprint this job and
 * 0 if all is well.
 * Note: all filters take stdin as the file, stdout as the printer,
 * stderr as the log file, and must not ignore SIGINT.
 */
print(format, file)
	int format;
	char *file;
{
	register int n;
	register char *prog;
	int fi, fo;
	char *av[15], buf[BUFSIZ];
	int pid, p[2];
	int status;
	struct stat stb;

#ifdef	SYMBOLIC_LINK
	if (lstat(file, &stb) < 0 || (fi = open(file, O_RDONLY)) < 0)
		return(ERROR);
	/*
	 * Check to see if data file is a symbolic link. If so, it should
	 * still point to the same file or someone is trying to print
	 * something he shouldn't.
	 */
	if ((stb.st_mode & S_IFMT) == S_IFLNK && fstat(fi, &stb) == 0 &&
	    (stb.st_dev != fdev || stb.st_ino != fino))
		return(ACCESS);
#else	/* ! SYMBOLIC_LINK */
	if ((fi = open(file, O_RDONLY)) < 0)
		return(ERROR);
#endif	/* SYMBOLIC_LINK */

	if (pipe(p) < 0) {
		return(ERROR);
	}

	if ((child = dofork(DORETURN)) == 0) {	/* child */
		(void) dup2(fi, 0);		/* file is stdin */
		(void) dup2(p[1], 1);		/* pipe is stdout */

		/*
		 * fool 'lp' into thinking the job is from 'logname'
		 */
		(void) sprintf(buf, "LOGNAME=%s", logname);
		putenv(buf);
		execl("/usr/bin/lp", "lp", "-d", printer, "-t", fromhost,
			(char *) NULL);

		syslog(LOG_ERR, "cannot execlp lp: %m");
		exit(2);
	}

	(void) close(p[1]);
	(void) close(fi);

	if (child < 0)
		return(ERROR);
	else if ((pid = waitpid(child, &status, 0)) < 0)
		syslog(LOG_ERR, "waitpid: %m");
	else {

		while ((n = read(p[0], buf, sizeof(buf))) > 0)
			write(2, buf, n);

#ifdef	A1000
# define WIFEXITED(X)		((X & 0xFF) == 0)? 1:0
# define WEXITSTATUS(X)		((X >> 8) & 0xFF)
# define WIFSIGNALED(X)		((((X >> 8) & 0xFF) == 0)&&(X&0xFF))? 1:0
# define WTERMSIG(X)		(X & 0x7F)
#endif
		if (WIFEXITED(status) && WEXITSTATUS(status) == 0) {
			return(OK);
		}
		if (WIFEXITED(status) && WEXITSTATUS(status) != 0) {
			syslog(LOG_ERR, "lp exited with %d",
					WEXITSTATUS(status));
			sleep(2);
			return(REPRINT);
		}
		else if (WIFSIGNALED(status)) {
			syslog(LOG_ERR, "lp killed by signal %d",
					WTERMSIG(status));
			return(REPRINT);
		}
	}

	return(ERROR);
}

/*
 * Send the daemon control file (cf) and any data files.
 * Return -1 if a non-recoverable error occured, 1 if a recoverable error and
 * 0 if all is well.
 */
sendit(file)
	char *file;
{
	register int i, err = OK;
	char *cp, last[BUFSIZ];

	/*
	 * open control file
	 */
	if ((cfp = fopen(file, "r")) == NULL)
		return(OK);
	/*
	 *      read the control file for work to do
	 *
	 *      file format -- first character in the line is a command
	 *      rest of the line is the argument.
	 *      commands of interest are:
	 *
	 *            a-z -- "file name" name of file to print
	 *              U -- "unlink" name of file to remove
	 *                    (after we print it. (Pass 2 only)).
	 */

	/*
	 * pass 1
	 */
	while (getline(cfp)) {
	again:
		if (line[0] == 'S') {
#ifdef	SYMBOLIC_LINK
			cp = line+1;
			i = 0;
			while (*cp >= '0' && *cp <= '9')
				i = i * 10 + (*cp++ - '0');
			fdev = i;
			cp++;
			i = 0;
			while (*cp >= '0' && *cp <= '9')
				i = i * 10 + (*cp++ - '0');
			fino = i;
#endif	/* SYMBOLIC_LINK */
			continue;
		}
		if (line[0] >= 'a' && line[0] <= 'z') {
			strcpy(last, line);
			while (i = getline(cfp))
				if (strcmp(last, line))
					break;
			switch (sendfile('\3', last+1)) {
			case OK:
				if (i)
					goto again;
				break;
			case REPRINT:
				(void) fclose(cfp);
				return(REPRINT);
			case ACCESS:
				sendmail(logname, ACCESS);
			case ERROR:
				err = ERROR;
			}
			break;
		}
	}
	if (err == OK && sendfile('\2', file) > 0) {
		(void) fclose(cfp);
		return(REPRINT);
	}
	/*
	 * pass 2
	 */
	fseek(cfp, 0L, 0);
	while (getline(cfp))
		if (line[0] == 'U'){
			/* REE - truncate filename to 14 char */
			*(line+15) = NULL;
			(void) unlink(line+1);
		}
	/*
	 * clean-up in case another control file exists
	 */
	(void) fclose(cfp);
	(void) unlink(file);
	return(err);
}

/*
 * Send a data file to the remote machine and spool it.
 * Return positive if we should try resending.
 */
sendfile(type, file)
	char type, *file;
{
	register int f, i, amt;
	struct stat stb;
	char buf[BUFSIZ];
	int sizerr, resp;

#ifdef	SYMBOLIC_LINK
	if (lstat(file, &stb) < 0 || (f = open(file, O_RDONLY)) < 0)
		return(ERROR);
	/*
	 * Check to see if data file is a symbolic link. If so, it should
	 * still point to the same file or someone is trying to print something
	 * he shouldn't.
	 */
	if ((stb.st_mode & S_IFMT) == S_IFLNK && fstat(f, &stb) == 0 &&
	    (stb.st_dev != fdev || stb.st_ino != fino))
		return(ACCESS);
#else	/* ! SYMBOLIC_LINK */
	if ((f = open(file, O_RDONLY)) < 0 || fstat(f, &stb) < 0)
		return(ERROR);
#endif	/* SYMBOLIC_LINK */
	(void) sprintf(buf, "%c%d %s\n", type, stb.st_size, file);
	amt = strlen(buf);
	for (i = 0;  ; i++) {
		if (t_snd(pfd, buf, amt, 0) != amt ||
		    (resp = response()) < 0 || resp == '\1') {
			syslog(LOG_WARNING, "%s: sendfile: '%s' failed",
					printer, buf);
			(void) close(f);
			return(REPRINT);
		} else if (resp == '\0')
			break;
		if (i == 0)
			status("no space on remote; waiting for queue to drain");
		if (i == 10)
			syslog(LOG_ALERT, "%s: can't send to %s; queue full",
				printer, RM);
		sleep(5 * 60);
	}
	if (i)
		status("sending to %s", RM);
	sizerr = 0;
	for (i = 0; i < stb.st_size; i += BUFSIZ) {
		amt = BUFSIZ;
		if (i + amt > stb.st_size)
			amt = stb.st_size - i;
		if (sizerr == 0 && read(f, buf, amt) != amt)
			sizerr = 1;
		if (t_snd(pfd, buf, amt, 0) != amt) {
			(void) close(f);
			return(REPRINT);
		}
	}
	(void) close(f);
	if (sizerr) {
		syslog(LOG_INFO, "%s: %s: changed size", printer, file);
		/* tell recvjob to ignore this file */
		(void) t_snd(pfd, "\1", 1, 0);
		return(ERROR);
	}
	if (t_snd(pfd, "", 1, 0) != 1 || response()) {
		syslog(LOG_WARNING, "%s: remote acknowledge failed", printer);
		return(REPRINT);
	}
	return(OK);
}

/*
 * Check to make sure there have been no errors and that both programs
 * are in sync with eachother.
 * Return non-zero if the connection was lost.
 */
response()
{
	char resp;
	int flags;

	if (t_rcv(pfd, &resp, 1, &flags) != 1) {
		tsyslog(LOG_INFO, pfd, "t_rcv");
		return(-1);
	}
	return((int) resp);
}

/*
 * sendmail ---
 *   tell people about job completion
 */
sendmail(user, bombed)
	char *user;
	int bombed;
{
	register int i;
	int p[2], s;
	register char *cp;
	char buf[100];
	struct stat stb;
	FILE *fp;

	pipe(p);
	if ((s = dofork(DORETURN)) == 0) {		/* child */
		dup2(p[0], 0);
		for (i = 3; i < Open_max; i++)
			(void) close(i);
		if ((cp = strrchr(MAIL, '/')) != NULL)
			cp++;
		else
			cp = MAIL;
		sprintf(buf, "%s@%s", user, fromhost);
		execl(MAIL, cp, buf, 0);
		exit(0);
	} else if (s > 0) {				/* parent */
		dup2(p[1], 1);
		printf("To: %s@%s\n", user, fromhost);
		printf("Subject: printer job\n\n");
		printf("Your printer job ");
		if (*jobname)
			printf("(%s) ", jobname);
		switch (bombed) {
		case OK:
			printf("\ncompleted successfully\n");
			break;
		default:
		case FATALERR:
			printf("\ncould not be printed\n");
			break;
		case NOACCT:
			printf("\ncould not be printed without an account on %s\n", host);
			break;
		case FILTERERR:
			if (stat(Tmpfile, &stb) < 0 || stb.st_size == 0 ||
			    (fp = fopen(Tmpfile, "r")) == NULL) {
				printf("\nwas printed but had some errors\n");
				break;
			}
			printf("\nwas printed but had the following errors:\n");
			while ((i = getc(fp)) != EOF)
				putchar(i);
			(void) fclose(fp);
			break;
		case ACCESS:
			printf("\nwas not printed because it was not linked to the original file\n");
		}
		fflush(stdout);
		(void) close(1);
	}
	(void) close(p[0]);
	(void) close(p[1]);
	wait(&s);
}

/*
 * dofork - fork with retries on failure
 */
dofork(action)
	int action;
{
	register int i, pid;

	for (i = 0; i < 20; i++) {
		if ((pid = fork()) < 0) {
			sleep((unsigned)(i*i));
			continue;
		}
		/*
		 * Child should run as daemon instead of root
		 */
		if (pid == 0) {
			setuid(DU);
		}

		return(pid);
	}
	syslog(LOG_ERR, "can't fork");

	switch (action) {
	case DORETURN:
		return (-1);
	default:
		syslog(LOG_ERR, "bad action (%d) to dofork", action);
		/*FALL THRU*/
	case DOABORT:
		exit(1);
	}
	/*NOTREACHED*/
}

/*
 * Kill child processes to abort current job.
 */
void
abortpr()
{
	(void) unlink(Tmpfile);
	(void) kill(0, SIGINT);
	while (wait(0) > 0)
		;

	drop_connect(Daemon);
	exit(0);
}

init()
{
	int status, pentry;
	struct passwd *pw;

	if ((status = pgetent(line, printer)) < 0) {
		syslog(LOG_ERR, "can't open printer description file");
		drop_connect(Daemon);
		exit(1);
	} else if (status == 0 && (status = pgetent(line, "local")) <= 0) {
		pentry = 0;
		LP = DEFDEVLP;
		RP = DEFLP;
		LO = DEFLOCK;
		ST = DEFSTAT;
		LF = DEFLOGF;
		SD = DEFSPOOL;
		DU = (pw = getpwnam(DEFUSER)) ? pw->pw_uid : DEFUID;
		FF = DEFFF;
		PW = DEFWIDTH;
		PL = DEFLENGTH;
		PX = 0;
		PY = 0;
		RM = (char *) NULL;
	}
	else {
		pentry = 1;
		if ((LP = pgetstr("lp", &bp)) == NULL)
			LP = DEFDEVLP;
		if ((RP = pgetstr("rp", &bp)) == NULL)
			RP = DEFLP;
		if ((LO = pgetstr("lo", &bp)) == NULL)
			LO = DEFLOCK;
		if ((ST = pgetstr("st", &bp)) == NULL)
			ST = DEFSTAT;
		if ((LF = pgetstr("lf", &bp)) == NULL)
			LF = DEFLOGF;
		if ((SD = pgetstr("sd", &bp)) == NULL)
			SD = DEFSPOOL;
		if ((DU = pgetnum("du")) < 0)
			DU = (pw = getpwnam(DEFUSER)) ? pw->pw_uid : DEFUID;
		if ((FF = pgetstr("ff", &bp)) == NULL)
			FF = DEFFF;
		if ((PW = pgetnum("pw")) < 0)
			PW = DEFWIDTH;
		if ((PL = pgetnum("pl")) < 0)
			PL = DEFLENGTH;
		if ((PX = pgetnum("px")) < 0)
			PX = 0;
		if ((PY = pgetnum("py")) < 0)
			PY = 0;
		RM = pgetstr("rm", &bp);
	}

	sprintf(&width[2], "%d", PW);
	sprintf(&length[2], "%d", PL);
	sprintf(&pxwidth[2], "%d", PX);
	(void) sprintf(&pxlength[2], "%d", PY);

	/*
	 * Figure out whether the local machine is the same as the remote 
	 * machine entry (if it exists).  If not, then ignore the local
	 * queue information.
	 */
	 if (RM != (char *) NULL && *RM) {
		char name[256];
		struct hostent *hp;

		/* get the standard network name of the local host */
		Gethostname(name, sizeof(name));
		name[sizeof(name)-1] = '\0';
		hp = gethostbyname(name);
		if (hp == (struct hostent *) NULL) {
		    syslog(LOG_ERR,
			"unable to get network name for local machine %s",
			name);
		    goto localcheck_done;
		} else strcpy(name, hp->h_name);

		/* get the standard network name of RM */
		hp = gethostbyname(RM);
		if (hp == (struct hostent *) NULL) {
		    syslog(LOG_ERR,
			"unable to get hostname for remote machine %s", RM);
		    goto localcheck_done;
		}

		/* if printer is not on local machine, ignore LP */
		if (strcmp(name, hp->h_name) != 0) {
			*LP = '\0';
			remote = 1;
		}
	}
localcheck_done:

	AF = !pentry ? (char *) NULL : pgetstr("af", &bp);
	OF = !pentry ? (char *) NULL : pgetstr("of", &bp);
	IF = !pentry ? (char *) NULL : pgetstr("if", &bp);
	RF = !pentry ? (char *) NULL : pgetstr("rf", &bp);
	TF = !pentry ? (char *) NULL : pgetstr("tf", &bp);
	NF = !pentry ? (char *) NULL : pgetstr("nf", &bp);
	DF = !pentry ? (char *) NULL : pgetstr("df", &bp);
	GF = !pentry ? (char *) NULL : pgetstr("gf", &bp);
	VF = !pentry ? (char *) NULL : pgetstr("vf", &bp);
	CF = !pentry ? (char *) NULL : pgetstr("cf", &bp);
	TR = !pentry ? (char *) NULL : pgetstr("tr", &bp);
	RS = !pentry ? 0 : pgetflag("rs");
	SF = !pentry ? 0 : pgetflag("sf");
	SH = !pentry ? 0 : pgetflag("sh");
	SB = !pentry ? 0 : pgetflag("sb");
	HL = !pentry ? 0 : pgetflag("hl");
	RW = !pentry ? 0 : pgetflag("rw");
	BR = !pentry ? 0 : pgetnum("br");
	if (!pentry || (FC = pgetnum("fc")) < 0)
		FC = 0;
	if (!pentry || (FS = pgetnum("fs")) < 0)
		FS = 0;
	if (!pentry || (XC = pgetnum("xc")) < 0)
		XC = 0;
	if (!pentry || (XS = pgetnum("xs")) < 0)
		XS = 0;
	tof = !pentry ? 0 : !pgetflag("fo");
}

/*
 * Acquire remote connection.
 */
openpr()
{
	register int i, n;
	int resp;

	if (*LP) {
		status("%s is ready and printing", printer);
	} else if (RM != NULL) {
		for (i = 1; ; i = i < 256 ? i << 1 : i) {
			resp = -1;
			pfd = getport(RM);
			if (pfd >= 0) {
				(void) sprintf(line, "\2%s\n", RP);
				n = strlen(line);
				if (t_snd(pfd, line, n, 0) == n &&
				    (resp = response()) == '\0')
					break;

				syslog(LOG_WARNING,
					"%s: openpr: remote command failed",
					printer);
					(void) t_unbind(pfd);
					(void) t_close(pfd);
			}
			if (i == 1) {
				if (resp < 0)
					status("waiting for %s to come up", RM);
				else {
					status("waiting for queue to be enabled on %s", RM);
					i = 256;
				}
			}
			sleep(i);
		}
		status("sending to %s", RM);
		remote = 1;
	} else {
		syslog(LOG_ERR, "%s: no line printer device or host name",
			printer);
		exit(1);
	}
}

/*VARARGS1*/
status(msg, a1, a2, a3)
	char *msg;
{
	register int fd, fd1;
	char buf[BUFSIZ];

	umask(0);
	fd = open(ST, O_WRONLY|O_CREAT, 0664);
	if (fd < 0 || fcntl(fd, F_SETLK, EXCL_LOCK) < 0) {
		syslog(LOG_ERR, "%s: %s: %m", printer, ST);
		exit(1);
	}

	/*
	 * The following code is attempting to truncate the status
	 * file while maintaining the exclusive lock.  A hole exists
	 * between the unlink() and link().
	 */
	(void) sprintf(buf, "%s.1", ST);
	fd1 = open(buf, O_WRONLY|O_CREAT|O_TRUNC, 0664);
	if (fd1 < 0 || fcntl(fd1, F_SETLK, EXCL_LOCK) < 0) {
		syslog(LOG_ERR, "%s: %s: %m", printer, buf);
		exit(1);
	}

	(void) unlink(ST);
	if (link(buf, ST) < 0) {
		syslog(LOG_ERR, "%s: link: %s: %m", printer, buf);
		exit(1);
	}

	(void) unlink(buf);
	(void) close(fd);
	fd = fd1;
	/* end of truncation code */

	sprintf(buf, msg, a1, a2, a3);
	strcat(buf, "\n");
	(void) write(fd, buf, strlen(buf));
	(void) close(fd);
}

local_print(cf_list)
	char *cf_list[];
{
	register int i;
	int fd;
	struct stat sbuf;

	openpr();
	for (i = 0; cf_list[i] != (char *) NULL; ++i) {
		if (stat(cf_list[i], &sbuf) < 0)
			continue;
		printit(cf_list[i]);
	}
}
