#	START NEW ARIX SCCS HEADER
#
#	@(#) lpd.mk: version 25.1 created on 12/2/91 at 16:12:48
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	@(#)lpd.mk	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation
#
#	END NEW ARIX SCCS HEADER
#
#	Copyright (c) 1984 AT&T
#	  All Rights Reserved

#	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T
#	The copyright notice above does not evidence any
#	actual or intended publication of such source code.

#ident	"@(#)nlp:cmd/lpsched/Makefile	1.10"
#
# Makefile for the lpsched command
#
include $(IROOT)/macdefs

# This is a posix binary.  Turn off the SVID flag
SVID_FLAG=

USRLIB	=	$(ROOT)/usr/lib
LIBDIR	=	../../lib

AR		= /bin/ar
RM		= /bin/rm -f
MV		= /bin/mv
CP		= /bin/cp
LN		= /bin/ln

LIBNET  =   -L../.. $(LIBDIR)/bsd/libbsd.a -lnet
#
# Define MALLOC_3X if you are using malloc(3X). Link it in
# by defining LDMALLOC=-lmalloc.
#

#MALLOC_3X	= -DMALLOC_3X -DDEF_MXFAST=32 -DDEF_NLBLKS=32 -DDEF_GRAIN=4
MALLOC_3X	=
#LDMALLOC	= -lmalloc
LDMALLOC	=
#TRACE_MALLOC	= -DTRACE_MALLOC
LDDEBUG		=

DEBUG	=

INC	=	/usr/include
LPINC	=	-I../../include -I../../tcp

LOCAL_CFLAGS	=	$(DEBUG) $(LPINC) $(MALLOC_3X)

SRCS	=	lpd.c printjob.c recvjob.c displayq.c rmjob.c \
		startdmn.c lpdchar.c common.c printcap.c

OBJS	=	$(SRCS:.c=.o)

all:		lpd

install:	all
	$(INS) 	lpd	$(USRLIB)/lpd
	chmod	6755	$(USRLIB)/lpd
	chown	root	$(USRLIB)/lpd
	chgrp	bin	$(USRLIB)/lpd

clean:
	$(RM) $(OBJS)

clobber:	clean
	$(RM) lpd

strip:
	$(STRIP) lpd


lpd:	$(OBJS)
	$(CC) $(DEBUG) -o lpd $(OBJS) $(LDFLAGS) \
					$(LIBNET) \
				-lnsl_s \
					$(LDMALLOC) \
					$(LDDEBUG)

$(OBJS):	lp.h lp.local.h
	$(CC) $(CFLAGS) -c $<
