/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) lpd.c: version 25.1 created on 12/2/91 at 16:12:44	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)lpd.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 * @(#)lpd.c	25.1
 */

#ifndef lint
/* char copyright[] =
"@(#) Copyright (c) 1983 Regents of the University of California.\n\
 All rights reserved.\n"; */
#endif /* not lint */

#ifndef lint
/* static char sccsid[] = "@(#)lpd.c	5.4 (Berkeley) 5/6/86"; */
#endif /* not lint */

/*
 * lpd -- line printer daemon.
 *
 * Listen for a connection and perform the requested operation.
 * Operations are:
 *	\1printer\n
 *		check the queue for jobs and print any found.
 *	\2printer\n
 *		receive a job from another machine and queue it.
 *	\3printer [users ...] [jobs ...]\n
 *		return the current state of the queue (short form).
 *	\4printer [users ...] [jobs ...]\n
 *		return the current state of the queue (long form).
 *	\5printer person [users ...] [jobs ...]\n
 *		remove jobs from the queue.
 *
 * Strategy to maintain protected spooling area:
 *	1. Spooling area is writable only by daemon and spooling group
 *	2. lpr runs setuid root and setgrp spooling group; it uses
 *	   root to access any file it wants (verifying things before
 *	   with an access call) and group id to know how it should
 *	   set up ownership of files in the spooling area.
 *	3. Files in spooling area are owned by root, group spooling
 *	   group, with mode 660.
 *	4. lpd, lpq and lprm run setuid daemon and setgrp spooling group to
 *	   access files and printer.  Users can't get to anything
 *	   w/o help of lpq and lprm programs.
 */

#include "lp.h"

#ifdef	A1000
#  define	SIGCHLD	SIGCLD
#endif

int	lflag = 0;				/* log requests flag */
long	Open_max;
int	Daemon = -1;				/* transport for daemon */
int rport = IPPORT_RESERVED - 1;

void	reapchild();
void	mcleanup();

main(argc, argv)
	int argc;
	char **argv;
{
	int f, finet, options;
	int lfd, tfd;
	struct sigaction	act;
	struct sockaddr_in sin, *inetaddr;
	struct t_info	tinfo;
	struct t_call	*call;
	struct t_bind	*bindreq;
	struct servent	*sp;
	char *p;

	Gethostname(host, sizeof(host));
	name = argv[0];

	while (--argc > 0) {
		argv++;
		if (argv[0][0] == '-')
			switch (argv[0][1]) {
			case 'l':
				lflag++;
				break;
			}
	}

#ifndef DEBUG
	/*
	 * Set up standard environment by detaching from the parent.
	 */
	if (fork())
		exit(0);
	for (f = 0; f < 5; f++)
		(void) close(f);
	(void) setsid();
	(void) open("/dev/null", O_RDONLY);
	(void) open("/dev/null", O_WRONLY);
	(void) dup(1);
#endif
	openlog("lpd", LOG_PID, LOG_LPR);
	(void) umask(0);

	lfd = open(MASTERLOCK, O_WRONLY|O_CREAT, 0644);
	if (lfd < 0) {
		syslog(LOG_ERR, "%s: %m", MASTERLOCK);
		exit(1);
	}

	if (fcntl(lfd, F_SETLK, EXCL_LOCK) < 0) {
		/* see if active deamon present */
		if (errno == EACCES || errno == EAGAIN)
			exit(0);

		syslog(LOG_ERR, "%s: %m", MASTERLOCK);
		exit(1);
	}

	/*
	 * This section of code is to try and get around the
	 * inability to truncate an opened and locked file
	 * descriptor.
	 */
	tfd = open(MASTERTEMP, O_WRONLY|O_CREAT|O_TRUNC, 0644);
	if (tfd < 0) {
		syslog(LOG_ERR, "%s: %m", MASTERTEMP);
		exit(1);
	}

	/*
	 * Lock the temporary file
	 */
	if (fcntl(tfd, F_SETLK, EXCL_LOCK) < 0) {
		syslog(LOG_ERR, "%s: %m", MASTERTEMP);
		exit(1);
	}

	(void) unlink(MASTERLOCK);

	/*
	 * This comment is symbolic of the gap between the previous
	 * unlink() and following link() of MASTERLOCK.  If another
	 * daemon creates MASTERLOCK during this small interval,
	 * the following link will fail and we will want to exit because
	 * the other process will have no way of knowing we exist.
	 * We should let it become the daemon.
	 */
	if (link(MASTERTEMP, MASTERLOCK) < 0) {
		syslog(LOG_ERR, "link: %s: %m", MASTERLOCK);
		(void) unlink(MASTERTEMP);
		exit(1);
	}

	(void) unlink(MASTERTEMP);
	(void) close(lfd);
	lfd = tfd;

	/*
	 * write process id for others to know
	 */
	sprintf(line, "%u\n", getpid());
	f = strlen(line);
	if (write(lfd, line, f) != f) {
		syslog(LOG_ERR, "%s: %m", MASTERLOCK);
		exit(1);
	}

	/* catch SIGCHLD */
	sigemptyset(&act.sa_mask);
	act.sa_handler = reapchild;
	act.sa_flags = SA_NOCLDSTOP;
	(void) sigaction(SIGCHLD, &act, NULL);

	/*
	 * Restart all the printers.
	 */
	startup();

	sigemptyset(&act.sa_mask);
	act.sa_handler = mcleanup;
	act.sa_flags = 0;
	(void) sigaction(SIGHUP, &act, NULL);
	(void) sigaction(SIGINT, &act, NULL);
	(void) sigaction(SIGQUIT, &act, NULL);
	(void) sigaction(SIGTERM, &act, NULL);

	finet = t_open(TLI_DEV, O_RDWR, &tinfo);
	if (finet < 0) {
		tsyslog(LOG_ERR, finet, "t_open");
		mcleanup();
	}

	sp = getservbyname("printer", "tcp");
	if (sp == NULL) {
		syslog(LOG_ERR, "printer/tcp: unknown service");
		mcleanup();
	}

	/*
	 * Setup t_bind request structure
	 */
	sin.sin_family = htons(AF_INET);
	sin.sin_port = sp->s_port;
	sin.sin_addr.s_addr = htonl(INADDR_ANY);

	bindreq = (struct t_bind *) t_alloc(finet, T_BIND, T_ALL);
	if (bindreq == (struct t_bind *) NULL) {
		tsyslog(LOG_ERR, finet, "t_alloc");
		mcleanup();
	}

	bindreq->addr.maxlen = bindreq->addr.len = tinfo.addr;
	bindreq->qlen = 25;	/* allow 5 pending connect requests */
	inetaddr = (struct sockaddr_in *) (bindreq->addr.buf);
	(void) memcpy((char *) inetaddr, (char *) &sin,
			bindreq->addr.len);

	/*
	 * Bind to service port
	 */
	if (t_bind(finet, bindreq, bindreq) < 0) {
		tsyslog(LOG_ERR, finet, "t_bind");
		mcleanup();
	}

	/*
	 * Make sure we got the right port!
	 */
	inetaddr = (struct sockaddr_in *) (bindreq->addr.buf);
	if (inetaddr->sin_port != sin.sin_port)
	{
		syslog(LOG_ERR, "t_bind: not service port: %d",
				ntohs(inetaddr->sin_port));
		mcleanup();
	}

	/*
	 * Initialize for loop
	 */
	call = (struct t_call *) t_alloc(finet, T_CALL, T_ADDR|T_OPT);
	if (call == (struct t_call *) NULL) {
		tsyslog(LOG_ERR, finet, "t_alloc");
		mcleanup();
	}

	/*
	 * Main loop: accept, do a request, continue.
	 */
	for (;;) {
		int s;
		struct t_info	x;

		call->addr.maxlen = tinfo.addr;
		call->opt.maxlen = tinfo.options;
		call->udata.maxlen = 0;

		/*
		 * Listen for connections
		 */
loop:
		if (t_listen(finet, call) < 0) {
			if(errno != EINTR) {
				tsyslog(LOG_WARNING, finet, "t_listen");
			}
			else {
				goto loop;
			}
			continue;
		}

		Daemon = t_open(TLI_DEV, O_RDWR, &x);
		if (Daemon < 0) {
			tsyslog(LOG_WARNING, Daemon, "t_open");
			(void) t_snddis(finet, call);
			continue;
		}

		if (t_bind(Daemon, (struct t_bind *) NULL,
			(struct t_bind *) NULL) < 0)
		{
			tsyslog(LOG_WARNING, Daemon, "t_bind");
			(void) t_snddis(finet, call);
			(void) t_close(Daemon);
			continue;
		}

		if (t_accept(finet, Daemon, call) < 0) {
			tsyslog(LOG_WARNING, finet, "t_accept");
			(void) t_snddis(finet, call);
			(void) t_unbind(Daemon);
			(void) t_close(Daemon);
			continue;
		}

		if (fork() == 0) {
			sigemptyset(&act.sa_mask);
			act.sa_handler = SIG_IGN;
			act.sa_flags = 0;
			(void) sigaction(SIGHUP, &act, NULL);
			(void) sigaction(SIGINT, &act, NULL);
			(void) sigaction(SIGQUIT, &act, NULL);
			(void) sigaction(SIGTERM, &act, NULL);
			act.sa_handler = SIG_DFL;
			(void) sigaction(SIGCHLD, &act, NULL);

			/*
			 * Set file descriptors properly
			 */
			(void) close(finet);

			if ((s = t_sync(Daemon)) < 0) {
				tsyslog(LOG_ERR, Daemon, "t_sync");
				exit(1);
			}

			if (s != T_DATAXFER)
				syslog(LOG_WARNING, "state: %d", s);

			chkhost(call);	/* verify host */
			doit();

			(void) t_unbind(Daemon);
			(void) t_close(Daemon);
			exit(0);
		}

		(void) t_close(Daemon);
	}
}

void
reapchild()
{
	int status;

#ifdef	A1000
	(void) wait(&status);
#else
	while (waitpid(-1, &status, WNOHANG) > 0)
		;
#endif
}

void
mcleanup()
{
	if (lflag)
		syslog(LOG_INFO, "exiting");
	exit(0);
}

/*
 * Stuff for handling job specifications
 */
char	*user[MAXUSERS];	/* users to process */
int	users;			/* # of users in user array */
int	requ[MAXREQUESTS];	/* job number of spool entries */
int	requests;		/* # of spool requests */
char	*person;		/* name of person doing lprm */

char	fromb[32];	/* buffer for client's machine name */
char	cbuf[BUFSIZ];	/* command line buffer */
char	*cmdnames[] = {
	"null",
	"printjob",
	"recvjob",
	"displayq short",
	"displayq long",
	"rmjob"
};

doit()
{
	register char *cp;
	register int n;
	int flags;

	for (;;) {
		cp = cbuf;
		do {
			if (cp >= &cbuf[sizeof(cbuf) - 1])
				fatal("Command line too long");
			if ((n = t_rcv(Daemon, cp, 1, &flags)) != 1) {
				if (n < 0)
					fatal("Lost connection");
				syslog(LOG_WARNING, "lost connection: %m");
				return;
			}
		} while (*cp++ != '\n');
		*--cp = '\0';
		cp = cbuf;
		if (lflag) {
			if (*cp >= '\1' && *cp <= '\5')
				syslog(LOG_INFO, "%s requests %s %s",
					from, cmdnames[*cp], cp+1);
			else
				syslog(LOG_INFO, "bad request (%d) from %s",
					*cp, from);
		}
		switch (*cp++) {
		case '\1':	/* check the queue and print any jobs there */
			printer = cp;
			printjob();
			break;
		case '\2':	/* receive files to be queued */
			printer = cp;
			recvjob();
			break;
		case '\3':	/* display the queue (short form) */
		case '\4':	/* display the queue (long form) */
			printer = cp;
			while (*cp) {
				if (*cp != ' ') {
					cp++;
					continue;
				}
				*cp++ = '\0';
				while (isspace(*cp))
					cp++;
				if (*cp == '\0')
					break;
				if (isdigit(*cp)) {
					if (requests >= MAXREQUESTS)
						fatal("Too many requests");
					requ[requests++] = atoi(cp);
				} else {
					if (users >= MAXUSERS)
						fatal("Too many users");
					user[users++] = cp;
				}
			}
			displayq(cbuf[0] - '\3');
			drop_connect(Daemon);
			exit(0);
		case '\5':	/* remove a job from the queue */
			printer = cp;
			while (*cp && *cp != ' ')
				cp++;
			if (!*cp)
				break;
			*cp++ = '\0';
			person = cp;
			while (*cp) {
				if (*cp != ' ') {
					cp++;
					continue;
				}
				*cp++ = '\0';
				while (isspace(*cp))
					cp++;
				if (*cp == '\0')
					break;
				if (isdigit(*cp)) {
					if (requests >= MAXREQUESTS)
						fatal("Too many requests");
					requ[requests++] = atoi(cp);
				} else {
					if (users >= MAXUSERS)
						fatal("Too many users");
					user[users++] = cp;
				}
			}
			rmjob();
			break;
		}
		fatal("Illegal service request");
	}
}

/*
 * Make a pass through the printcap database and start printing any
 * files left from the last time the machine went down.
 */
startup()
{
	char buf[BUFSIZ];
	register char *cp;
	int pid;

	printer = buf;
#ifdef	A1000
	Open_max = OPEN_MAX;
#else
	Open_max = sysconf(_SC_OPEN_MAX);
#endif

	/*
	 * Restart the daemons.
	 */
	while (getprent(buf) > 0) {
		for (cp = buf; *cp; cp++)
			if (*cp == '|' || *cp == ':') {
				*cp = '\0';
				break;
			}
		if (strcmp(printer, "local") == 0)
			continue;
		if ((pid = fork()) < 0) {
			syslog(LOG_WARNING, "startup: cannot fork");
			mcleanup();
		}
		if (!pid) {
/* REE - for some reason, closing file in child closes parent also
			endprent();
END REE */
			printjob();
		}
	}
	printer=NULL;
}

#define DUMMY ":nobody::"

/*
 * Check to see if the from host has access to the line printer.
 */
chkhost(call)
	struct t_call *call;
{
	register struct hostent *hp;
	register FILE *hostf;
	register char *cp, *sp;
	struct sockaddr_in	*f;
	char ahost[50];
	int first = 1;
	int baselen = -1;

	f = (struct sockaddr_in *) (call->addr.buf);
	f->sin_family = AF_INET;
	f->sin_port = ntohs(f->sin_port);
	if (f->sin_family != AF_INET || f->sin_port >= IPPORT_RESERVED)
	{
		syslog(LOG_ERR, "sockaddr incorrect: family: %d: port: %d",
				f->sin_family, f->sin_port);
		fatal("Malformed from address");
	}
	hp = gethostbyaddr(&f->sin_addr, sizeof(struct in_addr), f->sin_family);
	if (hp == 0) {
		syslog(LOG_ERR, "unknown host address (%s)",
			inet_ntoa(f->sin_addr));
		fatal("Host name for your address (%s) unknown",
			inet_ntoa(f->sin_addr));
	}

	strcpy(fromb, hp->h_name);
	from = fromb;
	if (!strcmp(from, host))
		return;

	sp = fromb;
	cp = ahost;
	while (*sp) {
		if (*sp == '.') {
			if (baselen == -1)
				baselen = sp - fromb;
			*cp++ = *sp++;
		} else {
			*cp++ = isupper(*sp) ? tolower(*sp++) : *sp++;
		}
	}
	*cp = '\0';
/* REE - this is only commented out due to lack of "bsd" library
 *     - it can be uncommentd when the _validuser routine is aquired
	hostf = fopen("/etc/hosts.equiv", "r");
again:
	if (hostf) {
		if (!_validuser(hostf, ahost, DUMMY, DUMMY, baselen)) {
			(void) fclose(hostf);
			return;
		}
		(void) fclose(hostf);
	}
	if (first == 1) {
		first = 0;
		hostf = fopen("/etc/hosts.lpd", "r");
		goto again;
	}
	syslog(LOG_WARNING, "host '%s' not authorized", ahost);
	fatal("Your host does not have line printer access");
END REE */
	return;
}
