/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) lp.h: version 25.1 created on 12/2/91 at 16:12:29	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)lp.h	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)lp.h	5.1 (Berkeley) 6/6/85
 */

/*
 * Global definitions for the line printer system.
 */

#include "stdio.h"
#include "fcntl.h"
#include "dirent.h"
#include "sys/stat.h"
#include "sys/socket.h"
#ifdef	S3000
#  include "sys/in.h"
#else
#  include "sys/in.h"
#endif
#include "arpa/inet.h"
#include "netdb.h"
#include "tiuser.h"
#include "unistd.h"
#include "pwd.h"
#include "syslog.h"
#include "signal.h"
#include "sys/wait.h"
#include "sys/termios.h"
#include "ctype.h"
#include "errno.h"
#include "memory.h"
#include "string.h"
#ifdef	A1000
#  include "limits.h"
#endif
#include "lp.local.h"

extern int	DU;		/* daeomon user-id */
extern int	MX;		/* maximum number of blocks to copy */
extern int	MC;		/* maximum number of copies allowed */
extern char	*LP;		/* line printer device name */
extern char	*RM;		/* remote machine name */
extern char	*RG;		/* restricted group */
extern char	*RP;		/* remote printer name */
extern char	*LO;		/* lock file name */
extern char	*ST;		/* status file name */
extern char	*SD;		/* spool directory */
extern char	*AF;		/* accounting file */
extern char	*LF;		/* log file for error messages */
extern char	*OF;		/* name of output filter (created once) */
extern char	*IF;		/* name of input filter (created per job) */
extern char	*RF;		/* name of fortran text filter (per job) */
extern char	*TF;		/* name of troff(1) filter (per job) */
extern char	*NF;		/* name of ditroff(1) filter (per job) */
extern char	*DF;		/* name of tex filter (per job) */
extern char	*GF;		/* name of graph(1G) filter (per job) */
extern char	*VF;		/* name of raster filter (per job) */
extern char	*CF;		/* name of cifplot filter (per job) */
extern char	*FF;		/* form feed string */
extern char	*TR;		/* trailer string to be output when Q empties */
extern short	SC;		/* suppress multiple copies */
extern short	SF;		/* suppress FF on each print job */
extern short	SH;		/* suppress header page */
extern short	SB;		/* short banner instead of normal header */
extern short	HL;		/* print header last */
extern short	RW;		/* open LP for reading and writing */
extern short	PW;		/* page width */
extern short	PX;		/* page width in pixels */
extern short	PY;		/* page length in pixels */
extern short	PL;		/* page length */
extern short	BR;		/* baud rate if lp is a tty */
extern int	FC;		/* flags to clear if lp is a tty (UNSUPPORTED)*/
extern int	FS;		/* flags to set if lp is a tty (UNSUPPORTED) */
extern int	XC;		/* flags to clear for local mode (UNSUPPORTED)*/
extern int	XS;		/* flags to set for local mode (UNSUPPORTED) */
extern short	RS;		/* restricted to those with local accounts */

extern char	line[BUFSIZ];
extern char	pbuf[];		/* buffer for printcap entry */
extern char	*bp;		/* pointer into ebuf for pgetent() */
extern char	*name;		/* program name */
extern char	*printer;	/* printer name */
extern char	host[32];	/* host machine name */
extern char	*from;		/* client's machine name */
extern long	Open_max;	/* max open files per process */
extern int	Daemon;		/* transport-endpoint for daemon */
extern int	errno;

static struct flock	shlock = { F_RDLCK, SEEK_SET, 0, 0 };
static struct flock	exlock = { F_WRLCK, SEEK_SET, 0, 0 };
#define	SHARED_LOCK	&shlock
#define	EXCL_LOCK	&exlock

/*
 * Structure used for building a sorted list of control files.
 */
struct queue {
	time_t	q_time;			/* modification time */
	char	q_name[MAXNAMLEN+1];	/* control file name */
};

/*
 * local routines declarations
 */
extern char	*pgetstr();

/*
 * system routines that need extern declarations
 */
#ifdef	S3000
extern char		*strdup();
extern struct passwd	*getpwnam();
#endif

#ifdef	notdef
extern char	*getenv();
extern void	free();
extern void	qsort();
extern void	exit();
extern char	*t_alloc();
#endif
