/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) displayq.c: version 25.1 created on 12/2/91 at 16:12:22	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)displayq.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 * @(#)displayq.c	25.1
 */

#ifndef lint
/* static char sccsid[] = "@(#)displayq.c	5.1 (Berkeley) 6/6/85"; */
#endif /* not lint */

/*
 * Routines to display the state of the queue.
 */

#include "lp.h"

#define JOBCOL	40		/* column for job # in -l format */
#define OWNCOL	7		/* start of Owner column in normal */
#define SIZCOL	62		/* start of Size column in normal */

/*
 * Stuff for handling job specifications
 */
extern char	*user[];	/* users to process */
extern int	users;		/* # of users in user array */
extern int	requ[];		/* job number of spool entries */
extern int	requests;	/* # of spool requests */

int	lflag;		/* long output option */
char	current[40];	/* current file being printed */
int	garbage;	/* # of garbage cf files */
int	rank;		/* order to be printed (-1=none, 0=active) */
long	totsize;	/* total print job size in bytes */
int	first;		/* first file in ``files'' column? */
int	col;		/* column on screen */
int	sendtorem;	/* are we sending to a remote? */
char	file[132];	/* print file name */

char	*head0 = "Rank   Owner      Job  Files";
char	*head1 = "Total Size\n";

/*
 * Display the current state of the queue. Format = 1 if long format.
 */
displayq(format)
	int format;
{
	register struct queue *q;
	register int i, nitems, fd;
	struct queue **queue;
	struct stat statb;
	char buf[BUFSIZ];	/* for sprintf() */
	FILE *fp;
	int flags;

	lflag = format;
	totsize = 0;
	rank = -1;

	init();

	if (*LP != '\0') {
		return(lp_queue(format));
	}

	/*
	 * If there is no local printer, then print the queue on
	 * the remote machine and then what's in the queue here.
	 * Note that a file in transit may not show up in either queue.
	 */
	if (*LP == '\0') {
		register char *cp;
		char c;

		sendtorem++;
		(void) sprintf(line, "%c%s", format + '\3', RP);
		cp = line;
		for (i = 0; i < requests; i++) {
			cp += strlen(cp);
			(void) sprintf(cp, " %d", requ[i]);
		}
		for (i = 0; i < users; i++) {
			cp += strlen(cp);
			*cp++ = ' ';
			strcpy(cp, user[i]);
		}
		strcat(line, "\n");
		fd = getport(RM);
		if (fd < 0) {
			if (from != host) {
				(void) sprintf(buf, "%s: ", host);
				(void) t_snd(Daemon, buf, strlen(buf), 0);
			}
			(void) sprintf(buf, "connection to %s is down\n", RM);
			(void) t_snd(Daemon, buf, strlen(buf), 0);
		} else {
			i = strlen(line);
			if (t_snd(fd, line, i, 0) != i)
				fatal("Lost connection");

			while ((i = t_rcv(fd, line, sizeof(line), &flags)) > 0){
				(void) t_snd(Daemon, line, i, 0);
			}

			(void) t_rcvdis(fd, NULL);
			(void) t_unbind(fd);
			(void) t_close(fd);
		}
	}
	/*
	 * Find all the control files in the spooling directory
	 */
	if (chdir(SD) < 0)
		fatal("cannot chdir to spooling directory");
	if ((nitems = getq(&queue)) < 0)
		fatal("cannot examine spooling area\n");
	if (stat(LO, &statb) >= 0) {
		if ((statb.st_mode & 0110) && sendtorem)
			(void) t_snd(Daemon, "\n", 1, 0);

		if (statb.st_mode & 0100) {
			if (sendtorem) {
				(void) sprintf(buf, "%s: ", host);
				(void) t_snd(Daemon, buf, strlen(buf), 0);
			}


			(void) sprintf(buf, "Warning: %s is down: ", printer);
			(void) t_snd(Daemon, buf, strlen(buf), 0);

			fd = open(ST, O_RDONLY);
			if (fd >= 0) {
				(void) fcntl(fd, F_SETFL, SHARED_LOCK);

				while ((i = read(fd, line, sizeof(line))) > 0)
					(void) t_snd(Daemon, line, i, 0);

				(void) close(fd);	/* unlocks as well */
			} else
				(void) t_snd(Daemon, "\n", 1, 0);
		}
		if (statb.st_mode & 010) {
			if (sendtorem) {
				(void) sprintf(buf, "%s: ", host);
				(void) t_snd(Daemon, buf, strlen(buf), 0);
			}
			(void) sprintf(buf, "Warning: %s queue is turned off\n",
					printer);
			(void) t_snd(Daemon, buf, strlen(buf), 0);
		}
	}
	if (nitems == 0) {
		if (!sendtorem) {
			(void) sprintf(buf, "no entries\n");
			(void) t_snd(Daemon, buf, strlen(buf), 0);
		}
		return(0);
	}

	fp = fopen(LO, "r");
	if (fp == NULL)
		warn();
	else {
		register char *cp;

		/* get daemon pid */
		cp = current;
		while ((*cp = getc(fp)) != EOF && *cp != '\n')
			cp++;
		*cp = '\0';
		i = atoi(current);
		if (i <= 0 || kill(i, 0) < 0)
			warn();
		else {
			/* read current file name */
			cp = current;
			while ((*cp = getc(fp)) != EOF && *cp != '\n')
				cp++;
			*cp = '\0';
			/*
			 * Print the status file.
			 */
			if (sendtorem) {
				(void) sprintf(buf, "\n%s: ", host);
				(void) t_snd(Daemon, buf, strlen(buf), 0);
			}

			fd = open(ST, O_RDONLY);
			if (fd >= 0) {
				(void) fcntl(fd, F_SETLK, SHARED_LOCK);

				while ((i = read(fd, line, sizeof(line))) > 0)
					(void) t_snd(Daemon, line, i, 0);

				(void) close(fd);	/* unlocks as well */
			} else
				(void) t_snd(Daemon, "\n", 1, 0);
		}
		(void) fclose(fp);
	}
	/*
	 * Now, examine the control files and print out the jobs to
	 * be done for each user.
	 */
	if (!lflag)
		header();
	for (i = 0; i < nitems; i++) {
		q = queue[i];
		inform(q->q_name);
		free(q);
	}
	free(queue);
	return(nitems-garbage);
}

int
lp_queue(format)
	int format;
{
	char	buf[BUFSIZ], obuf[BUFSIZ];
	char	usr[80];
	char	*p;
	int	pd[2];
	int	pid, status;
	int	num, n;
	int	job, bytes;
	FILE	*fp;
	struct sigaction	act, oact;

	/*
	 * Set action for SIGCHLD to default (ignore signal).
	 */
	act.sa_handler = SIG_DFL;
	act.sa_flags = 0;
	sigemptyset(&act.sa_mask);
	(void) sigaction(SIGCHLD, &act, &oact);

	/*
	 * Use 'lpstat' to get needed information.
	 */

	/*
	 * Get printer status
	 */
	(void) pipe(pd);
	if ((pid = fork()) == 0) {
		/*
		 * We want stdout and stderr
		 */
		(void) close(pd[0]);
		(void) dup2(pd[1], 1);
		(void) dup2(pd[1], 2);
		(void) close(pd[1]);

		setuid(DU);
		(void) execlp("lpstat", "lpstat", "-p", printer, 0);
		syslog(LOG_ERR, "execlp: %m");
		exit(1);
	}

	/*
	 * For now just pass printer status straight through
	 */
	(void) close(pd[1]);
	while ((n = read(pd[0], buf, BUFSIZ)) > 0)
		(void) t_snd(Daemon, buf, n, 0);

	(void) close(pd[0]);

	/*
	 * wait on process
	 */
	(void) waitpid(pid, &status, 0);

	/*
	 * long format currently unsupported
	 *	(no hostnames or filenames)
	 */
/* REE - for now let long format fall thru to print queues 
	if (format) {
		p = "Warning: long status information unavailable.\n";
		t_snd(Daemon, p, strlen(p), 0);
		(void) sigaction(SIGCHLD, &oact, NULL);
		return(0);
	}
END REE */

	/*
	 * Get request queue
	 */
	(void) pipe(pd);
	if ((pid = fork()) == 0) {
		/*
		 * We want stdout and stderr
		 */
		(void) close(pd[0]);
		(void) dup2(pd[1], 1);
		(void) dup2(pd[1], 2);
		(void) close(pd[1]);

		(void) execlp("lpstat", "lpstat", "-o", printer, 0);
		syslog(LOG_ERR, "execlp: %m");
		exit(1);
	}

	(void) close(pd[1]);
	fp = fdopen(pd[0], "r");

	header();

	/*
	 * Translate queue into readable form
	 */
	for (num = 0; fgets(buf, BUFSIZ, fp) != NULL;) {
		(void) sscanf(buf, "%*[^-]-%d %s %d %*s\n", &job, usr, &bytes);

		col = 0;
		prank(++num);
		blankfill(OWNCOL);
		(void) sprintf(obuf, "%-10.10s %-4d ", usr, job);
		(void) t_snd(Daemon, obuf, strlen(obuf), 0);
		col += 16;
		(void) t_snd(Daemon, "Unknown", 7, 0);
		col += 7;
		blankfill(SIZCOL);
		(void) sprintf(obuf, "%d bytes\n", bytes);
		(void) t_snd(Daemon, obuf, strlen(obuf), 0);
	}

	(void) close(pd[0]);

	/*
	 * wait on process
	 */
	(void) waitpid(pid, &status, 0);

	/*
	 * restore signal actions
	 */
	(void) sigaction(SIGCHLD, &oact, NULL);
	return(num);
}

/*
 * Print a warning message if there is no daemon present.
 */
warn()
{
	char buf[BUFSIZ];

	if (sendtorem) {
		(void) sprintf(buf, "\n%s: ", host);
		(void) t_snd(Daemon, buf, strlen(buf), 0);
	}

	(void) sprintf(buf, "Warning: no daemon present\n");
	(void) t_snd(Daemon, buf, strlen(buf), 0);
	current[0] = '\0';
}

/*
 * Print the header for the short listing format
 */
header()
{

	(void) t_snd(Daemon, head0, strlen(head0), 0);
	col = strlen(head0)+1;
	blankfill(SIZCOL);
	(void) t_snd(Daemon, head1, strlen(head1), 0);
}

inform(cf)
	char *cf;
{
	register int j, k;
	register char *cp;
	char buf[BUFSIZ];
	FILE *cfp;

	/*
	 * There's a chance the control file has gone away
	 * in the meantime; if this is the case just keep going
	 */
	if ((cfp = fopen(cf, "r")) == NULL)
		return;

	if (rank < 0)
		rank = 0;
	if (sendtorem || garbage || strcmp(cf, current))
		rank++;
	j = 0;
	while (getline(cfp)) {
		switch (line[0]) {
		case 'P': /* Was this file specified in the user's list? */
			if (!inlist(line+1, cf)) {
				fclose(cfp);
				return;
			}
			if (lflag) {
				(void) sprintf(buf, "\n%s: ", line+1);
				(void) t_snd(Daemon, buf, strlen(buf), 0);

				col = strlen(line+1) + 2;
				prank(rank);
				blankfill(JOBCOL);

				(void) sprintf(buf, " [job %s]\n", cf+3);
				(void) t_snd(Daemon, buf, strlen(buf), 0);
			} else {
				col = 0;
				prank(rank);
				blankfill(OWNCOL);

				(void) sprintf(buf, "%-10s %-3d  ",
						line+1, atoi(cf+3));
				(void) t_snd(Daemon, buf, strlen(buf), 0);

				col += 16;
				first = 1;
			}
			continue;
		default: /* some format specifer and file name? */
			if (line[0] < 'a' || line[0] > 'z')
				continue;
			if (j == 0 || strcmp(file, line+1) != 0)
				strcpy(file, line+1);
			j++;
			continue;
		case 'N':
			show(line+1, file, j);
			file[0] = '\0';
			j = 0;
		}
	}
	fclose(cfp);
	if (!lflag) {
		blankfill(SIZCOL);
		(void) sprintf(buf, "%d bytes\n", totsize);
		(void) t_snd(Daemon, buf, strlen(buf), 0);
		totsize = 0;
	}
}

inlist(name, file)
	char *name, *file;
{
	register int *r, n;
	register char **u, *cp;

	if (users == 0 && requests == 0)
		return(1);
	/*
	 * Check to see if it's in the user list
	 */
	for (u = user; u < &user[users]; u++)
		if (!strcmp(*u, name))
			return(1);
	/*
	 * Check the request list
	 */
	for (n = 0, cp = file+3; isdigit(*cp); )
		n = n * 10 + (*cp++ - '0');
	for (r = requ; r < &requ[requests]; r++)
		if (*r == n && !strcmp(cp, from))
			return(1);
	return(0);
}

show(nfile, file, copies)
	register char *nfile, *file;
{
	if (strcmp(nfile, " ") == 0)
		nfile = "(standard input)";
	if (lflag)
		ldump(nfile, file, copies);
	else
		dump(nfile, file, copies);
}

/*
 * Fill the line with blanks to the specified column
 */
blankfill(n)
	register int n;
{
	while (col++ < n)
		(void) t_snd(Daemon, " ", 1, 0);
}

/*
 * Give the abbreviated dump of the file names
 */
dump(nfile, file, copies)
	char *nfile, *file;
{
	register short n, fill;
	struct stat lbuf;

	/*
	 * Print as many files as will fit
	 *  (leaving room for the total size)
	 */
	 fill = first ? 0 : 2;	/* fill space for ``, '' */
	 if (((n = strlen(nfile)) + col + fill) >= SIZCOL-4) {
		if (col < SIZCOL) {
			(void) t_snd(Daemon, " ...", 4, 0);
			col += 4;
			blankfill(SIZCOL);
		}
	} else {
		if (first)
			first = 0;
		else
			(void) t_snd(Daemon, ", ", 2, 0);

		(void) t_snd(Daemon, nfile, strlen(nfile), 0);
		col += n+fill;
	}
	if (*file && !stat(file, &lbuf))
		totsize += copies * lbuf.st_size;
}

/*
 * Print the long info about the file
 */
ldump(nfile, file, copies)
	char *nfile, *file;
{
	char buf[BUFSIZ];
	struct stat lbuf;

	(void) t_snd(Daemon, "\t", 1, 0);

	if (copies > 1) {
		(void) sprintf(buf, "%-2d copies of %-19s", copies, nfile);
		(void) t_snd(Daemon, buf, strlen(buf), 0);
	}
	else {
		(void) sprintf(buf, "%-32s", nfile);
		(void) t_snd(Daemon, buf, strlen(buf), 0);
	}

	if (*file && !stat(file, &lbuf)) {
		(void) sprintf(buf, " %D bytes", lbuf.st_size);
		(void) t_snd(Daemon, buf, strlen(buf), 0);
	}
	else {
		(void) sprintf(buf, " ??? bytes");
		(void) t_snd(Daemon, buf, strlen(buf), 0);
	}

	(void) t_snd(Daemon, "\n", 1, 0);
}

/*
 * Print the job's rank in the queue,
 *   update col for screen management
 */
prank(n)
{
	char line[100];
	static char *r[] = {
		"th", "st", "nd", "rd", "th", "th", "th", "th", "th", "th"
	};

	if (n == 0) {
		(void) t_snd(Daemon, "active", 6, 0);
		col += 6;
		return;
	}
	if ((n/10) == 1)
		(void) sprintf(line, "%dth", n);
	else
		(void) sprintf(line, "%d%s", n, r[n%10]);
	col += strlen(line);
	(void) t_snd(Daemon, line, strlen(line), 0);
}
