/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) common.c: version 25.1 created on 12/2/91 at 16:12:18	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)common.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 * @(#)common.c	25.1
 */

#ifndef lint
/* static char sccsid[] = "@(#)common.c	5.2 (Berkeley) 5/6/86"; */
#endif /* not lint */

/*
 * Routines and data common to all the line printer functions.
 */

#include "lp.h"

int	DU;		/* daeomon user-id */
int	MX;		/* maximum number of blocks to copy */
int	MC;		/* maximum number of copies allowed */
char	*LP;		/* line printer device name */
char	*RM;		/* remote machine name */
char	*RP;		/* remote printer name */
char	*LO;		/* lock file name */
char	*ST;		/* status file name */
char	*SD;		/* spool directory */
char	*AF;		/* accounting file */
char	*LF;		/* log file for error messages */
char	*OF;		/* name of output filter (created once) */
char	*IF;		/* name of input filter (created per job) */
char	*RF;		/* name of fortran text filter (per job) */
char	*TF;		/* name of troff filter (per job) */
char	*NF;		/* name of ditroff filter (per job) */
char	*DF;		/* name of tex filter (per job) */
char	*GF;		/* name of graph(1G) filter (per job) */
char	*VF;		/* name of vplot filter (per job) */
char	*CF;		/* name of cifplot filter (per job) */
char	*PF;		/* name of vrast filter (per job) */
char	*FF;		/* form feed string */
char	*TR;		/* trailer string to be output when Q empties */
short	SC;		/* suppress multiple copies */
short	SF;		/* suppress FF on each print job */
short	SH;		/* suppress header page */
short	SB;		/* short banner instead of normal header */
short	HL;		/* print header last */
short	RW;		/* open LP for reading and writing */
short	PW;		/* page width */
short	PL;		/* page length */
short	PX;		/* page width in pixels */
short	PY;		/* page length in pixels */
short	BR;		/* baud rate if lp is a tty */
int	FC;		/* flags to clear if lp is a tty */
int	FS;		/* flags to set if lp is a tty */
int	XC;		/* flags to clear for local mode */
int	XS;		/* flags to set for local mode */
short	RS;		/* restricted to those with local accounts */

char	line[BUFSIZ];
char	pbuf[BUFSIZ/2];	/* buffer for printcap strings */
char	*bp = pbuf;	/* pointer into pbuf for pgetent() */
char	*name;		/* program name */
char	*printer=NULL;	/* printer name */
char	host[32];	/* host machine name */
char	*from = host;	/* client's machine name */
extern int t_errno;

/*
 * Create a connection to the remote printer server.
 * Most of this code comes from rcmd.c. (not anymore)
 */
getport(rhost)
	char *rhost;
{
	int s, lport, rport = IPPORT_RESERVED - 1;
	int event;
	struct hostent		*hp;
	struct servent		*sp;
	struct sockaddr_in	sin, *inetaddr;
	struct t_info		tinfo;
	struct t_call		*call;
	struct t_bind		*req, *ret;

	/*
	 * Get the host address and port number to connect to.
	 */
	if (rhost == (char *) NULL)
		fatal("no remote host to connect to");

	hp = gethostbyname(rhost);
	if (hp == (struct hostent *) NULL)
		fatal("unknown host %s", rhost);

	sp = getservbyname("printer", "tcp");
	if (sp == (struct servent *) NULL)
		fatal("printer/tcp: unknown service");

	/*
	 * Establish a transport-endpoint
	 */
	s = t_open(TLI_DEV, O_RDWR, &tinfo);
	if (s < 0) {
		tsyslog(LOG_ERR, s, "t_open");
		return(-1);
	}

	/*
	 * Initialize t_bind structures for bind
	 */
	req = (struct t_bind *) t_alloc(s, T_BIND, T_ALL);
	ret = (struct t_bind *) t_alloc(s, T_BIND, T_ALL);
	if (req == (struct t_bind *) NULL || ret == (struct t_bind *) NULL) {
		syslog(LOG_ERR, "%s: getport: t_alloc: %d: %m",
			printer, t_errno);
		(void) t_close(s);
		return(-1);
	}

	(void) memset((char *) &sin, '\0', sizeof(sin));
	sin.sin_family = AF_INET;
	req->addr.len = req->addr.maxlen = tinfo.addr;
	ret->addr.maxlen = tinfo.addr;
	req->qlen = 0;

	/*
	 * Run through reserved ports until we get one
	 */
	for (lport = rport; lport > 0; --lport) {
		sin.sin_port = htons(lport);
		inetaddr = (struct sockaddr_in *) (req->addr.buf);
		(void) memcpy((char *) inetaddr, (char *) &sin, tinfo.addr);

		if (t_bind(s, req, ret) < 0) {
			syslog(LOG_ERR, "%s: getport: t_bind: port: %d: %d: %m",
				printer, lport, t_errno);
			(void) t_free(req, T_BIND);
			(void) t_free(ret, T_BIND);
			(void) t_close(s);
			return(-1);
		}

		inetaddr = (struct sockaddr_in *) (ret->addr.buf);
		if (ntohs(inetaddr->sin_port) <= rport)
			break;

		(void) t_unbind(s);
	}

	(void) t_free(req, T_BIND);
	(void) t_free(ret, T_BIND);

	if (lport <= 0) {
		syslog(LOG_ERR, "%s: getport: couldn't obtain reserved port",
			printer);
		(void) t_close(s);
		return(-1);
	}

	/*
	 * Initialize t_call structure for connect
	 */
	call = (struct t_call *) t_alloc(s, T_CALL, T_ALL);
	if (call == (struct t_call *) NULL) {
		syslog(LOG_ERR, "%s: getport: t_alloc: %d: %m",
			printer, t_errno);
		(void) t_close(s);
		return(-1);
	}

	(void) memset((char *) &sin, '\0', sizeof(sin));
	(void) memcpy((char *) &sin.sin_addr, (char *) hp->h_addr,
			(size_t) hp->h_length);
	sin.sin_family = hp->h_addrtype;
	sin.sin_port = sp->s_port;

	inetaddr = (struct sockaddr_in *) (call->addr.buf);
	(void) memcpy((char *) inetaddr, (char *) &sin, tinfo.addr);
	call->addr.len = call->addr.maxlen = tinfo.addr;
	call->opt.maxlen = call->opt.len = 0;
	call->udata.maxlen = call->udata.len = 0;

	/*
	 * Try connecting to the server.
	 */
	if (t_connect(s, call, (struct t_call *) NULL) < 0) {
		if (t_errno == TLOOK) {
			syslog(LOG_ERR,
				"%s: getport: t_connect: received event %d",
				printer, t_look(s));
		}
		else {
			tsyslog(LOG_ERR, s, "t_connect");
		}

		(void) t_free(call, T_CALL);
		(void) t_close(s);
		return(-1);
	}

	(void) t_free(call, T_CALL);
	return(s);
}

/*
 * Getline reads a line from the control file cfp, removes tabs, converts
 *  new-line to null and leaves it in line.
 * Returns 0 at EOF or the number of characters read.
 */
getline(cfp)
	FILE *cfp;
{
	register int linel = 0;
	register char *lp = line;
	register c;

	while ((c = getc(cfp)) != '\n') {
		if (c == EOF)
			return(0);
		if (c == '\t') {
			do {
				*lp++ = ' ';
				linel++;
			} while ((linel & 07) != 0);
			continue;
		}
		*lp++ = c;
		linel++;
	}
	*lp++ = '\0';
	return(linel);
}

/*
 * Scan the current directory and make a list of daemon files sorted by
 * creation time.
 * Return the number of entries and a pointer to the list.
 */
getq(namelist)
	struct queue *(*namelist[]);
{
	register struct dirent *d;
	register struct queue *q, **queue;
	register int nitems;
	struct stat stbuf;
	int arraysz, compar();
	DIR *dirp;

	if ((dirp = opendir(SD)) == (DIR *) NULL)
		return(-1);
	if (fstat(dirp->dd_fd, &stbuf) < 0)
		goto errdone;

	/*
	 * Estimate the array size by taking the size of the directory file
	 * and dividing it by a multiple of the minimum size entry. 
	 */
	arraysz = (stbuf.st_size / 24);
	queue = (struct queue **)malloc(arraysz * sizeof(struct queue *));
	if (queue == (struct queue **) NULL)
		goto errdone;

	nitems = 0;
	while ((d = readdir(dirp)) != (struct dirent *) NULL) {
		if (d->d_name[0] != 'c' || d->d_name[1] != 'f')
			continue;	/* daemon control files only */
		if (stat(d->d_name, &stbuf) < 0)
			continue;	/* Doesn't exist */
		q = (struct queue *)malloc(sizeof(time_t)+strlen(d->d_name)+1);
		if (q == (struct queue *) NULL)
			goto errdone;
		q->q_time = stbuf.st_mtime;
		(void) strcpy(q->q_name, d->d_name);
		/*
		 * Check to make sure the array has space left and
		 * realloc the maximum size.
		 */
		if (++nitems > arraysz) {
			queue = (struct queue **)realloc((char *)queue,
				(unsigned) (stbuf.st_size/12)
				* sizeof(struct queue *));
			if (queue == (struct queue **) NULL)
				goto errdone;
		}
		queue[nitems-1] = q;
	}
	(void) closedir(dirp);
	if (nitems)
		qsort(queue, (unsigned) nitems, sizeof(struct queue *), compar);
	*namelist = queue;
	return(nitems);

errdone:
	(void) closedir(dirp);
	return(-1);
}

/*
 * Compare modification times.
 */
static
compar(p1, p2)
	register struct queue **p1, **p2;
{
	if ((*p1)->q_time < (*p2)->q_time)
		return(-1);
	if ((*p1)->q_time > (*p2)->q_time)
		return(1);
	return(0);
}

/*VARARGS1*/
fatal(msg, a1, a2, a3)
	char *msg;
{
	char buf[BUFSIZ];

	if (strcmp(from, host) != 0) {
		(void) sprintf(buf, "%s: ", host);
		(void) t_snd(Daemon, buf, strlen(buf), 0);
	}

	(void) sprintf(buf, "%s: ", name);
	(void) t_snd(Daemon, buf, strlen(buf), 0);

	if (printer) {
		(void) sprintf(buf, "%s: ", printer);
		(void) t_snd(Daemon, buf, strlen(buf), 0);
	}

	(void) sprintf(buf, msg, a1, a2, a3);
	(void) t_snd(Daemon, buf, strlen(buf), 0);
	(void) t_snd(Daemon, "\n", 1, 0);
	drop_connect(Daemon);
	exit(1);
}

drop_connect(fd)
	int fd;
{
	if (fd >= 0) {
		(void) sleep(1);	/* allow buffer to drain */
/* REE
		(void) t_sndrel(fd);
		(void) t_snddis(fd, NULL);
		(void) t_unbind(fd);
		(void) t_close(fd);
END */
	}
}

int
scandir(dirname, namelist, select, compare)
	char *dirname;
	struct dirent ***namelist;
	int (*select)();
	int (*compare)();
{
	int	num, cur;
	DIR	*dirp;
	struct stat	sbuf;
	struct dirent	*dp, **ptr, **p;

	if (stat(dirname, &sbuf) < 0)
		return(-1);

	if ((dirp = opendir(dirname)) == (DIR *) NULL)
		return(-1);

	/*
	 * approximate initial size (purely arbitrary)
	 */
	num = sbuf.st_size / 64;
	ptr = (struct dirent **) malloc(num * sizeof(char *));
	if (ptr == (struct dirent **) NULL) {
		(void) closedir(dirp);
		return(-1);
	}

	for (dp = readdir(dirp), cur = 0, p = ptr; dp != (struct dirent *) NULL;
		dp = readdir(dirp))
	{
		if (select == (int (*)()) NULL || (*select)(dp)) {
			/* check for enough pointers */
			if (num <= cur) {
				num *= 2;
				if ((p = (struct dirent **) realloc(ptr,
					num * sizeof(char *)))
					== (struct dirent **) NULL)
				{
					cleanup(ptr, cur);
					(void) closedir(dirp);
					return(-1);
				}
				ptr = p;
			}

			/* allocate space for new entry */
			ptr[cur] = (struct dirent *) malloc(dp->d_reclen);
			if (ptr[cur] == (struct dirent *) NULL) {
				cleanup(ptr, cur);
				(void) closedir(dirp);
				return(-1);
			}

			(void) memcpy((char *) ptr[cur], dp, dp->d_reclen);
			++cur;
		}
	}

	/*
	 * The sorting code would go here
	 */

	(void) closedir(dirp);
	*namelist = ptr;
	return(cur);
}

static
cleanup(ptr, num)
	struct dirent **ptr;
	int num;
{
	register int i;

	for (i = 0; i < num; ++i)
		free(ptr[i]);

	free(ptr);
}

tsyslog(priority, fd, routine)
	int priority;
	int fd;
	char *routine;
{
	char	buf[BUFSIZ];
	extern int	t_errno, t_nerr, errno, sys_nerr;
	extern char	*t_errlist[], *sys_errlist[];

	if (t_errno == TLOOK) {
		(void) sprintf(buf, "event %d", t_look(fd));
	}
	else {
		(void) strcpy(buf, t_errno < t_nerr
				? t_errlist[t_errno] : "Unknown error");

		if (t_errno == TSYSERR) {
			(void) strcat(buf, ": ");
			(void) strcat(buf, errno < sys_nerr
					? sys_errlist[errno] : "Unknown error");
		}
	}

	syslog(priority, "%s: %s: %s", printer?printer:"", routine, buf);
}
