#	START NEW ARIX SCCS HEADER
#
#	@(#) lpadmin.mk: version 25.1 created on 12/2/91 at 16:11:41
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	@(#)lpadmin.mk	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation
#
#	END NEW ARIX SCCS HEADER
#
#	Copyright (c) 1984 AT&T
#	  All Rights Reserved

#	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T
#	The copyright notice above does not evidence any
#	actual or intended publication of such source code.

#ident	"@(#)nlp:cmd/lpadmin/Makefile	1.7"
#
# Makefile for the lpadmin command
#
include $(IROOT)/macdefs

# This is a posix binary.  Turn off the SVID flag
SVID_FLAG=

FUNCDCL	=

USRLIB	=	$(ROOT)/usr/lib

AR		= /bin/ar
RM		= /bin/rm -f
MV		= /bin/mv
CP		= /bin/cp
LN		= /bin/ln

DEBUG	=	-g -DDEBUG

INC	=	$(ROOT)/usr/include
LPINC	=	../../include

LOCAL_CFLAGS	=	-I$(LPINC) 

LIBDIR	=	../../lib

LIBACC	=	$(LIBDIR)/access/liblpacc.a
LIBCLS	=	$(LIBDIR)/class/liblpcls.a
LIBFLT	=	$(LIBDIR)/filters/liblpflt.a
LIBFRM	=	$(LIBDIR)/forms/liblpfrm.a
LIBFS	=	$(LIBDIR)/fs/liblpfs.a
LIBLP	=	$(LIBDIR)/lp/liblp.a
LIBMSG	=	$(LIBDIR)/msgs/liblpmsg.a
LIBOAM	=	$(LIBDIR)/oam/liblpoam.a
LIBPRT	=	$(LIBDIR)/printers/liblpprt.a
LIBREQ	=	$(LIBDIR)/requests/liblpreq.a
LIBUSR	=	$(LIBDIR)/users/liblpusr.a
LIBRMT	=	$(LIBDIR)/remote/liblprmt.a

LINTACC	=	$(LIBDIR)/access/llib-llpacc.ln
LINTCLS	=	$(LIBDIR)/class/llib-llpcls.ln
LINTFLT	=	$(LIBDIR)/filters/llib-llpflt.ln
LINTFRM	=	$(LIBDIR)/forms/llib-llpfrm.ln
LINTFS	=	$(LIBDIR)/fs/llib-llpfs.ln
LINTLP	=	$(LIBDIR)/lp/llib-llp.ln
LINTMSG	=	$(LIBDIR)/msgs/llib-llpmsg.ln
LINTOAM	=	$(LIBDIR)/oam/llib-llpoam.ln
LINTPRT	=	$(LIBDIR)/printers/llib-llpprt.ln
LINTREQ	=	$(LIBDIR)/requests/llib-llpreq.ln
LINTUSR	=	$(LIBDIR)/users/llib-llpusr.ln
LIBNET  =   -L../../ $(LIBDIR)/bsd/libbsd.a -lnet


SRCS	= \
		chkopts.c \
		default.c \
		do_align.c \
		do_fault.c \
		do_mount.c \
		do_printer.c \
		do_pwheel.c \
		done.c \
		fromclass.c \
		ismodel.c \
		lpadmin.c \
		options.c \
		output.c \
		rmdest.c \
		send_mess.c \
		signals.c \
		startup.c \
		usage.c

OBJS	=	$(SRCS:.c=.o)


all:		lpadmin

install:	all
	$(INS) 	lpadmin	 $(USRLIB)/lpadmin
	chmod	6755	 $(USRLIB)/lpadmin
	chown 	lp	 $(USRLIB)/lpadmin
	chgrp	bin	 $(USRLIB)/lpadmin

$(OBJS):	lpadmin.h
	$(CC) $(CFLAGS) -c $<

clean:
	$(RM) $(OBJS)

clobber:	clean
	$(RM) lpadmin

strip:
	$(STRIP) lpadmin


lpadmin:	$(OBJS) \
			$(LIBACC) \
			$(LIBCLS) \
			$(LIBMSG) \
			$(LIBPRT) \
			$(LIBFRM) \
			$(LIBREQ) \
			$(LIBOAM) \
			$(LIBLP) \
			$(LIBFS) \
			$(LIBRMT)
	$(CC) -o lpadmin $(OBJS) $(LDFLAGS) \
			$(LIBACC) \
			$(LIBCLS) \
			$(LIBMSG) \
			$(LIBPRT) \
			$(LIBFRM) \
			$(LIBREQ) \
			$(LIBOAM) \
			$(LIBLP) \
			$(LIBFS) \
			$(LIBRMT) \
				-lcurses \
				-lsec   \
				-lnsl_s \
					$(LIBNET)

lint:
	lint $(CFLAGS) $(SRCS) \
			$(LINTACC) \
			$(LINTCLS) \
			$(LINTMSG) \
			$(LINTPRT) \
			$(LINTFRM) \
			$(LINTREQ) \
			$(LINTOAM) \
			$(LINTLP) \
			$(LINTFS)
