#	START NEW ARIX SCCS HEADER
#
#	@(#) cmd.mk: version 25.1 created on 12/2/91 at 16:26:44
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	@(#)cmd.mk	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation
#
#	END NEW ARIX SCCS HEADER
#
#	  All Rights Reserved

#	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T
#	The copyright notice above does not evidence any
#	actual or intended publication of such source code.

#ident	"@(#)nlp:cmd/Makefile	1.12"
#
# Makefile for the LP commands
#
include $(IROOT)/macdefs

# This is a posix binary.  Turn off the SVID flag
SVID_FLAG=

USRBIN	=	$(ROOT)/usr/bin
USRLIB	=	$(ROOT)/usr/lib
DEBUG	=

AR		= /bin/ar
RM		= /bin/rm -f
MV		= /bin/mv
CP		= /bin/cp
LN		= /bin/ln

INC	=	$(ROOT)/usr/include
LPINC	=	-I../include -I../tcp

LOCAL_CFLAGS =	$(LPINC)
LOCAL_LDFLAGS=	-lsec

LIBDIR	=	../lib
# Be carful when changing LIBNET
LIBNET  =       -L../ $(LIBDIR)/bsd/libbsd.a -lnet
LIBACC	=	$(LIBDIR)/access/liblpacc.a
LIBCLS	=	$(LIBDIR)/class/liblpcls.a
LIBFLT	=	$(LIBDIR)/filters/liblpflt.a
LIBFRM	=	$(LIBDIR)/forms/liblpfrm.a
LIBFS	=	$(LIBDIR)/fs/liblpfs.a
LIBLP	=	$(LIBDIR)/lp/liblp.a
LIBMSG	=	$(LIBDIR)/msgs/liblpmsg.a
LIBOAM	=	$(LIBDIR)/oam/liblpoam.a
LIBPRT	=	$(LIBDIR)/printers/liblpprt.a
LIBREQ	=	$(LIBDIR)/requests/liblpreq.a
LIBRMT	=	$(LIBDIR)/remote/liblprmt.a
LIBUSR	=	$(LIBDIR)/users/liblpusr.a

LINTACC	=	$(LIBDIR)/access/llib-llpacc.ln
LINTCLS	=	$(LIBDIR)/class/llib-llpcls.ln
LINTFLT	=	$(LIBDIR)/filters/llib-llpflt.ln
LINTFRM	=	$(LIBDIR)/forms/llib-llpfrm.ln
LINTFS	=	$(LIBDIR)/fs/llib-llpfs.ln
LINTLP	=	$(LIBDIR)/lp/llib-llp.ln
LINTMSG	=	$(LIBDIR)/msgs/llib-llpmsg.ln
LINTOAM	=	$(LIBDIR)/oam/llib-llpoam.ln
LINTPRT	=	$(LIBDIR)/printers/llib-llpprt.ln
LINTREQ	=	$(LIBDIR)/requests/llib-llpreq.ln
LINTUSR	=	$(LIBDIR)/users/llib-llpusr.ln

SRCS	= \
		cancel.c \
		comb.c \
		lp.c \
		lpfilter.c \
		lpforms.c \
		lpmove.c \
		lpshut.c \
		lpusers.c\
		send_mess.c \
		parse.c \
		request.c

OBJS	=	$(SRCS:.c=.o)

LILCMDS	= \
		accept \
		cancel \
		disable \
		enable \
		lp \
		lpfilter \
		lpforms \
		lpmove \
		lpshut \
		lpusers \
		reject

BIGCMDS	= \
		lpadmin \
		lpd \
		lpsched \
		lpstat

CMDS	=	$(BIGCMDS) $(LILCMDS)

USRCMDS	= \
		cancel \
		lp \
		disable \
		enable

LIBCMDS	= \
		accept \
		lpfilter \
		lpforms \
		lpmove \
		lpshut \
		lpusers \
		reject

all:		$(CMDS) \
		dumpolp

install:	all
	@for cmd in $(USRCMDS); \
	do \
		echo "\t$(INS)  $$cmd 	$(USRBIN)/$$cmd"; \
		$(INS)  $$cmd 	$(USRBIN)/$$cmd; \
		echo "\tchmod	6755	$(USRBIN)/$$cmd"; \
		chmod	6755	$(USRBIN)/$$cmd; \
		echo "\tchown	lp	$(USRBIN)/$$cmd"; \
		chown	lp	$(USRBIN)/$$cmd; \
		echo "\tchgrp 	bin	$(USRBIN)/$$cmd"; \
		chgrp 	bin	$(USRBIN)/$$cmd; \
	done
	@for cmd in $(LIBCMDS); \
	do \
		echo "\t$(INS)  $$cmd 	$(USRLIB)/$$cmd"; \
		$(INS)  $$cmd 	$(USRLIB)/$$cmd; \
		echo "\tchmod	6755	$(USRLIB)/$$cmd"; \
		chmod	6755	$(USRLIB)/$$cmd; \
		echo "\tchown	lp	$(USRLIB)/$$cmd"; \
		chown	lp	$(USRLIB)/$$cmd; \
		echo "\tchgrp 	bin	$(USRLIB)/$$cmd"; \
		chgrp 	bin	$(USRLIB)/$$cmd; \
	done
	@for cmd in $(BIGCMDS); \
	do \
		echo "cd $$cmd"; \
		cd $$cmd; \
		echo "$(MAKE) -$(MAKEFLAGS)f $$cmd.mk install"; \
		$(MAKE) -$(MAKEFLAGS)f $$cmd.mk install; \
		cd ..; \
	done
	$(INS) 	dumpolp	$(USRLIB)/dumpolp
	chmod 0555 	$(USRLIB)/dumpolp
	chown lp	$(USRLIB)/dumpolp
	chgrp bin	$(USRLIB)/dumpolp

clean:
	$(RM) $(OBJS)
	@for cmd in $(BIGCMDS); \
	do \
		echo "cd $$cmd"; \
		cd $$cmd; \
		echo "$(MAKE) -$(MAKEFLAGS)f $$cmd.mk clean"; \
		$(MAKE) -$(MAKEFLAGS)f $$cmd.mk clean; \
		cd ..; \
	done
	$(RM) dumpolp.o

clobber:
	$(RM) $(OBJS)
	$(RM) $(LILCMDS)
	@for cmd in $(BIGCMDS); \
	do \
		echo "cd $$cmd"; \
		cd $$cmd; \
		echo "$(MAKE) -$(MAKEFLAGS)f $$cmd.mk clobber"; \
		$(MAKE) -$(MAKEFLAGS)f $$cmd.mk clobber; \
		cd ..; \
	done
	$(RM) dumpolp.o
	$(RM) dumpolp

strip:
	$(STRIP) $(LILCMDS)
	@for cmd in $(BIGCMDS); \
	do \
		echo "cd $$cmd"; \
		cd $$cmd; \
		echo "$(MAKE) -$(MAKEFLAGS)f $$cmd.mk STRIP=$(STRIP) strip"; \
		$(MAKE) -$(MAKEFLAGS)f $$cmd.mk STRIP=$(STRIP) strip; \
		cd ..; \
	done
	$(STRIP) dumpolp

accept:		comb.o \
			$(LIBMSG) \
			$(LIBACC) \
			$(LIBOAM) \
			$(LIBLP)
	$(CC) -o accept comb.o $(LDFLAGS) \
			$(LIBMSG) \
			$(LIBACC) \
			$(LIBOAM) \
			$(LIBLP) \
		$(LIBFS)

disable:	accept
	$(CP) accept disable

enable:		disable
	$(LN) disable enable

reject:		accept
	$(LN) accept reject

cancel:		cancel.o \
			$(LIBREQ) \
			$(LIBMSG) \
			$(LIBOAM) \
			$(LIBLP)
	$(CC) -o cancel cancel.o $(LDFLAGS) \
			$(LIBREQ) \
			$(LIBMSG) \
			$(LIBOAM) \
			$(LIBLP) \
			$(LIBNET) \
		$(LIBFS)

lp:	parse.o	lp.o send_mess.o request.o \
			$(LIBPRT) \
			$(LIBREQ) \
			$(LIBMSG) \
			$(LIBOAM) \
			$(LIBUSR) \
			$(LIBACC) \
			$(LIBLP)  \
			$(LIBRMT)
	$(CC) -o lp parse.o send_mess.o request.o lp.o $(LDFLAGS) \
			$(LIBPRT) \
			$(LIBREQ) \
			$(LIBMSG) \
			$(LIBOAM) \
			$(LIBUSR) \
			$(LIBACC) \
			$(LIBLP) \
			$(LIBFS) \
			$(LIBRMT) \
			$(LIBNET) \
			-lsec 

lpadmin:	lpadmin_b

lpadmin_b:
	cd lpadmin; $(MAKE) -$(MAKEFLAGS)f lpadmin.mk

lpd:	lpd_b

lpd_b:
	cd lpd; $(MAKE) -$(MAKEFLAGS)f lpd.mk

lpfilter:	lpfilter.o \
			$(LIBFLT) \
			$(LIBMSG) \
			$(LIBACC) \
			$(LIBOAM) \
			$(LIBLP)
	$(CC) -o lpfilter lpfilter.o $(LDFLAGS) \
			$(LIBFLT) \
			$(LIBMSG) \
			$(LIBACC) \
			$(LIBOAM) \
			$(LIBLP) \
		$(LIBFS)

lpforms:	lpforms.o \
			$(LIBFRM) \
			$(LIBMSG) \
			$(LIBREQ) \
			$(LIBOAM) \
			$(LIBACC) \
			$(LIBLP) \
			$(LIBFS)
	$(CC) -o lpforms lpforms.o $(LDFLAGS) \
			$(LIBFRM) \
			$(LIBMSG) \
			$(LIBREQ) \
			$(LIBOAM) \
			$(LIBACC) \
			$(LIBLP) \
			$(LIBFS)

lpmove:		lpmove.o \
			$(LIBMSG) \
			$(LIBACC) \
			$(LIBOAM) \
			$(LIBLP)
	$(CC) -o lpmove lpmove.o $(LDFLAGS) \
			$(LIBMSG) \
			$(LIBACC) \
			$(LIBOAM) \
			$(LIBLP) \
		$(LIBFS)

lpsched:	lpsched_b

lpsched_b:
	cd lpsched; $(MAKE) -$(MAKEFLAGS)f lpsched.mk

lpshut:		lpshut.o \
			$(LIBMSG) \
			$(LIBOAM) \
			$(LIBLP)
	$(CC) -o lpshut lpshut.o $(LDFLAGS) \
			$(LIBMSG) \
			$(LIBOAM) \
			$(LIBLP) \
		$(LIBFS)

lpstat:		lpstat_b

lpstat_b:
	cd lpstat; $(MAKE) -$(MAKEFLAGS)f lpstat.mk

lpusers:	lpusers.o \
			$(LIBMSG) \
			$(LIBACC) \
			$(LIBOAM) \
			$(LIBUSR) \
			$(LIBLP) \
			$(LIBFS)
	$(CC) -o lpusers lpusers.o $(LDFLAGS) \
			$(LIBMSG) \
			$(LIBACC) \
			$(LIBOAM) \
			$(LIBUSR) \
			$(LIBLP) \
			$(LIBFS)

dumpolp:	dumpolp.o \
			$(LIBLP)
	$(CC) -o dumpolp dumpolp.o $(LDFLAGS) \
			$(LIBLP)

dumpolp.o:	dumpolp.c
	$(CC) $(CFLAGS) -c dumpolp.c

prof:
	cd lpsched; $(MAKE) -$(MAKEFLAGS)f lpsched.mk prof

lprof:
	cd lpsched; $(MAKE) -$(MAKEFLAGS)f lpsched.mk lprof

lint:
	lint $(CFLAGS) comb.c \
			$(LINTMSG) \
			$(LINTOAM) \
			$(LINTLP)
	lint $(CFLAGS) cancel.c \
			$(LINTREQ) \
			$(LINTMSG) \
			$(LINTOAM) \
			$(LINTLP)
	lint $(CFLAGS) lp.c \
			$(LINTREQ) \
			$(LINTMSG) \
			$(LINTOAM) \
			$(LINTLP)
	lint $(CFLAGS) lpfilter.c \
			$(LINTFLT) \
			$(LINTMSG) \
			$(LINTOAM) \
			$(LINTLP)
	lint $(CFLAGS) lpforms.c \
			$(LINTFRM) \
			$(LINTMSG) \
			$(LINTACC) \
			$(LINTFS) \
			$(LINTLP)
	lint $(CFLAGS) lpmove.c \
			$(LINTMSG) \
			$(LINTOAM) \
			$(LINTLP)
	lint $(CFLAGS) lpshut.c \
			$(LINTMSG) \
			$(LINTOAM) \
			$(LINTLP)
	lint $(CFLAGS) lpusers.c \
			$(LINTMSG) \
			$(LINTOAM) \
			$(LINTUSR) \
			$(LINTLP)
	@for cmd in $(BIGCMDS); \
	do \
		echo "cd $$cmd"; \
		cd $$cmd; \
		echo "$(MAKE) -$(MAKEFLAGS)f $$cmd.mk lint"; \
		$(MAKE) -$(MAKEFLAGS)f $$cmd.mk lint; \
		cd ..; \
	done

now:
	lint $(CFLAGS) lpforms.c \
			$(LINTFRM) \
			$(LINTMSG) \
			$(LINTACC) \
			$(LINTFS) \
			$(LINTLP)

$(OBJS):
	$(CC) $(CFLAGS) -c $<
