/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) login.c: version 25.9 created on 3/12/92 at 16:52:55	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)login.c	25.9	3/12/92 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*
 * login [ name ] [ [ -E ] environment args ]
 *
 *  -E was added on 10-26-91 to work with getty's -E.  It asks login to
 *  keep the env_args around after a failed login attempt.
 *
 *	Conditional compiles:
 *
 *	NO_MAIL	causes the MAIL environment variable not to be set
 *	NOSHELL does not put non-standard shell names into environment
 *	MAXTRYS is the number of attempts permitted.  0 is "no limit".
 *	More conditional assemblies:
 *
 *	NETLOGIN adds functionality of Wollongong's netlogin program
 *		login -r hostname (for rlogind)
 *		login -h hostname (for telnetd, etc.)
 *
 *  Note: Only one of -E, -h, or -r can be used at one time
 */

#include <sys/types.h>
#include <utmp.h>
#include <signal.h>
#include <pwd.h>
#include <errno.h>
#include <limits.h>
#include <sys/stream.h>
#include <grp.h>
#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>	/* For logfile locking */
#include <string.h>
#include <sys/stat.h>
#include <dirent.h>
#include <sys/utsname.h>
#include <termio.h>
#include <sys/stropts.h>
#include <shadow.h>	/* shadow password header file */
#include <time.h>
#include <auth.h>
#include <sys/gctio.h>
#include <sys/synch.h>
#include <sys/priv.h>
#include <sys/mls.h>
#include <sys/security.h>
#include <sys/audit.h>

#define	SLEEPTIME 	4	
#define	DISABLETIME	20	
#define	MAXTRYS		5	
#define	MAXTIME		60	
#define	NFAILURES 	20	
#define	LOGINLOG	"/usr/adm/loginlog"	
#define LOGINP		"/etc/login.parms"
#define CONSOLE		"/dev/console"
#define TZFILE 		"/etc/TIMEZONE"
#define LNAME_SIZE	20	
#define TTYN_SIZE	15	
#define TIME_SIZE	30	
#define ENT_SIZE	68	
#define L_WAITTIME	5


#define SCPYN(a, b)	strncpy(a, b, sizeof(a))
#define EQN(a, b)	(!strncmp(a, b, sizeof(a)-1))
#define DIAL_FILE	"/etc/dialups"
#define DPASS_FILE	"/etc/d_passwd"
#define SHELL		"/bin/sh"
#define	PATH		"PATH=:/bin:/usr/bin"
#define	ROOTPATH	"PATH=/bin:/etc:/usr/bin"
#define SUBLOGIN	"<!sublogin>"

#define	ROOTUID	 0
#define PBUFSIZE 8	/* max significant characters in a password */

#define	MAXARGS 63
#define	MAXENV 1024
#define MAXLINE 256
#define UNAMEMAX	64
#define MAXTRY		32
/* don't use min define from macros.h. That is not a posix a include file.
*/
#define MIN(a,b) (a<b ? a : b)

/*	Illegal passwd entries.
*/
static struct passwd nouser = { "", "no:password", ~ROOTUID, ~ROOTUID, "nouser" };
static struct spwd noupass = { "", "no:password" };

static struct usrauth nouapass = { "",~ROOTUID,~ROOTUID,"nopwd" };

static struct utsname un;
static struct utmp utmp;
static char u_name[64];
static char minusnam[16] = "-";
static char shell[MAXLINE] = { "SHELL=" };
static char home[MAXLINE] = { "HOME=" };
static char logname[30] = { "LOGNAME=" };
static char timez[MAXLINE] = { "TZ=" };

#ifdef OSENV
static char osenv[MAXLINE] = { "OS=" };
#endif

static char loginmsg[] = "login: ";
static char passwdmsg[] = "Password:";
static char incorrectmsg[] = "Login incorrect\n";
static char lockmsg[] = "\n\
**********************************************\n\
                    SORRY                     \n\
         The console has been locked !!       \n\
 (Only the security administrator may log in) \n\
**********************************************\n";

#ifndef	NO_MAIL
static char mail[30] = { "MAIL=/usr/mail/" };
#endif

#ifdef	NETLOGIN
#define	NETSUBLOGIN	"<!netsublogin>"
#define	NMAX		sizeof(utmp.ut_user)

static char term[64]  = { "TERM=" };
static char user[64]  = { "USER=" };
static char rhostname[UNAMEMAX], rusername[NMAX+1], lusername[NMAX+1];
static int  rflag;	/* for netlogin	only		*/
static int  remflag;	/* for telnet and netlogin	*/
#endif	/* NETLOGIN */

static char *envinit[6+MAXARGS] = { home,PATH,logname,0,0 };
static int basicenv;
static int intrupt;
static char envblk[MAXENV];
static struct passwd *pwd;
static struct spwd *shpwd ;	/* Shadow password structure */

	/*these next 4 may be defined in the login.parms file */
static uint sleeptime = SLEEPTIME;
static uint netprotect = 1;
static uint feedback = 0;
static uint global_failed_logins = 0;

static uint maxtrys = MAXTRYS;

static usrauth_t *ua;
static usrstat_t *us;

void readtzfile();
void getloginparms();
struct passwd *getpwnam();
struct spwd *getspnam() ;
int setpwent();
char *crypt();
char *getpass(), *fgetpass();
char *strrchr(),*strchr(),*strcat();
extern char **environ;

#define	WEEK	(24L * 7 * 60 * 60) /* 1 week in seconds */
static time_t when;
static time_t maxweeks;
static time_t minweeks;
static time_t now;
extern long a64l(), time();

extern void setbuf();
extern FILE *fopen();
extern int fclose(), fprintf(), findiop();
extern int kill(), ioctl();

static char *log_entry[NFAILURES] ;
static int writelog=0 ;

/* This structure is being added to store the information from either the
   user_auth file or the password file.  It is easier than continually 
   checking to see if there is a user_auth file or not.
	Peter Logan
*/

struct pass_storage {
	char *s_name;
	uid_t s_uid;
	gid_t s_gid;
	char *s_passwd;
	char *s_dir;
	char *s_shell;
	char *s_gecos;
}p_storage;
struct pass_storage *ps = &p_storage;

main(argc, argv ,renvp)
char **argv,**renvp;
{
	register char *namep;
	int j,k,l_index,length;
	char *ttyn, *ttyntail, *envtz, *getenv();
	int nopassword = 1;
	register int i;
	register struct utmp *u;
	struct utmp *getutent(), *pututline();
	FILE *fp;
	char **envp,*ptr,*endptr;
     char **keep_args;  /*used for -E flag */
     int Eflg = 0;   /* flag of -E option */
	int sublogin, shad_flag=1, pwdexp_flg=0, netsublogin;
	extern char **getargs();
	extern char *terminal();
	char inputline[MAXLINE];
	int n,  timenow, mask[2] ;
	struct stat dbuf ;
	usrstat_t *us, *getusent();
	usrauth_t *ua, *getuaent(), *getuanam();
	ttystat_t *ts, *gettsent();
	ttyauth_t *ta, *getdevauth();
	int tmp, trys = 0;


#ifdef	NETLOGIN		
	SCPYN ( lusername, "");
	SCPYN ( rusername, "");
	SCPYN ( rhostname, "");
restart:
	nopassword = 1;
	shad_flag = 1;
	pwdexp_flg = 0;

	ps = &p_storage;
	/* Set flag to force creation of utmp entry if a netlogin
	   sublogin */
	if ( renvp && *renvp && ( strcmp ( *renvp, NETSUBLOGIN) == 0))

		netsublogin = 1;
	else
		netsublogin = 0;
#endif	/* NETLOGIN */

	/*Set flag to disable the pid check if you find that you are	*/
	/*a subsystem login.						*/

	sublogin = 0;
	if( *renvp && strcmp(*renvp,SUBLOGIN) == 0 )
		sublogin = 1;

	umask(0);
	alarm(MAXTIME);
	signal(SIGQUIT, SIG_IGN);
	signal(SIGINT, SIG_IGN);
	nice(0);
	ttyn = terminal(0);
	if( ttyn==0 )
		ttyn = "/dev/tty??";
	if( ttyntail = strrchr(ttyn,'/') )
		ttyntail++;
	else
		ttyntail = ttyn;

	getloginparms();
	ta = getdevauth( ttyn );

	/* if the logfile exist, turn on attempt logging and
	   initialize the string storage area */
	if ( stat (LOGINLOG, &dbuf) == 0 )
		{
		writelog = 1 ;
		for ( i = 0 ; i < NFAILURES ; i++ )
			{
			if ( !(log_entry[i] = (char *) malloc ((unsigned) ENT_SIZE) ) )
				{
				writelog = 0 ;
				break ;
				}
			* log_entry[i] = '\0' ;
			}
		}

#ifdef	NETLOGIN	/* mer0 */
	/*
	 * -r is used by rlogind to cause the autologin protocol;
	 * -h is used by other servers to pass the name of the
	 * remote host to login so that it may be placed in utmp and wtmp
	 */

	rflag = 0;	/* for remote restart */
	remflag = 0;	/* for utmp check skip if -r specified */

	if (argc > 1) {
		if ( strcmp (argv[1], "-r") == 0) {
			if ( priv(P_SEC, getuid())) {

				struct	termio	ttyb;

				strncpy (&utmp.ut_line[6], argv[2], 6);
				strcpy (rhostname, argv[2]);
				getstr (rusername, sizeof (rusername), "remuser");
				getstr (lusername, sizeof (lusername), "locuser");
				getstr (term + 5,sizeof (term) - 5, "Terminal type");

				/*
				 * Initialize the pseudo tty.
				 * This mirrors the role of getty.
				 */

				ioctl (0, TCGETA, &ttyb);
				ttyb.c_lflag |= ECHOE | ISIG | ICANON | ECHO | ECHONL;

				/*
				 * If talking to an rlogin process,
				 * propagate the terminal type and
				 * baud rate across the network.
				 */
				doremoteterm (term, &ttyb);
				ioctl (0, TCSETA, &ttyb);

				rflag = 1;
				remflag = 1;		/* for netlogin	*/
				argc = 0;

				SCPYN (utmp.ut_user, lusername);
				SCPYN (u_name, lusername);
				strcpy (inputline, lusername);
				strcat (inputline, "   \n");
				envp = &argv[3];
				goto first;
			}

		} else	
		  if ( strcmp (argv[1], "-h") == 0) {
				if (priv(P_SEC, getuid())) {
					strncpy (&utmp.ut_line[6], argv[2], 6);
					strcpy (rhostname, argv[2]);
					remflag = 2;	/* for telnet	*/
					argc = 0;
				}
			} else
			  if (argc > 2 && ( strcmp (argv[2], "-E") == 0)  )
				Eflg = 1;   /* -E flag */
	}
#endif	/* NETLOGIN */
	if( argc > 1 ) {

		SCPYN (utmp.ut_user, argv[1]);
		SCPYN (u_name, argv[1]);

#ifdef	NETLOGIN						/* mer0 */
		SCPYN ( lusername, argv[1]);
		lusername[NMAX] = 0;
#endif	/* NETLOGIN */

		strcpy (inputline, u_name);
		strcat (inputline, "   \n");
		if (Eflg)
			envp = keep_args = &argv[3];
		else 
			envp = &argv[2];

		goto first;
	}

loop:
	nopassword = 1;
#ifdef	NETLOGIN						/* mer0 */
	/* Clear netlogin flag while looping */
	rflag = 0;
#endif	/* NETLOGIN */
	/* If logging is turned on and there is an unsuccessful
	   login attempt, put it in the string storage area */
	if ( (trys > 0) && (writelog == 1) && (trys < NFAILURES)) {
		time (&timenow) ;
		(void) strncat ( log_entry[trys-1], u_name, LNAME_SIZE ) ;
		(void) strncat ( log_entry[trys-1], ":", (size_t) 1 ) ;
		(void) strncat ( log_entry[trys-1], ttyn, TTYN_SIZE ) ;
		(void) strncat ( log_entry[trys-1], ":", (size_t) 1 ) ;
		(void) strncat ( log_entry[trys-1], ctime(&timenow),TIME_SIZE) ;
	}
	/* make sure we don't call badlogin unless ta is off.
	 * this is because we will lock the terminal elsewhere when we
	 * are doing ta processing 
	 */
	if (( trys >= maxtrys)) {
		if ( badlogin(ua,ta,ttyn) )
			exit(0);
	}
	u_name[0] = utmp.ut_user[0] = '\0';
first:
	fflush(stdout);
	while( utmp.ut_user[0] == '\0' )
	{
		if ( ta && ta->ta_status )
			fputs(lockmsg, stdout);
		fputs(loginmsg, stdout);
		fflush(stdout);
		if( (envp = getargs(inputline)) != (char**)NULL )
		{
			SCPYN(utmp.ut_user,*envp);
			SCPYN(u_name, *envp++);
		}
		/* if the -E flag, tack on the passed in env args */
		if (Eflg && keep_args) {
			for (i=0; envp[i] ; i++);
			j = 0;
			while ((i < MAXARGS - 1 ) && keep_args[j])
				envp[i++] = keep_args[j++];
		}

	}

	/* check to see if the userauth exists. If it does, open it and
 	 * the usrstat databases and look for the user. If we don't find
	 * the usrstat, of if the user isn't in the usrauth, then we slug
	 * in a bad passwd for the user 
	 */
	if( !access(USRAUTH,0) ) {
		if((ua = getuanam(u_name)) && (us = getusent(ua->ua_uid ))) {
			ps->s_name = ua->ua_name;
			ps->s_gecos = ua->ua_gecos;
			ps->s_uid = ua->ua_uid;
			ps->s_gid = ua->ua_gid;
			ps->s_passwd = ua->ua_passwd;
			ps->s_dir = ua->ua_defdir;
			ps->s_shell = ua->ua_defshell;
			trys = us->us_badtries;
		}
		else {
			ps->s_name = nouser.pw_name;
			ps->s_passwd = nouser.pw_passwd;
			ps->s_uid = nouser.pw_uid;
			trys++;
		}
		enduaent();
		endustatent();
	}

	while( utmp.ut_user[0] == '\0' ) {
		fputs(loginmsg, stdout);
		fflush(stdout);
		if( (envp = getargs(inputline)) != (char**)NULL )
		{
			SCPYN(utmp.ut_user,*envp);
			SCPYN(u_name, *envp++);
		}
	}

	/* If any of the common login messages was the input, we must be
	 * looking at a tty that is running login.  We exit because
	 * they will chat at each other until one times out otherwise.
	 * In time, init(1M) sees this and decides something is amiss.
	 */
	if( EQN(loginmsg, inputline)  ||  EQN(passwdmsg, inputline)  ||
	    EQN(incorrectmsg, inputline) ) {
		printf("Looking at a login line.\n");
		exit(8);
	}
	  
	/* if the user_auth didn't exist, we will get information
 	 * from the normal 5.3.2 places 
	 */
	if( ! ua ) {
	    if ( access(SHADOW,0) ) {
		shad_flag = 0 ;		/* SHADOW is not there */
	    }
	    setpwent();
	    if ( shad_flag )
		(void) setspent () ;	/* Setting the shadow password file */
	    if ( (pwd = getpwnam (u_name) ) == NULL ||
	     ( shad_flag && (shpwd = getspnam (u_name) ) == NULL) ) {
		pwd = &nouser;
		if ( shad_flag )
			shpwd = &noupass ;
	    }
	    if ( shad_flag ) {
		ps->s_passwd = shpwd->sp_pwdp;
		(void) endspent () ;	/* Closing the shadow password file */
	    } 
	    else {
		ps->s_passwd = pwd->pw_passwd;
	    }
	    ps->s_name = pwd->pw_name;
	    ps->s_gecos = pwd->pw_gecos;
	    ps->s_uid = pwd->pw_uid;
	    ps->s_gid = pwd->pw_gid;
	    ps->s_dir = pwd->pw_dir;
	    ps->s_shell = pwd->pw_shell;
	}
	endpwent();


	/*      - okay: at this point we should have all the interesting
	 *        information about the user. We will do one simple console
	 *        test to act like the 5.3.2 version, but the rest of the
 	 *        authentication get's done after the password processing
 	 *        so we always look the same to the user - ie: so we always
	 *        look like a password fail
	 */
	if ( !ta ) {
		if ( strcmp(ttyn, CONSOLE) != 0 &&
		     (ua && ckpriv(P_SEC, ua) || ps->s_uid == 0)) {
			printf("Not on system console\n");
			exit(10);
		}
	}

	if ( ta && ta->ta_status &&
	     (ua && !ckpriv(P_SEC, ua) || ua == 0 && ps->s_uid != 0) ) {
		/* this must be the console, or we would have */
		/* locked the terminal when we got devauth. */
		goto loop;
	}

	if( *( ps->s_passwd ) != '\0' ) {
		nopassword = 0;

#ifdef	NETLOGIN						/* mer0 */
		if (rflag ){
			if (ruserok (rhostname, ps->s_uid, rusername,
			    lusername, ua, ta, ps->s_name) < 1) {
/**				failure_update(ua,ta,ttyn, 
					LOGIN_FAILED_NETP); */
				envinit[0] = NETSUBLOGIN;
				envinit[1] = (char *)0;
				execle ( "/bin/login", 
					"login", lusername, (char *)0,
				  &envinit[0]);
				execle ( "/etc/login", 
					"login", lusername, (char *)0,
				  	&envinit[0]);
				printf ("Unable to exec /bin/login or /etc/login\r\n");

				envinit[0] = home;
				envinit[1] = PATH;
				argv[0] = "login";
				argv[1] = lusername;
				argv[2] = (char *)0;
				renvp[0] = NETSUBLOGIN;
				renvp[1] = (char *)0;
				argc = 2;
				rflag = 0;
				remflag = 0;
				netsublogin = 0;
				goto restart;
			}
		}
		else {
#endif	/* NETLOGIN */
			if( gpass(passwdmsg, ps->s_passwd) ) {
				if ( strcmp(ps->s_name, nouser.pw_name) == 0 )
					failure_update(ua,ta,ttyn, 
						LOGIN_FAILED_BADUID);
				else
					failure_update(ua,ta,ttyn, 
						LOGIN_FAILED_BADPASWORD);
				goto loop;
			}

#ifdef	NETLOGIN						/* mer0 */
		}
#endif	/* NETLOGIN */
	}

	/*     We ALLWAYS want to let a security adm in on the console.
	 *
	 *     Check if they are cleared to login at this time;
	 *     if not, we record the statistics and go back 
	 *     to retry again. Notice that we let the bad guy
	 *	  lock the account if is not authorized.
	 */
	if ( ua ) {
                    /*Special case of SECADM on the Console*/
		if ( strcmp(ttyn, CONSOLE) != 0 || !ckpriv(P_SEC, ua)) {

			/* if the account is locked just try again */
			if ( ua->ua_acctstat ) {
				failure_update(ua,ta,ttyn, 
				(ua->ua_acctstat == 1 ) ? LOGIN_FAILED_USER_LOCKED :
						  	LOGIN_FAILED_USER_RETIRED );
				sleep(sleeptime);
				goto loop;
			}
			if (!istimeauth(ua)) {
				failure_update(ua,ta,ttyn,LOGIN_FAILED_BADTIME);
				sleep(sleeptime);
				goto loop;
			}
		}
	}
	/* Again, if it is a SEC ADM trying to log in on the console, we 
	 * ALLWAYS let them.  Otherwise, we see if the user is authorized 
	 * for the terminal. If he's not we will update the approriate 
	 * database and do the lock thing.
	 */
	if (ta)  {
                    /*Special case of SECADM on the Console*/
		if ( strcmp(ttyn, CONSOLE) != 0 ||
		     (ua && !ckpriv(P_SEC, ua) || ps->s_uid != 0)) {

			if (ta->ta_status) {
				/* This can't happen since non console */
				/* terminals with ta_status are locked by now */
				failure_update(ua,ta,ttyn, LOGIN_FAILED_TTY_LOCKED);
				sleep(sleeptime);
				goto loop;
			}
 			if ( !isttyauth(ta, ps->s_name)) {
				failure_update(ua,ta,ttyn, LOGIN_FAILED_TTY_NOPERM);
				sleep(sleeptime);
				goto loop;
			}
		}
	}
	/*
	 * get dialup password, if necessary
	 */
	if( dialpass(ttyn) ) {
		failure_update(ua,ta,ttyn, LOGIN_FAILED_BADPASWORD);
		sleep(sleeptime);
		goto loop;
	}

	/*
	 * optionally adjust nice(2)
	 */
	if( strncmp("pri=", ps->s_gecos, 4) == 0 )
	{
		int mflg, pri;

		pri = 0;
		mflg = 0;
		i = 4;
		if( ps->s_gecos[i] == '-' )
		{
			mflg++;
			i++;
		}
		while( ps->s_gecos[i] >= '0' && ps->s_gecos[i] <= '9' )
			pri = (pri * 10) + ps->s_gecos[i++] - '0';
		if( mflg )
			pri = -pri;
		nice(pri);
	}

	if( chdir(ps->s_dir) < 0 )
	{
		printf("Unable to change directory to \"%s\"\n",ps->s_dir);
		goto loop;
	}
	time(&utmp.ut_time);
	utmp.ut_pid = getpid();

	/*Find the entry for this pid (or line if we are a sublogin) in	*/
	/*the utmp file.						*/
#ifdef	NETLOGIN						/* mer0 */
reutmp:
#endif	/* NETLOGIN */

	while( (u = getutent()) != NULL ) {

		if( (u->ut_type == INIT_PROCESS ||
			u->ut_type == LOGIN_PROCESS ||
			u->ut_type == USER_PROCESS) &&
			( (sublogin && strncmp(u->ut_line,ttyntail,
			sizeof(u->ut_line)) == 0) || u->ut_pid == utmp.ut_pid) )
		{

	/* Copy in the name of the tty minus the "/dev/", the id, and set */
	/* the type of entry to USER_PROCESS.				  */

			SCPYN(utmp.ut_line,(ttyn+sizeof("/dev/")-1));
			utmp.ut_id[0] = u->ut_id[0];
			utmp.ut_id[1] = u->ut_id[1];
			utmp.ut_id[2] = u->ut_id[2];
			utmp.ut_id[3] = u->ut_id[3];
			utmp.ut_type = USER_PROCESS;

	/* Return the new updated utmp file entry. */

			pututline(&utmp);

			break;
		}
	}
	if( u == (struct utmp *)NULL )
	{
#ifdef	NETLOGIN					/* mer0 */
		/* Must check both for > 0 */
		if ( (netsublogin > 0) || (remflag > 0) ) {

			register char	*p;
			register int	n;

			if ( ( n = strlen (ttyntail) ) > 4)

				p = ( (ttyntail + n) - 4);

			else

				p = ttyntail;

			utmp.ut_type = LOGIN_PROCESS;
			SCPYN (utmp.ut_line, ttyntail);

			utmp.ut_id[0] = *p++;
			utmp.ut_id[1] = *p++;
			utmp.ut_id[2] = *p++;
			utmp.ut_id[3] = *p++;

			pututline (&utmp);	/* create a new utmp entry */
			setutent ();		/* rewind utmp file	   */

			/*
			 * DON'T set either remflag or netsublogin to 0!
			 */

			remflag *= -1;		/* prevent looping	   */
			netsublogin *= -1;	/* prevent looping	   */
			goto reutmp;		/* reread utmp entry	   */
		}
		 else	{
#endif	/* NETLOGIN */
			endutent();		/* Close utmp file, mer0 */
			printf("No utmp entry.  You must exec \"%s\" from\
 the lowest level \"sh\".\r\n",
#ifdef	NETLOGIN
			(remflag == 0) ? "login" :
			((remflag == 2) || (remflag == -2)) ? "telnet" :
			"netlogin"
#else	/* NETLOGIN */
			"login"
#endif	/* NETLOGIN */
				);
			exit(1);
#ifdef	NETLOGIN						/* mer0 */
		}
#endif	/* NETLOGIN */
	}
	endutent();		/* Close utmp file */

	/* Now attempt to write out this entry to the wtmp file if we	*/
	/* were successful in getting it from the utmp file and the	*/
	/* wtmp file exists. Lock wtmp file so simultaneous logins	*/
	/* will not conflict.					 	*/

	if (u != NULL && (fp = fopen(WTMP_FILE,"r+")) != NULL) {
		for ( i=0 ; i<10 ; i++ ) {
			if ( lockf(fileno(fp), F_TLOCK, 0) == -1 ) {
				if ( i < 9 ) sleep (1) ;
				else perror("login: unable to lock accounting file.\n") ;
			}
			else {
				fseek(fp,0L,2) ; /* Seek to end of file */
				fwrite(&utmp,sizeof(utmp),1,fp);
				rewind(fp) ;
				(void) lockf(fileno(fp), F_ULOCK, 0) ;
				i = 10 ;
			}
		}
		fclose(fp);
	}

	chown(ttyn, ps->s_uid, ps->s_gid);
	/* must change the label of the device cause getty
	 * made sure it was protected. Don't bother checking
	 * whether it worked.
	 */
	if (ta)
		set_file_slabel( ttyn, &ta->ta_minlabel);

	/* If the shell field starts with a '*', do a chroot to the home */
	/* directory and perform a new login.			 */

	if( *ps->s_shell == '*' ) {
		if( chroot(ps->s_dir) < 0 ) {
			printf("No Root Directory\n");
			goto loop;
		}

	/* Set the environment flag <!sublogin> so that the next login	*/
	/* knows that it is a sublogin.					*/

		envinit[0] = SUBLOGIN;
		envinit[1] = (char*)NULL;
		printf("Subsystem root: %s\n",ps->s_dir);
		execle("/bin/login", "login", (char*)0, &envinit[0]);
		execle("/etc/login", "login", (char*)0, &envinit[0]);
		printf("No /bin/login or /etc/login on root\n");
		goto loop;
	}

#ifdef	_POSIX_SOURCE			
	/* We need to do a getpwnam because we can't be sure that we
	 * already have a pwd struct. 
         */
	if ( (pwd = getpwnam (ps->s_name)) == NULL ) 
		pwd = &nouser;
	if (set_exec_status(pwd)) {                
		initgroups (u_name, ps->s_gid);
#ifdef OSENV
		strcat( osenv, "POSIX" );
#endif
	}
#ifdef OSENV
	else
		strcat( osenv, "SVID" );
#endif
#endif	/* _POSIX_SOURCE */

	if( nopassword ) {
		if( ua && PASS_NEED(ua->ua_mode) ) {
			alarm(0);
			printf("You don't have a password.  Choose one.\n");
			printf("passwd %s\n", u_name);
			fflush(stdout);
			n = system("IFS=' ';/bin/passwd");
			if( n > 0 )   {
				/* This used to be a goto loop.
				 * Wrong. This should be an exit
				 */
				exit(1); 
			}
			if( n < 0 ) {
				printf("Cannot execute /bin/passwd\n");
				exit(1);
			}
		}
	}

	/* Is the age of the password to be checked? */
	if( ua ) {
		now  = DAY_NOW;

		/* force expiration with negative values */
		if (( ua->ua_min_pwdlife < 0 ) || ( ua->ua_max_pwdlife < 0 ))
			pwdexp_flg = 1;
		else
			if ((us->us_pwdchg == 0)|| (us->us_pwdchg > now) ||
				((ua->ua_max_pwdlife > 0) &&
				(now > (us->us_pwdchg + ua->ua_max_pwdlife)) &&
				(ua->ua_max_pwdlife >= ua->ua_min_pwdlife)))
		      pwdexp_flg = 1;
	} else {
		if ( shad_flag ) {
			now  = DAY_NOW;
			if( ( shpwd->sp_lstchg == 0 ) || 
				( shpwd->sp_lstchg > now) ||
			    	( (shpwd->sp_max >= 0 )	&&
			      	( now > (shpwd->sp_lstchg + shpwd->sp_max) ) &&
			      	( shpwd->sp_max >= shpwd->sp_min ) ))
			      pwdexp_flg = 1 ;
			}
		else {			/* without shadow */
			if( *pwd->pw_age != NULL ) {
				/*
				 * retrieve (a) week of previous change 
				 *          (b) maximum number of valid weeks
				 */
				when = a64l(pwd->pw_age);
				maxweeks = when & 077;
				minweeks = (when >> 6) & 077;
				when >>= 12;
				now  = DAY_NOW/WEEK;
				if( when > now || (now > when + maxweeks) 
					&& (maxweeks >= minweeks) )
					pwdexp_flg = 1 ;

			}
		}
	}
	/* If user's password has expired */
	if (( pwdexp_flg ) && ( ua ? (!(ua->ua_mode & NO_PASS_CHANGE)) : 1)) {
		alarm(0);
		printf("Your password has expired. Choose a new one\n");
		printf("passwd %s\n", u_name);
		fflush(stdout);
		n = system("IFS=' ';/bin/passwd");
		if( n > 0 ) {
			exit(9);
		}
		if( n < 0 )
		{
			printf("Cannot execute /bin/passwd\n");
			exit(9);
		}
	}
	strcat(home, ps->s_dir);
	strcat(logname, ps->s_name);
#ifdef	NETLOGIN						/* mer0 */
	if ( rflag || remflag || netsublogin)
		strcat (user, ps->s_name);
#endif	/* NETLOGIN */
	if( ps->s_uid == (uid_t) ROOTUID )
		envinit[1] = ROOTPATH;
	if( *ps->s_shell == '\0' )
		ps->s_shell = SHELL;
#ifndef NOSHELL
	else
		envinit[3] = shell;
#endif
	strcat(shell, ps->s_shell);

	/* Find the name of the shell.*/
	if( (namep = strrchr(ps->s_shell, '/')) == NULL )
		namep = ps->s_shell;
	else
		namep++;

	/* Generate the name of the shell with a '-' sign in front of it. */
	/* This causes .profile processing when a shell is exec'ed. */
	strcat(minusnam, namep);

#ifndef	NO_MAIL
	if( envinit[3] == (char*)NULL ) 
		envinit[3] = mail;
	else 
		envinit[4] = mail;
	strcat(mail,ps->s_name);
#endif
	/* Find the end of the basic environment */
	for( basicenv=3; envinit[basicenv]; basicenv++ );

#ifdef	NETLOGIN						/* mer0 */
	if ( rflag || remflag || netsublogin) {

		envinit[basicenv++] = user;
		envinit[basicenv++] = term;
		}
#endif	/* NETLOGIN */


	/* Add in the time zone (TZ) variable to the end of the */
	/* basic environment. If TZ is not in the old env, try to */
	/* read it out of /etc/TIMEZONE. */

	if ( (envtz=getenv("TZ")) == NULL ) 
		readtzfile();
	
	else {
		strcat(timez, envtz) ;
		envinit[basicenv++] = timez ;
	}

#ifdef OSENV
	envinit[basicenv++] = osenv;
#endif
	/* Add in all the environment variables picked up from the */
	/* argument list to "login" or from the user response to the */
	/* "login" request. */

	for( j=0,k=0,l_index=0,ptr= &envblk[0]; *envp && j<(MAXARGS-1);
		j++,envp++ )
	{

	/* Scan each string provided.  If it doesn't have the format */
	/* xxx=yyy, then add the string "Ln=" to the beginning. */

		if( (endptr = strchr(*envp,'=')) == (char*)NULL )
		{
			envinit[basicenv+k] = ptr;
			sprintf(ptr,"L%d=%s",l_index,*envp);

	/* Advance "ptr" to the beginning of the next argument.	*/

			while( *ptr++ );
			k++;
			l_index++;
		}

	/* Is this an environmental variable we permit?	*/

		else if( !legalenvvar(*envp) )
			continue;


	/* Check to see whether this string replaces any previously- */
	/* defined string. */

		else
		{
			for( i=0,length=endptr+1-*envp; i<basicenv+k; i++ )
			{
				if( strncmp(*envp,envinit[i],length) == 0 )
				{
					envinit[i] = *envp;
					break;
				}
			}

	/* If it doesn't, place it at the end of environment array. */

			if( i == basicenv+k )
			{
				envinit[basicenv+k] = *envp;
				k++;
			}
		}
	}

	/* Switch to the new environment. */

	environ = envinit;
	alarm(0);

	signal(SIGQUIT, SIG_DFL);
	signal(SIGINT, SIG_DFL);
	uname(&un);

	audit_login( ps->s_name, ttyn, 0 );
	/* sucess_update must be before setuid to access the secure databases */
	sucess_update(ua, ta, ttyn);

	/* set the user audit mask */
	if ( ua ) {
		mask[0] = ~ua->ua_amask[0];
		mask[1] = ~ua->ua_amask[1];
		audit_umask( mask, 1 );	
	}
	if( setgid(ps->s_gid) == -1 ) {
		printf("Bad group id.\n");
		exit(1);
	}
	if( setuid(ps->s_uid) == -1 ) {
		printf("Bad user id.\n");
		exit(1);
	}

	/* do the lastlogin processing only if we're not using
	 * extended databases 
	 */
	if ( !ua )  {
		if ( !access(".",02))
			lastlogin();
	}
	
	/* kludge. close everything */
	for( i = 3; i < FOPEN_MAX; i++ )
		close(i);

	execl(ps->s_shell, minusnam, (char*)0);
	
	/* pwd->pw_shell was not an executable object file, maybe it
	 * is a shell proceedure or a command line with arguments.
	 * If so, turn off the SHELL= environment variable.
	 */
	if( !strncmp( envinit[3], shell, 6 ) )
		envinit[3][6] = '\0';


	if( access( ps->s_shell, 05 ) == 0 )
		execl(SHELL, "sh", ps->s_shell, minusnam, (char*)0);

	printf("No shell\n");
	exit(1);
	/* NOTREACHED */
}


#ifdef	_POSIX_SOURCE

struct group *getgrent();

/*
 * initgroups - for POSIX implementation
 */
initgroups(uname,agroup)
char *uname;
int   agroup;
{
gid_t groups[NGROUPS_MAX];
int  ngroups = 0;
register struct group *grp;
register int i;

	setgrent();
	while (grp = getgrent()) {
		if (grp->gr_gid == agroup)
			continue;
		for (i = 0; grp->gr_mem[i]; i++) {
			if (!strcmp(grp->gr_mem[i],uname)) {
				if (ngroups == NGROUPS_MAX) {
					fprintf(stderr, "too many groups\n");
					break;
				}
				groups[ngroups++] = grp->gr_gid;
			}
		}
		if (ngroups == NGROUPS_MAX)
			break;
	}
	endgrent();
	if (setgroups(ngroups,groups) < 0) {
		fprintf(stderr,"setgroups error: errno = %d\r\n",errno);
		return (-1);
	}
	return (0);
}

#endif	/* _POSIX_SOURCE */


static
dialpass(ttyn)
char *ttyn;
{
	register FILE *fp;
	char defpass[30];
	char line[80];
	register char *p1, *p2;

	if( (fp=fopen(DIAL_FILE, "r")) == NULL )
		return(0);
	while( (p1 = fgets(line, sizeof(line), fp)) != NULL )
	{
		while( *p1 != '\n' && *p1 != ' ' && *p1 != '\t' )
			p1++;
		*p1 = '\0';
		if( strcmp(line, ttyn) == 0 )
			break;
	}
	fclose(fp);
	if( p1 == NULL || (fp = fopen(DPASS_FILE, "r")) == NULL )
		return(0);
	defpass[0] = '\0';
	p2 = 0;
	while( (p1 = fgets(line, sizeof(line)-1, fp)) != NULL )
	{
		while( *p1 && *p1 != ':' )
			p1++;
		*p1++ = '\0';
		p2 = p1;
		while( *p1 && *p1 != ':' )
			p1++;
		*p1 = '\0';
		if( strcmp(ps->s_shell, line) == 0 )
			break;

		if( strcmp(SHELL, line) == 0 )
			SCPYN(defpass, p2);
		p2 = 0;
	}
	fclose(fp);
	if( !p2 )
		p2 = defpass;
	if( *p2 != '\0' )
		return(gpass("Dialup Password:", p2));
	return(0);
}

static
gpass(prmt, pswd)
char *prmt, *pswd;
{
	register char *p1;
	time_t time() ;

	/* getpass() fails if it cannot open /dev/tty.
	 * If this happens, and the real UID is root,
	 * then use the current stdin and stderr.
	 * This allows login to work with network connections
	 * and other non-ttys.
	 */
	if( ((p1 = getpass(prmt)) == (char *)0) && (priv(P_SEC,getuid()))) {
		p1 = fgetpass(stdin, stderr, prmt);
	}
	if( !p1 || strcmp(crypt(p1, pswd), pswd) ) {
		sleep (sleeptime) ;
		printf( incorrectmsg );
		return(1);
	}
	return(0);
}

#define	WHITESPACE	0
#define	ARGUMENT	1

static char **
getargs(inline)
char *inline;
{
	static char envbuf[MAXLINE];
	static char *args[MAXARGS];
	register char *ptr,**answer;
	register int c;
	int state;
	extern int quotec();

	for( ptr= envbuf; ptr < &envbuf[sizeof(envbuf)]; )
		*ptr++ = '\0';

	for( answer= args; answer < &args[MAXARGS]; )
		*answer++ = (char *)NULL;

	for( ptr= envbuf,answer= &args[0],state = WHITESPACE;
	     (c = getc(stdin)) != EOF; )
	{

		*(inline++) = c;
		switch( c ) {
	
		case '\n':
			if( ptr == &envbuf[0] ) return((char **)NULL);
			else return(&args[0]);
		case ' ':
		case '\t':
			if( state == ARGUMENT )
			{
				*ptr++ = '\0';
				state = WHITESPACE;
			}
			break;
		case '\\':
			c = quotec();
		default:
			if( state == WHITESPACE )
			{
				*answer++ = ptr;
				state = ARGUMENT;
			}
			*ptr++ = c;
		}

	/* If the buffer is full, force the next character to be read to */
	/* be a <newline>.						 */

		if( ptr == &envbuf[sizeof(envbuf)-1] )
		{
			ungetc('\n',stdin);
			putc('\n',stdout);
		}
	}

	/* If we left loop because an EOF was received, exit immediately. */

	exit(0);
	/* NOTREACHED */
}

static int
quotec()
{
	register int c, i, num;

	switch( c = getc(stdin) )
	{
	case 'n':
		c = '\n';
		break;
	case 'r':
		c = '\r';
		break;
	case 'v':
		c = '\013';
		break;
	case 'b':
		c = '\b';
		break;
	case 't':
		c = '\t';
		break;
	case 'f':
		c = '\f';
		break;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
		for( num=0,i=0; i<3; i++ )
		{
			num = num * 8 + (c - '0');
			if( (c = getc(stdin)) < '0' || c > '7' )
				break;
		}
		ungetc(c,stdin);
		c = num & 0377;
		break;
	default:
		break;
	}
	return(c);
}
/*
 * terminal(f): return "/dev/ttyXX" which the the name of the
 * tty belonging to file f.  This routine is the same as ttyname()
 * except that it rejects /dev/syscon and /dev/systty, which are
 * links to other device names.
 *
 * This program works in two passes: the first pass tries to
 * find the device by matching device and inode numbers; if
 * that doesn't work, it tries a second time, this time doing a
 * stat on every file in /dev and trying to match device numbers
 * only. If that fails too, NULL is returned.
 */

static char *
terminal(f)
int f;
{
	struct stat fsb, tsb;
	struct dirent *dp;
	register DIR *df;
	register int pass1;
	static char rbuf[64];
	static char dev[]="/dev/";

	if( isatty(f) == 0 )
		return(NULL);

	if( fstat(f, &fsb) < 0 )
		return(NULL);

	if( (fsb.st_mode & S_IFMT) != S_IFCHR )
		return(NULL);

	if( (df=opendir(dev)) == NULL )
		return(NULL);
	pass1 = 1;
	do
	{
		while( (dp = readdir(df)) != NULL )
		{
			if( pass1  &&  dp->d_ino != fsb.st_ino )
				continue;

			if( strncmp(dp->d_name, "syscon", 6) == 0 ||
				strncmp(dp->d_name, "systty", 6) == 0 )
				continue;

			(void)strcpy(rbuf, dev);
			(void)strncat(rbuf, dp->d_name, sizeof rbuf - sizeof dev);
			if( stat(rbuf, &tsb) < 0 )
				continue;

			if( tsb.st_rdev == fsb.st_rdev &&
				(tsb.st_mode&S_IFMT) == S_IFCHR &&
				(!pass1 || tsb.st_ino == fsb.st_ino) )
			{
				closedir(df);
				return(rbuf);
			}
		}
		rewinddir(df);
	} while( pass1-- );
	closedir(df);
	return(NULL);
}


static char *illegal[] = {
		"SHELL=",
		"HOME=",
		"LOGNAME=",
#ifndef	NO_MAIL
		"MAIL=",
#endif
		"CDPATH=",
		"IFS=",
		"PATH=",
		0
		};

/* Is it legal to insert this environmental variable? */
static int
legalenvvar(s)
char *s;
{
	register char **p;

	for( p=illegal; *p; p++ )
		if( !strncmp(s, *p, strlen(*p)) )
			return(0);
	return(1);
}

/*
 *  lastlogin() -- used to inform the user of the time and
 *        date that this login was last used.  Uses a
 *        file in the login directory called .lastlogin to
 *        keep track of the date/time.  Inode change time is
 *        used to prevent unauthorized changing of file times. If file
 *	  is not owned by current uid, do not notify user of last
 *	  login.
 */
lastlogin()
{
	register int fd;
	static char fname[] = ".lastlogin";
	struct stat s;
	struct utimbuf
	{
		time_t actime;
		time_t modtime;
	} utbuf;

	if( stat(fname, &s) == 0 )
	{
		/* if .lastlogin not owned by current uid, return */
		if ( s.st_uid != getuid() )
			return;

		if( s.st_mtime - s.st_atime != 2 )
		{
			printf("Warning:  %s was altered since last login\n",
				fname);
		}
		printf("Login last used: %s", ctime(&s.st_ctime));
	}
	else
	{
		printf("Warning: %s did not exist, creating it\n", fname);
		if( (fd = open(fname, O_RDONLY|O_CREAT|O_TRUNC, 0400)) == -1 )
		{
			perror("cannot write file in login directory");
			return;
		}
		close(fd);
	}

	utbuf.modtime = time((long *)0);
	utbuf.actime = utbuf.modtime - 2;

	if ( utime(fname, &utbuf) < 0 )
		printf("Warning: .lastlogin cannot be updated\n");

}

/*
 * badlogin() - log to the log file after
 *     NFAILURES unsuccessful attempts
 */
badlogin( ua, ta, ttyn )
usrauth_t *ua;
ttyauth_t *ta;
char *ttyn;
{
int retval, count1, fildes, donothing() ;

	/* in the case that we are doing ta processing, do the
	 * proper thing.
	 */
	if ( ta ) {
		failure_update(ua,ta,ttyn, LOGIN_FAILED_TTY_LOCKED);
		return (1);
	}

	/* Tries to open the log file. If succeed, lock it and write
	   in the failed attempts */
	if ( (fildes = open (LOGINLOG, O_APPEND|O_WRONLY)) == -1 )
		return (0) ;
	else	{
		(void) sigset ( SIGALRM, donothing ) ;
		(void) alarm ( L_WAITTIME ) ;
		retval = lockf ( fildes, F_LOCK, 0L ) ;
		(void) alarm ( 0 ) ;
		(void) sigset ( SIGALRM, SIG_DFL ) ;
		if ( retval == 0 )
			{
			for ( count1 = 0 ; count1 < NFAILURES ; count1++ )
			   write (fildes, log_entry[count1],
				  (unsigned) strlen (log_entry[count1])) ;
			(void) lockf (fildes, F_ULOCK, 0L) ;
			(void) close (fildes) ;
			}
		return (0) ;
		}
}

donothing()
{}


char *
getpass(prompt)
char *prompt;
{
	char *p;
	FILE *fi;

	if( (fi = fopen("/dev/tty", "r")) == NULL ) {
			return((char*)NULL);
	}
	setbuf(fi, (char*)NULL);
	p = fgetpass(fi, stderr, prompt);
	if( fi != stdin )
		(void)fclose(fi);
	return(p);
}


char *
fgetpass(fi, fo, prompt)
FILE *fi, *fo;
char *prompt;
{
	struct termio ttyb;
	unsigned short flags;
	register char *p;
	register int c;
	static char pbuf[PBUFSIZE + 1];
	void (*sig)(), catch();

	sig = signal(SIGINT, catch);
	intrupt = 0;
	(void)ioctl(fileno(fi), TCGETA, &ttyb);
	flags = ttyb.c_lflag;
	ttyb.c_lflag &= ~(ECHO | ECHOE | ECHOK | ECHONL);
	(void)ioctl(fileno(fi), TCSETAF, &ttyb);
	(void)fputs(prompt, fo);
	for( p=pbuf; !intrupt && (c = getc(fi)) != '\n' && c != EOF; )
	{
		if( p < &pbuf[PBUFSIZE] )
			*p++ = c;
	}
	*p = '\0';
	(void)putc('\n', fo);
	ttyb.c_lflag = flags;
	(void)ioctl(fileno(fi), TCSETAW, &ttyb);
	(void)signal(SIGINT, sig);
	if( intrupt )
		(void)kill(getpid(), SIGINT);

	
	return(pbuf);
}


static void
catch()
{
	++intrupt;
}


#ifdef	NETLOGIN					/* mer0 */

getstr(buf,cnt,err)
register char	*buf, *err;
register int	cnt;
{
char	c;	/* must be on stack	*/

	do {
		if (read(0, &c, 1) != 1) {
			exit (1);
		}
		if (--cnt < 0) {
			printf("%s too long\r\n",err);
			exit (1);
		}
		*buf++ = c;
	} while (c != 0);
}

char	*speeds[] = {
		"0", "50", "75", "110", "134", "150", "200", "300",
		"600", "1200", "1800", "2400", "4800", "9600", "19200", "38400"
	};

#define	NSPEEDS	((sizeof (speeds) / sizeof (speeds[0])))

doremoteterm(term,tp)
register char		*term;
register struct	termio	*tp;
{
register char		*cp;
register int		i;

	cp = strchr(term, '/');
	tp->c_cflag = CBAUD|CS8;
	if (cp) {
		*cp++ = 0;
		for (i = 0; i < NSPEEDS; i++)
			if (!strcmp(speeds[i],cp)) {
				tp->c_cflag &= ~CBAUD;
				tp->c_cflag |= CBAUD & i;
				break;
			}
	}
	tp->c_oflag = OPOST|ONLCR|TAB3;
	tp->c_iflag = IGNPAR|ISTRIP|ICRNL;
	tp->c_lflag = ISIG|ICANON|ECHO|ECHOE|ECHOK;
}

/*
 * This is the code to parse the /etc/hosts.equiv and .rhosts files.
 */
ruserok_checkfile(filename,rhost,ruser,luser)
register char	*filename, *rhost, *ruser, *luser;
{
register FILE	*hostf;
register char	*user;
char		*whitespace = " \t\n";
char		*wildcard = "*";
char		ahost[80];

	if (hostf = fopen(filename,"r")) {
		while (fgets(ahost,sizeof(ahost),hostf)) {
			user = strtok(ahost,whitespace);
			if (strcmp(user,rhost) && strcmp(user,wildcard))
				continue;
			user = strtok(NULL,whitespace);

				
			if (user == NULL) {
				if (strcmp(luser,ruser))
					continue;
			} else	{
				if (strcmp(user,ruser) && strcmp(user,wildcard))
					continue;
			}
			fclose(hostf);
			return (1);		/* found	*/
		}
		fclose(hostf);
		return (0);			/* not found	*/
	}
	return (-1);				/* error	*/
}

ruserok(rhost,userid,ruser,luser,ua, ta, name)
register char	*rhost, *ruser, *luser;
register int	userid;
usrauth_t *ua;
ttyauth_t *ta;
char *name;
{
register char	*dotrhosts = ".rhosts";
register char	*etchosts  = "/etc/hosts.equiv";
struct	stat	sbuf;
struct passwd *pwd, *getpwnam();

	/*        add authorization checks for TCP .rhosts processing
	 *        we should live by the same rules with the rhosts
	 *        processing as we do here 
	 */
	if ( ua ) {
		if ( ua->ua_acctstat )
			return -1;

		if (!istimeauth(ua))
			return -1;
		/* get the role definition and look for the P_SEC bit.
		 * if we find it we return -1 
		 */
		if ( netprotect && ckpriv(P_SEC, ua) )
			return -1;
	}
	else {
		if (!(pwd = getpwnam(luser)))
			return -1;
		if (pwd->pw_uid == 0)
			return -1;
	}

	if ( ta ) {
		if ( ta->ta_status)
			return -1;

		if ( !isttyauth(ta,name))
			return -1;
	}

	if (userid)
		if (ruserok_checkfile(etchosts,rhost,ruser,luser) > 0)
			return (1);
	if (chdir(ps->s_dir) < 0)
		return (-1);
	if (stat(dotrhosts,&sbuf) < 0)
		return (-1);
	if (sbuf.st_uid && (sbuf.st_uid != userid))
		return (-1);
	return (ruserok_checkfile(dotrhosts,rhost,ruser,luser));
}

#endif /* NETLOGIN */

/*
 *	lockterm   lock the terminal passwd on by name 
 */	
lockterm(fname)
char *fname;
{
int i;

	/* catch all signals just in case the lock utility isn't
	 * present or errored out
 	 */ 
	for ( i=0; i<MAXSIG; i++ )
		signal( i, SIG_IGN );

	/* JTOF - look at this code --- seems really unecessary
	 *	  at this point
	 */
	for ( i = 0; i < 6; i++ )
		close(i);

	setsid();  /*We are POSIX...so no setpgrp */

	open( fname, O_RDWR | O_NDELAY );
	execl( "/etc/lock", "lock", "-l", "-t", fname, (char *) 0 );
	while (1) 
		sleep( 999 );
}

/*
 *	getloginparms  get the login parms as set in the login
 *		       paramter file
 */

void
getloginparms()
{
FILE *fp;
char buf[80], *p, *strchr(); 
priv_t tmp;
slabel_t label;

	/* open the login file */
	if ( ! ( fp = fopen( LOGINP, "r" ) ) ) 
		return ;

	if ( getpriv( &tmp ) != -1 ) {
		if ( ! cvt_sym_slabel( "SYS_SEC", &label ) ) 
			fprintf( stderr, "can't label %s\n", LOGINP );
		set_file_slabel( LOGINP, &label );
	}

	while ( fgets( buf, 80, fp ) ) {
		if ( p = strchr( buf, '=' )) {
			*p++ = 0;
			if ( !strcmp( buf, "feedback" ))
				feedback = atoi( p );
			else if ( !strcmp( buf, "netprotect" ))
				netprotect = atoi( p );
			else if ( !strcmp( buf, "sleep" ))
				sleeptime = atoi( p );
			else if ( !strcmp( buf, "global_failed_logins"))
				global_failed_logins = atoi( p );
			else  if ( *buf == '#' )
				continue;
			}
		}
	/* close the parms file.  */
	fclose (fp);
}


/*
 *	getdevauth   open the devauth database for the given tty
 *		     and retrieve it's contents
 */
ttyauth_t *getdevauth(name)
char *name;
{
ttyauth_t *ta;

	/* if no ttyauth exists, signal it should be used by
 	 * returning a null 
	 */
	if ( access( TTYAUTH, 0 ) )
		return NULL;

	/* if the terminal is locked and we get to this point
 	 * somehow, then lock the terminal 
	 */
	if ( ta = gettanam( name )) {
		if ( ta->ta_status && strcmp(name, CONSOLE) != 0 )
			lockterm(name);
		maxtrys = ta->ta_maxtry ;
		endtaent();
		return ta;
	}
	return NULL;
}


/*
 *	failure_update   report the failure in all the proper database
 *			 This includes the normal files kept for the 
 *			 I&A stuff as well as the audit trail 
 */
 	
failure_update(ua,ta,ttyn,why)
usrauth_t *ua;
ttyauth_t *ta;
char *ttyn;
uint why;
{
usrstat_t *us, *getusent();
ttystat_t *ts, *gettsent();
int exitflag = 0;
time_t tm;
uint max_failed;  /* max failed attempts before a USER is locked */

	audit_login( ps->s_name, ttyn, why );
	/* read in the current status - only do updated if 
	 * we do indeed find the structure we need   
	 */

	/*
	 * We need to take the smaller of these two, unless one of them is zero,
	 * then we want the other guy.
	 */


	time( &tm );
	if ( ua ) {

		if ( ! (max_failed = MIN(ua->ua_maxtries,global_failed_logins)) )
			max_failed = (global_failed_logins) ? global_failed_logins :
		          	   ua->ua_maxtries;

		if ( us = getusent(ua->ua_uid ) ) {
			us->us_last_try = tm;
			us->us_reason_failed = why;
			strcpy( us->us_ttyn_try, ttyn );
			if ( max_failed && 
				(++us->us_badtries >= max_failed)) {
				ua->ua_acctstat = LOCKED;
				updateuaent(ua,us,DO_BOTH);
				exitflag = 1;
				
			} else
				updateuaent(ua,us,JUST_STAT);
		}
	}

	/* now get the structure for the tty. We will exit out
	 * if the tries exceeds those allowed on the terminal. 
	 */
	if ( ta ) {
		if ( ts = gettsent(ta->ta_tsentry) ) {
			ts->ts_lasttry = tm;
			ts->ts_reason_failed = why;
			if ( ++ts->ts_tries >= maxtrys ) {
				if ( strncmp( "/dev/ttyp", ttyn, 9) &&
				     strncmp( "/dev/Xtty", ttyn, 9) &&
				     strncmp( "/dev/ttyT", ttyn, 9 )) {	
					ta->ta_status = time((long*)0);
					updatetaent(ta, ts, DO_BOTH );
					exitflag = 1;
				}
				else
				  	updatetaent(ta,ts,JUST_STAT);
			}
			else
				updatetaent(ta,ts,JUST_STAT);
		}
	}
	if ( feedback )
		dis_whyfail( why );

	if ( exitflag ) {
		exit(1);
	}
}

/*
 *	dis_whyfail
 */
dis_whyfail( why )
int why;
{
	fprintf( stderr, "\nSorry\n" );
	if (feedback == 2) {
		if ( (why & LOGIN_FAILED_NETP ))
			fprintf( stderr, 
				"login failed: network access violation\n" );

		if ( (why & LOGIN_FAILED_BADUID))
			fprintf( stderr, "login failed: unknown user\n" );

		if ( (why & LOGIN_FAILED_USER_RETIRED))
			fprintf( stderr, "login failed: account retired\n" );

		if ( (why & LOGIN_FAILED_USER_RETIRED))
			fprintf( stderr, "login failed: account retired\n" );
	}
	if ( why & LOGIN_FAILED_USER_LOCKED )
		fprintf( stderr, "login failed: account locked\n" );
	if ( why & LOGIN_FAILED_BADTIME )
		fprintf( stderr, "login failed: invalid access time\n" );
	if ( why & LOGIN_FAILED_TTY_NOPERM )
		fprintf( stderr, "login failed: account not cleared to use this device\n" );
	fprintf( stderr, "\n" );	
}

/*
 *	sucess_update   record a sucessfull login attempt by the user 
 */
sucess_update(ua,ta,ttyn) 
usrauth_t *ua;
ttyauth_t *ta;
char *ttyn;
{
usrstat_t *us, *getusent();
ttystat_t *ts, *gettsent();

	if(ua) {
		if ( us = getusent(ua->ua_uid )) {
			us->us_lastlogin = time((long*)0);
#ifdef NETLOGIN
			if ( *rhostname ) {
				us->us_lastnetlogin = time((long*)0);
				strcpy( us->us_host, rhostname );
				strcpy( us->us_name, rusername ); 
			}
#endif
			strcpy( us->us_ttyn,ttyn );
			us->us_badtries = 0;
			updateuaent(ua,us,JUST_STAT);
		}
	}
	if (ta) {
		if ( ts = gettsent(ta->ta_tsentry) ) {
			ts->ts_lastlogin = time((long*)0);
			ts->ts_tries = 0;
			ts->ts_lastuid = ps->s_uid;
			updatetaent(ta,ts,JUST_STAT);
		}
	}
}
	


/* 
 *	audit_login  audit login events     
 */
audit_login( uname, ttyn, mode )
char *uname;
char *ttyn;
int mode;
{	
sat_login_t buf;
struct stat st;

	buf.flag = LOGIN_ID;
	if ( mode )
		buf.flag |= LOGIN_FAIL;
	buf.mode = mode;
	stat( ttyn, &st );
	buf.tty = st.st_rdev;
	strncpy( buf.uname, uname, DIRSIZ ); 
	if ( audit_add_event( AUD_LOGIN, &buf, sizeof( sat_login_t )) < 0 )
		if ( errno != ENOSYS )
			fprintf( stderr, "login: can't write audit record\n" );
}

	
/*
 *  If the TZ var is not in the enviornment...readtzfile() will go out 
 *  to /etc/TIMEZONE and try to get it.
 */
void
readtzfile()
{
	FILE *tz_fp;
	char buf[MAXLINE];

	if ( (tz_fp = fopen(TZFILE,"r")) == NULL)
		return;                  /*oh well. we tried. */
	
	while (fgets(buf,MAXLINE,tz_fp)) {
		if ((strncmp(buf,"TZ=",3) == 0) && buf[3] != '\0' ){
			strncpy(timez,buf,MAXLINE);
			envinit[basicenv++] = timez ;
			break;
		}
	}
	fclose (tz_fp);    
}

ckpriv(priv, uap)
uint       priv;
usrauth_t  *uap;
{
	roldef_t  *rp;
	roldef_t  *getrolent();

	while ( rp = getrolent() )
		if ( rp->r_rolenumber == uap->ua_role )
			break;

	endrlent();
	if ( rp == NULL )
		return 0;

	return ((rp->r_priv.real & priv) == priv);
}
