#	START NEW ARIX SCCS HEADER
#
#	@(#) login.mk: version 1.2 created on 12/15/89 at 13:21:31
#
#	Copyright (c) 1988 by Arix Corporation
#	All Rights Reserved
#
#	@(#)login.mk	1.2	12/15/89 Copyright (c) 1988 by Arix Corporation
#
#	END NEW ARIX SCCS HEADER
#
#	Copyright (c) 1984 AT&T
#	  All Rights Reserved
#
#	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T
#	The copyright notice above does not evidence any
#	actual or intended publication of such source code.
#	ATT: ident	"login:login.mk	1.6"
#
include	$(IROOT)/macdefs
INC = $(ROOT)/usr/include

# This is a posix binary.  Turn off the SVID flag
SVID_FLAG=

INSDIR = $(ROOT)/bin
LOCAL_CFLAGS =  -DOSENV -DNETLOGIN -L.
MAKEFILE = login.mk
OBJECTS = login
SOURCES = login.c

LOGINPARMS=login.parms
PARMS_INSDIR = $(ROOT)/etc

ALL all:	$(OBJECTS)

install: all
	$(INS) login $(INSDIR)/login
	$(INS) $(LOGINPARMS) $(PARMS_INSDIR)/$(LOGINPARMS)
	chmod 4555 $(INSDIR)/login
	chmod 660 $(PARMS_INSDIR)/$(LOGINPARMS)
	chgrp sys $(INSDIR)/login $(PARMS_INSDIR)/$(LOGINPARMS)
	chown root $(INSDIR)/login $(PARMS_INSDIR)/$(LOGINPARMS)

login:	login.c
	$(CC) $(CFLAGS) -o login login.c $(LDFLAGS) -lcrypt -lsec

clean:
	rm -f $(OBJECTS)
	
clobber: clean
	rm -f $(OBJECTS) greplist tags

newmakefile:
	makefile -m -f $(MAKEFILE) -s INC $(INC)

save:
	cd $(INSDIR); set -x; for m in $(OBJECTS); do  cp $$m OLD$$m; done

restore:
	cd $(INSDIR); set -x; for m in $(OBJECTS); do; cp OLD$$m $$m; done

remove:
	cd $(INSDIR);  rm -f $(OBJECTS)

partslist:
	@echo $(MAKEFILE) $(LOCALINCS) $(SOURCES)  |  tr ' ' '\012'  |  sort

product:
	@echo $(OBJECTS)  |  tr ' ' '\012'  | \
		sed -e 's;^;$(INSDIR)/;' -e 's;//*;/;g'

productdir:
	@echo $(INSDIR)

srcaudit:	# will not report missing nor present object or product files.
	 fileaudit $(MAKEFILE) $(LOCALINCS) $(SOURCES) -o $(OBJECTS) 

ctags:	
	ctags	$(SOURCES)
	echo 'grep $$* \\' > greplist
	for i in $(SOURCES)	;\
	do echo "$$i \\"	;\
	done >> greplist
	echo /dev/null >> greplist
	chmod +x greplist
