/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) mktty.c: version 25.1 created on 12/2/91 at 16:06:19	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)mktty.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/* kd0 3/7/88	changes made for the GC16 board */

#include "sys/types.h"
#include "sys/stat.h"
#include "sys/icb.h"
#include "fcntl.h"
#include "errno.h"

extern int errno;

#define NULL	0
#define OK	0
#define MISSING 1
#define NOT_CHR 2
#define MAXGCS	11
#ifdef S3000
#	include <stdio.h>
#	define TTYMAJOR	tty_major()
	int	tty_major();
#else
#	define TTYMAJOR	8
#endif
#define gc8	8
#define gc16	16

struct icb icb;

char *icbdev[] = {
	"/dev/icb00","/dev/icb01","/dev/icb02","/dev/icb03",
	"/dev/icb04","/dev/icb05","/dev/icb06","/dev/icb07",
	"/dev/icb08","/dev/icb09","/dev/icb10","/dev/icb11",
	"/dev/icb12","/dev/icb13","/dev/icb14","/dev/icb15",
	"/dev/icb16","/dev/icb17","/dev/icb18",
};

int count,count16,current, newtot;
int gctype[MAXSLOTS];

main(argc, argv)
char **argv;
{
int i,new,new16;
int badflag,status[88];
char dev[11], ans[80];

	count_gcs();
	badflag = 0;
	for (i=0; i<(count*gc8+count16*gc16); ++i) {
			status[i]=get_stat(i);
			badflag += status[i];
		}
	if (badflag) {
		printf("Do you want to create missing tty devices ? ");
		if(gets(ans) != NULL && (ans[0] == 'y' || ans[0] == 'Y')) {
		for(i=0; i<(count*gc8+count16*gc16); ++i) 	/*shen*/
			/*needs to be 16 rather than 8 for */ /*3.0 GCcode kd0*/
			if(status[i] == MISSING)
				create(i);
			else if(status[i] == NOT_CHR) {
				sprintf(dev,"/dev/tty%02d",i);
				printf("%s already exists, but it is not setup as a proper tty port.\n",dev);
				printf("Do you want to remove it and recreate it properly? ");
				if(gets(ans) != NULL && (ans[0] == 'y' || ans[0] == 'Y')) {
					unlink(dev);
					create(i);
					}
				}	/* end  else NOT_CHR */
			}	/* end  gets = y */
		}	/* end if badflag */
	else
		printf("Devices already exist for the current GC boards.\n");

	printf("\nDo you want to create new tty devices? ");
	if(gets(ans) != NULL && (ans[0] == 'y' || ans[0] == 'Y')) {
		/*kd0*/
		printf("\nThis program will sequentially create 16 new\n");
		printf("tty devices for each GC16 and 8 new tty devices\n");
		printf("for each GC8 you plan on adding.\n");
come_again:	printf("\nHow many GC8 boards do you plan to add ? ");
		if(gets(ans) != NULL) {
			new = atoi(ans);
		      printf("\nHow many GC16 boards do you plan to add ? ");
		      if(gets(ans) != NULL) {
			new16 = atoi(ans);
			current=gc8*count+gc16*count16; 
			newtot = new*gc8+new16*gc16;
			if(new+new16+count+count16 <= MAXGCS)
			for(i=current; i<(current+newtot); ++i) /*kd0*/
					create(i);
			else {
				printf("This machine already has %d GC8 boards and %d GC16 boards. %d is the maximum allowed.\n",count,count16,MAXGCS);
				goto come_again;
			}
		    }
		}
	}	/* end if gets = y */
	return(0);
}

count_gcs()
{
	int icbfd, i;

	for(i=0; i < MAXSLOTS; i++) {
		if ((icbfd = open(icbdev[i], O_RDONLY)) > 0) {
			if (ioctl(icbfd, ICBGET, &icb) < 0) {
				printf("%s ICBGET failed\n");
				close(icbfd);
				continue;
			}
			close(icbfd);
			if (icb.type == GCP ) { count++; gctype[i]=8; }
			if (icb.type == EGCP) { count16++; gctype[i]=16;}
		}
	}
	printf("\nThere are %d GC8 boards and %d GC16 boards operating in this machine.\n",count, count16);
	return;
}

get_stat(minor)
int minor;
{
struct	stat statb;
char	dev[11];

	sprintf(dev,"/dev/tty%02d",minor);
	if (!stat(dev,&statb))
		if((statb.st_mode&S_IFCHR) && (statb.st_rdev==(TTYMAJOR<<8|minor)))
			return(OK);
		else
			return(NOT_CHR);
	else
		return(MISSING);
}

create(minor)
int minor;
{
int mode,dev;
char path[11];

	if(minor >= 16*MAXGCS) {	/*kd0*/
		fprintf(2,"mktty internal error, attempt to create /dev/tty%02d\n",minor);
		exit(1);
		}
	sprintf(path,"/dev/tty%02d",minor);
	if(!get_stat(minor)) {
		printf("%s already exists.\n",path);
		return;
	}
	mode = S_IFCHR|0666;
	dev = (TTYMAJOR<<8)|minor;
	printf("creating %s\n",path);
	if(mknod(path, mode, dev) < 0) {
		perror("mktty: error in mknod");
		exit(1);
	}
}

#ifdef S3000
#define MAJOR_MAX 127

/*
 * tty_major - return major number for tty driver
 */
int
tty_major()
{
	register FILE	*fp;
	static int	num = -1;

	if (num != -1)
		return(num);

	if ((fp = popen("exec /etc/drvinstall -m gctty -n", "r")) == NULL) {
		perror("popen failed");
		exit(1);
	}
	if ( fscanf(fp, "%d", &num) == 1 ) {
		if (num < 0 || num > MAJOR_MAX) {
			fprintf(stderr,"drvinstall returned bad major # - %d", 
				num);
			exit(1);
		}
	}
	else {
		fprintf(stderr,"tty_major: fscanf error\n");
		exit(1);
	}
	return(num);
}
#endif
