


major="3"
drive="0"

while :; do
	echo "\nWhat type of cartridge tape drive device do you want to create

	1.  for 60M tape drive
	2.  for 150M tape drive

	:\c"
	read model
	if [ "$model" = "q" ]
	then	exit 1;
	fi
	if [ "$model" = "1" -o "$model" = "2" ]
	then	break
	fi
	echo "\tPlease type 1 or 2"
done
if [ "$model" = "1" ]
then 	while :; do
		echo "\nQic 11 or Qic 24 ('11' or '24') ? \c"
		read density
		if [ "$density" = "q" ]
		then	exit 1;
		fi
		if [ "$density" = "11" -o "$density" = "24" ]
		then	if [ "$density" = "24" ]
			then	density="0"
			else	density="1"
			fi
			break
		fi
		echo "\tPlease type '11' or '24'"
	done
else  	density="0"
fi
while :; do
	echo "\nTo which controller will this cartridge drive be attached (0-3)? \c"
	read controller
	if [ "$controller" = "q" ]
	then	exit 1;
	fi
	case "${controller:=X}" in
		q)	exit 1 ;;
		[0-3])
			break 2;;
		*)
			echo "Legal values are 0 - 3. Look at the output from an 'icb -l' command"
			echo "to see how many controllers (HSDT or EDT) are currently running.";;
	esac
done
while :; do
	echo "\nShould this device rewind when it is closed ? \c"
	read rwoc
	if [ "$rwoc" = "q" ]
	then	exit 1;
	fi
	if [ "$rwoc" = "y" -o "$rwoc" = "n" ]
	then	if [ "$rwoc" = "n" ]
		then	rwoc="0"
		else	rwoc="1"
		fi
		break
	fi
	echo "\tPlease type 'y' or 'n'"
done

dev=/dev/rmt$rwoc
if /bin/ls -l $dev > /dev/null 2>&1
then	echo "\n$dev already exists. The device will be removed and recreated"
	echo "with the new parameters."
	rm -f $dev
fi
if [ "$model" = "2" ]
then type="1"
else type="0"
fi
minor=`expr $rwoc \* 64 + $controller \* 16 + $density \* 8 + $type \* 4 + $drive`
echo "\nCreating $dev, major # = $major, minor # = $minor\n"
/etc/mknod $dev c $major $minor
/bin/chmod 666 $dev
/bin/chgrp sys $dev
/bin/chown root $dev
if ls -l $dev > /dev/null 2>&1
then	:
else	echo "/etc/mknod failed"
	exit 1
fi
