
SCSI_0_BDEV=6		# block device number for scsi controller 0
SCSI_0_CDEV=40		# char. device number for scsi controller 0

echo 'This subcommand will create all the devices needed for adding a new
disk drive to a system.  It may also be used to add logical drives
to an existing disk drive.'
while :; do
	echo "\nTo which controller will this disk drive be attached ? \c"
	read controller
	if [ "$controller" = "q" ]
	then	exit 1;
	fi
	case "${controller:=X}" in
		[0-3])
			break 2;;
		*)
			echo "Legal values are 0 - 3. Look at the output from the 'icb -l' command"
			echo "to see how many controllers (HSDT or EDT) are currently running.";;
	esac
done
blkmajor=0
chrmajor=2
while :; do
	echo "\nIs this controller a SCSI EDT? (y or n) \c"
	read response
	if [ "$response" = "n" ]
	then    break;
	fi
	echo "\nWhich SCSI EDT is this (0-3)? \c"
	read scsinum
	if [ "$scsinum" = "q" ]
	then	exit 1;
	fi
	case "${scsinum:=X}" in
		[0-3])
			blkmajor=`expr $scsinum + $SCSI_0_BDEV`
			chrmajor=`expr $scsinum + $SCSI_0_CDEV`
			break 2;;
		*)
			echo "Legal values are 0 - 3. Look at the output from the 'icb -l' command"
			echo "to see how many SCSI EDT's are currently running.";;
	esac
done
while :; do
	echo "\nWhich drive number on controller $controller ? \c"
	read drive
	if [ "$drive" = "q" ]
	then	exit 1;
	fi
	if [ $blkmajor = 0 ]
	then	# smd
		case "${drive:=X}" in
			[0-3])
				break 2;;
			*)
				echo "\tLegal values are 0 - 3 "
		esac
	else	# scsi
		case "${drive:=X}" in
			[0-9])  break 2;;
			1[0-3])	break 2;;
			*)
				echo "\tLegal values are 0 - 13 "
		esac
	fi
done
while :; do
	echo "\nHow many logical 'slices' should be created for this drive ? \c"
	read slice
	if [ "$slice" = "q" ]
	then	exit 1;
	fi
	case "$slice" in
		[1-9]|1[0-6])
			break 2;;
		*)
			echo "\tLegal values are 1 - 16"
	esac
done
if [ $blkmajor = 0 ]	# smd controller
then
	rvnum=`expr $controller \* 4 + $drive`
	rvdev=/dev/rv$rvnum
	rvminor=`expr $rvnum \* 16`
	if [ -b $rvdev ]
	then	echo $rvdev already exists
	else
		echo /etc/mknod $rvdev b 2 $rvminor
		/etc/mknod $rvdev b 2 $rvminor
		/bin/chmod 600 $rvdev
		/bin/chgrp sys $rvdev
		/bin/chown root $rvdev
	fi
fi 
i=0
while [ $i -lt $slice ]
do
	dev=c${controller}d${drive}s$i
	if [ $blkmajor = 0 ]
	then	# smd
		minor=`expr $rvminor + $i`
	else	# scsi
		minor=`expr $drive \* 16 + $i`
	fi
	if [ -b /dev/dsk/$dev ]
	then	echo /dev/dsk/$dev already exists
	else
		echo /etc/mknod /dev/dsk/$dev b $blkmajor $minor
		/etc/mknod /dev/dsk/$dev b $blkmajor $minor
		/bin/chmod 400 /dev/dsk/$dev
		/bin/chgrp sys /dev/dsk/$dev
		/bin/chown root /dev/dsk/$dev
	fi
	if [ -c /dev/rdsk/$dev ]
	then	echo /dev/rdsk/$dev already exists
	else
		echo /etc/mknod /dev/rdsk/$dev c $chrmajor $minor
		/etc/mknod /dev/rdsk/$dev c $chrmajor $minor
		/bin/chmod 400 /dev/rdsk/$dev
		/bin/chgrp sys /dev/rdsk/$dev
		/bin/chown root /dev/rdsk/$dev
	fi
	i=`expr $i + 1`
done
exit 0
