
while :; do
	echo "\nWhat type of 9-track device do you want to create

	1.  Fuji
	2.  Cypher
	3.  Single Density

	:\c"
	read model
	if [ "$model" = "q" ]
	then	exit 1;
	fi
	if [ "$model" = "1" -o "$model" = "2" -o "$model" = "3" ]
	then	break
	fi
	echo "\tPlease type 1, 2, or 3"
done
case "$model" in
	1)	major=20;;
	2)	major=21;;
	3)	major=23
		density="0"
		Density=m;;
esac
while [ "$model" != "3" ]; do
	echo "\nHigh density or low density ('h' or 'l') ? \c"
	read density
	if [ "$density" = "q" ]
	then	exit 1;
	fi
	if [ "$density" = "h" -o "$density" = "l" ]
	then	if [ "$density" = "l" ]
		then	density="0"
			Density=m
		else	density="1"
			Density=h
		fi
		break
	fi
	echo "\tPlease type 'h' or 'l'"
done
while :; do
	echo "\nHigh speed or low speed ('h' or 'l') ? \c"
	read speed
	if [ "$speed" = "q" ]
	then	exit 1;
	fi
	if [ "$speed" = "h" -o "$speed" = "l" ]
	then	if [ "$speed" = "l" ]
		then	speed="0"
		else	speed="1"
			Speed=s
		fi
		break
	fi
	echo "\tPlease type 'h' or 'l'"
done
while :; do
	echo "\nTo which controller will this 9-track drive be attached (0-3)? \c"
	read controller
	if [ "$controller" = "q" ]
	then	exit 1;
	fi
	case "${controller:=X}" in
		q)	exit 1 ;;
		[0-3])
			break 2;;
		*)
			echo "Legal values are 0 - 3. Look at the output from an 'icb -l' command"
			echo "to see how many controllers (HSDT or EDT) are currently running.";;
	esac
done
while :; do
	echo "\nWhich physical drive on controller $controller (0-3)? \c"
	read drive
	case "${drive:=X}" in
		q)	exit 1 ;;
		[0-3])
			break 2;;
		*)
			echo "\tLegal values are 0 - 3 "
	esac
done
while :; do
	echo "\nDoes this 9-track drive have a cache ? \c"
	read cache
	if [ "$cache" = "q" ]
	then	exit 1;
	fi
	if [ "$cache" = "y" -o "$cache" = "n" ]
	then	if [ "$cache" = "n" ]
		then	cache="0"
		else	cache="1"
			Cache=c
		fi
		break
	fi
	echo "\tPlease type 'y' or 'n'"
done
while :; do
	echo "\nShould this device rewind when it is closed ? \c"
	read rwoc
	if [ "$rwoc" = "q" ]
	then	exit 1;
	fi
	if [ "$rwoc" = "y" -o "$rwoc" = "n" ]
	then	if [ "$rwoc" = "n" ]
		then	rwoc="0"
			Rwoc=n
		else	rwoc="1"
		fi
		break
	fi
	echo "\tPlease type 'y' or 'n'"
done
dev=/dev/9mt/c${controller}d${drive}${Density}${Cache}${Speed}${Rwoc}
if ls -l $dev > /dev/null 2>&1
then	echo "\n$dev already exists"
	exit 1
fi
minor=`expr $speed \* 128 + $rwoc \* 64 + $controller \* 16 + $density \* 8 + $cache \* 4 + $drive`
echo "\nCreating $dev, major # = $major, minor # = $minor\n"
/etc/mknod $dev c $major $minor
/bin/chmod 666 $dev
/bin/chgrp sys $dev
/bin/chown root $dev
if ls -l $dev > /dev/null 2>&1
then	:
else	echo "/etc/mknod failed"
	exit 1
fi
