/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) find_reqs.c: version 25.1 created on 12/2/91 at 16:05:55	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)find_reqs.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

#include <sys/types.h>
#include <sys/vreg.h>
#include <sys/icb.h>

#ifdef S3000	/* hh1 */
#include <sys/vmem.h>	
#include <sys/pm_iomap.h>
#include <sys/sbus.h>
#include <sys/kmem.h>
#endif

#define	HSDT_FREE_MAX	24
#define	EDT_FREE_MAX	48

extern int	errno;

char		*progname, *hs_ptr;
struct devq	*freelist[128], *request[128], *response[128];
int		freelist_cnt, request_cnt, response_cnt;
int		kmem_fd, board_type;
struct bd_desc	bd, *bd_ptr;
unsigned 	bd_offset;

int		debug = 0;	/* lots of debug output if set */

#define INVALID	129

main(argc,argv)
int	argc;
char	*argv[];
{
	int		slot_num = 0;
	extern unsigned icb_base();

	progname = argv[0];

	if ( argc != 2 ) {
		printf("usage: %s slot_num\n", progname);
		exit(1);
	}

	slot_num = atoi(argv[1]);
#ifdef S3000
	if ( slot_num < 0 || slot_num > 18 ) {
#else
	if ( slot_num < 7 || slot_num > 18 ) {
#endif
		printf("%s: Illegal slot_num (%d)\n", progname, slot_num);
		exit(2);
	}
	if ( (kmem_fd = open("/dev/kmem", 0)) < 0 ) {
		printf("%s: can't open /dev/kmem.\n", progname);
		exit(3);
	}

	check_board_type(slot_num);

	/* icb offset */
	hs_ptr = (char *)icb_base(slot_num);	/* hh1 */

	if ( debug )
		printf("hs_ptr = 0x%x\n", hs_ptr);

	printf("%s in Slot %d\n", board_type==EDT ? "EDT" :
				board_type==HSDT  ? "HSDT" : "SCSI", slot_num );

	/* read bd_desc location from /dev/kmem */
#ifdef S3000
	if ( lseek(kmem_fd, kv_to_kmem((int)hs_ptr + BDVECT), 0) == -1 ) {
#else
	if ( lseek(kmem_fd, (int)hs_ptr + BDVECT , 0) == -1 ) {
#endif
		printf("%s : /dev/kmem lseek failed [%d]\n", errno);
		exit(1);
	}
	if ( read(kmem_fd, &bd_offset, sizeof bd_offset) != sizeof bd_offset) {
		printf("%s : /dev/kmem read failed [%d]\n", progname, errno);
		exit(1);
	}

	/* set bd_ptr */
	bd_ptr = (struct bd_desc *)( (unsigned) hs_ptr + bd_offset ); 

	if ( debug ) 
		printf("bd_ptr = 0x%x\n", bd_ptr);

	/* read in bd_desc struct for that controller */
	read_bd_desc();

	check_freelist();
	check_request();
	check_response();

	cross_check();
	return(0);
}

read_bd_desc()
{

#ifdef S3000	/* 	hh1 - s3000 port	*/
	if ( lseek(kmem_fd, kv_to_kmem((unsigned)bd_ptr), 0) == -1 ) {
#else
	if ( lseek(kmem_fd, (unsigned)bd_ptr, 0) == -1 ) {
#endif
		printf("read_bd_desc: lseek failed [%d]\n", errno);
		exit(1);
	}

	if ( read(kmem_fd, &bd, sizeof(struct bd_desc))
	  != sizeof(struct bd_desc) ) {
		printf("read_bd_desc: read failed [%d]\n", errno);
		exit(1);
	}
}


check_freelist()
{
	register struct devq	*req, *xreq;
	struct devq		dq;
	register		i, x;
	register short		*reqp;


	req =  bd.freefst;

	if ( debug )
		printf("freefst 0x%x\n", req);

	if ( req == (struct devq *) 0 ) {
		printf("Nothing on freelist\n");
		return;

	}

	for ( i = 0; req; i++ ) {

		if ( board_type==HSDT && i>=HSDT_FREE_MAX || i>=EDT_FREE_MAX )
			printf("ERROR freelist has %d entries\n", i+1);

		/* read in request */
		read_devq(req, &dq);

		freelist[i] = req;

		reqp = (short *)&dq;
		reqp+= 4;		/* skip forward/backward links */

		for ( x = 8; x < sizeof(struct devq); x += 2, reqp++ ) {
			if ( *reqp ) {
				printf("0x%x on freelist not clear\n", req);
				showreq(&dq);
				break;
			}
		}

		if ( debug )
			printf("dq.q_next 0x%x\n", dq.q_next);

		req = dq.q_next;
	}

	printf("Freelist has %d entries\n", i );

	freelist_cnt = i;
}

read_devq(req, fillme)
struct devq	*req, *fillme;
{
	int		devq_addr;

	devq_addr = (int)hs_ptr + (int)req;

	if ( debug )
		printf("devq_addr = 0x%x\n", devq_addr);

#ifdef S3000	/* hh1 - s3000 port */
	if ( lseek(kmem_fd, kv_to_kmem((unsigned)devq_addr), 0) == -1 ) {
#else
	if ( lseek(kmem_fd, (unsigned)devq_addr, 0) == -1 ) {
#endif
		printf("read_devq: lseek failed [%d]\n", errno);
		exit(1);
	}

	if ( read(kmem_fd, fillme, sizeof(struct devq))
	  != sizeof(struct devq) ) {
		printf("read_devq: read failed [%d]\n", errno);
		exit(1);
	}
}

check_response()
{
	register struct devq	*req, *xreq;
	struct devq		dq;
	register		i;


	req =  bd.rsfst;

	if ( debug )
		printf("rsfst 0x%x\n", req);

	if ( req == (struct devq *) 0 ) {
		printf("Nothing on response queue.\n");
		return;

	}

	for ( i = 0; req; i++ ) {

		if ( board_type==HSDT && i>=HSDT_FREE_MAX || i>=EDT_FREE_MAX )
			printf("ERROR response queue has %d entries\n",i+1);

		/* read in request */
		read_devq(req, &dq);

		response[i] = req;

		if ( debug )
			printf("dq.q_next 0x%x\n", dq.q_next);

		req = dq.q_next;
	}

	printf("Response queue has %d entries\n", i );

	response_cnt = i;
}

check_request()
{
	register struct devq	*req, *xreq;
	struct devq		dq;
	register		i;


	req =  bd.reqfst;

	if ( debug )
		printf("reqfst 0x%x\n", req);

	if ( req == (struct devq *) 0 ) {
		printf("Nothing on request queue.\n");
		return;

	}

	for ( i = 0; req; i++ ) {

		if ( board_type==HSDT && i>=HSDT_FREE_MAX || i>=EDT_FREE_MAX )
			printf("ERROR request queue has %d entries\n", i+1);

		/* read in request */
		read_devq(req, &dq);

		request[i] = req;

		if ( debug ) 
			printf("dq.q_next 0x%x\n", dq.q_next);

		req = dq.q_next;
	}

	printf("Request queue has %d entries\n", i );

	request_cnt = i;
}

cross_check()
{
	register struct devq	*req;
	register		i, this_req;

	/* check freelist entries */

	req = freelist[0];

	for ( i = 0; req; i++, req = freelist[i] ) {

		if ( i > 127 ) {
			printf("Hit end of freelist array\n");
			break;
		}

		dup_check(req, freelist, i, freelist_cnt, "freelist");
		dup_check(req, response, INVALID, response_cnt, "response");
		dup_check(req, request, INVALID, request_cnt, "request");

	}

	for ( i = 0; req; i++, req = request[i] ) {

		if ( i > 127 ) {
			printf("Hit end of request array\n");
			break;
		}

		dup_check(req, request, i, request_cnt, "request");
		dup_check(req, response, INVALID, response_cnt, "response");
	}

	for ( i = 0; req; i++, req = response[i] ) {

		if ( i > 127 ) {
			printf("Hit end of response array\n");
			break;
		}

		dup_check(req, response, i, response_cnt, "response");
	}
}

dup_check(req, array, index, count, name)
register struct devq	*req;
register struct devq	*array[];
int			index;
register		count;
char			*name;
{
	register x;

	for ( x = 0; x < count; x++ ) {

		if ( (x != index) && (req == array[x]) )
			printf("0x%x %s[%d]\n", req, name, x);
	}
}

check_board_type(slot)
int	slot;
{
	register char	icbname[20];
	register int	icb_fd, i;
	struct icb	icb;

	for ( i = 0; i <= 18; i++ ) {

		if ( i < 10 )
			sprintf(icbname, "/dev/icb0%d", i);
		else
			sprintf(icbname, "/dev/icb%d", i);

		if ( debug ) 
			printf("opening %s\n", icbname);

		if ( (icb_fd = open(icbname, 0)) < 0 ) {
			/*
			printf("%s: can't open %s [%d]\n", progname,
			  icbname, errno);
			exit(1);
			*/
			break;
		}

		if (ioctl(icb_fd, ICBGET, &icb) < 0) {
			printf("%s: ICBGET failed [%d]\n", progname, errno);
			exit(1);
		}

		if ( icb.slot != slot )
			continue;

		if ( debug )
			printf("icb.type 0x%x\n", icb.type);

		if ( icb.type!=HSDT && icb.type!=EDT && icb.type!=SCSIEDT) {
			printf("%s: invalid controller in slot %d\n",
			  progname, slot);
			exit(5);
		}
		else {
			board_type = icb.type;
			return;
		}
	}

	printf("No icb entry found for slot %d\n", slot);

	exit(1);
}

showreq(req)
struct devq	*req;
{
	register	i;
	register unsigned char	*p;

	p = (unsigned char *)req;

	for ( i = 0; i < sizeof(struct devq); i++, p++) {

		if ( i && ((i % 4) == 0) )
			printf("  ");

		if ( i && (i % 24) == 0 )
			printf("\n");

		printf("%.2x",  *p);
	}
	printf("\n\n");
}

/*
** hh1	this routine comes from gcttymon.c (where it is called get_gcbase)
*/
unsigned 
icb_base(slot)
	short slot;
{
	register unsigned gcbase;
#ifdef S3000
	register unsigned iom_num, icb_adj_slot, temp;

	iom_num = slot / NUM_ICB_DEVS_PER_IOA;
	icb_adj_slot = slot % NUM_ICB_DEVS_PER_IOA;
	gcbase = KIO_START;
	temp = (ICB_MAP_ENTRY + (iom_num * NEXT_ICB_MAP)) << PM_UnmappedBits;
	gcbase += temp;
	temp = icb_adj_slot * ICBDPMEMSZ;
	gcbase += temp;
#else	/* A1000 */
	gcbase = ICB_BASE(slot);
#endif	/* S3000 */
	return(gcbase);
}/*----------------------------------------------------------------------*/
