/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) setnode.c: version 25.1 created on 12/2/91 at 16:05:46	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)setnode.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/* As sent to the customer, each kernel has a nodename of 
 * ARIX.
 * However, the uucp utilities expect a unique nodename for
 * each member of a network -- currently a problem if you 
 * have more than one arete machine in the network.
 *
 * Setnodename allows the system administrator to set the 
 * kernel nodename to some new (up to 9 char ) name.
 *
 * CHECK THIS
 * This utility warns if the name will exceed 6 chars
 * ( I believe 6 is the max for uucp ).
 * 
 * It is recommended that the user not change the nodename of
 * a running kernel. He should cp the kernel to something else
 * then reboot with the new changed kernel.
 * However, -i ( incore ) allows the change of nodename in /dev/kmem
 *
 * CHECK THIS
 * Is there some way I can tell what kernel is running currently
 * and keep the user from changing it?
 *
 * USAGE
 * 1. cp /arix /arix_tmp
 * 2. /etc/setnodename  /arix_tmp  new_nodename
 * 3. sync
 * 4. cd /; /etc/shutdown
 * 5. reboot with rp(?,0)arix_tmp
 *
 */

#include <stdio.h>		/* for file writing functions */
#include <a.out.h>		/* for all file structure defines */
#include <ldfcn.h>		/* for file reading functions */
#include <sys/utsname.h>	/* for the nodename struct define */
#include <errno.h>		/* for some of the error messages */

#ifdef S3000
#include <sys/kmem.h>
#endif                             /* JAS#2 */

#define KMEM	"/dev/kmem"	/* /dev/kmem */

LDFILE *ldptr;			/* ptr to read symtable in file */
FILE *fp;			/* ptr to write the file */
FILE *kfp;			/* ptr to the KMEM */
AOUTHDR aouthdr;		/* to locate physical data start */
struct filehdr filehdr;
SYMENT syment;			/* symbol table entry */
SCNHDR scnhdr;			/* to locate begin of data in file */
struct utsname utsname; 	/* the struct in question */
struct utsname kutsname; 	/* the KMEM struct in question */
struct utsname uutsname; 	/* the uname struct in question */

char	* filename,		/* the kernel file name to be changed */
	* nodename,		/* the new nodename */
	* utilname;		/* argv[0]: the name of the utility */
char	incore = 0;		/* -i flag to alter /dev/kmem */

main(argc,argv)
int argc;
char *argv[];
{
 register int index;	/* index to symbols */
	register int spot;	/* loc of utsname data in file */
	register int kspot;	/* loc of utsname data in kmem */
	getargs(argc,argv);

	/* check the length of the new nodename */
	{
		register len=strlen(nodename);
		/* quit if its too long */
		if(len > 9){
			fprintf(stderr,"%s: New nodename must be less than 9 characters\n",
			utilname);
			exit(1);
			}

		/* warn if its too long for uucp give chance to quit */
		if(len > 6 ){
			fprintf(stderr,"%s: Warning: Some versions of uucp accept nodenames only up to 6 chars. \n(continuing)\n",
			utilname);
			}
		}
	
	/* can you even access() the file name -- does it exist? */
	if( incore ){
		if( access( KMEM, 02|04 )){
			fprintf(stderr, "%s: ",utilname);
			perror( KMEM );
			exit(1);
			}
	}
	if( access( filename, 02|04 )){ 
		fprintf(stderr, "%s: ",utilname);
                perror( filename );
                exit(1);
	}
	/**/

	/* fopen the file for read and update */
	if(incore){
		if( NULL == ( kfp = fopen( KMEM, "r+" ))){
			fprintf(stderr,"%s: Cannot open the source file %s for writing\n",
			utilname, KMEM);
			exit(1);
			}
		}
	if( NULL == ( fp = fopen( filename, "r+" ))){
		fprintf(stderr,"%s: Cannot open the source file %s for writing\n",
		utilname, filename);
		exit(1);
		}

	/* ldopen file to make it convenient to read symbol entries */
	ldptr = NULL;
	if( NULL ==(ldptr = ldopen( filename, ldptr ))){
		fprintf(stderr,"%s: Cannot open the source file %s for reading\n",
		utilname, filename);
		exit(1);
		}
/*
	if( FAILURE ==  ldfhread( ldptr, &filehdr )){
		fprintf(stderr,"%s: Cannot read filehdr in source file %s\n",
		utilname, filename);
		exit(1);
		}
*/

	/* make sure that the file is not stripped */
	if( !HEADER(ldptr).f_symptr ){
		fprintf(stderr,"%s: No symbols in source file %s \n",
		utilname, filename);
		exit(1);
		}

	/* read the first word & make sure the right magic */

	if( M68AWRMAGIC != (HEADER(ldptr).f_magic) && M68AROMAGIC != 
	   (HEADER(ldptr).f_magic) && A68020MAGIC != (HEADER(ldptr).f_magic)
	   && M68040MAGIC_OS != (HEADER(ldptr).f_magic ) ){  /* JAS#3 */
		fprintf(stderr,
	      "%s: Illegal magic number [ %#o ] [ %#o ] for source file %s \n",
		utilname, HEADER(ldptr).f_magic, filename);
		exit(1);
		}

	/* ldohseek to the optional header */
	if( ldohseek(ldptr) == FAILURE ){
		fprintf(stderr,"%s: Cannot seek to optional header in source file %s \n",
		utilname, filename);
		exit(1);
		}

	/* FREAD the optional header */
	if( (spot=FREAD( &aouthdr, sizeof( aouthdr ), 1, ldptr)) 
		== FAILURE){
		fprintf(stderr,"%s: Cannot read optional header [ %#x ] in source file %s \n",
		utilname, spot, filename);
		exit(1);
		}

	/* ldnsseek to the ".data" section */
	if( ldnsseek(ldptr,".data") == FAILURE ){
		fprintf(stderr,"%s: Cannot seek to data section header in source file %s \n",
		utilname, filename);
		exit(1);
		}

	/* ldnshread read the scnhdr */
	if( ldnshread(ldptr, ".data", &scnhdr) == FAILURE ){
		fprintf(stderr,"%s: Cannot read data section header in source file %s \n",
		utilname, filename);
		exit(1);
		}

	/* ldtbseek seek to the beginning of the  symbol table */
	if( ldtbseek(ldptr) == FAILURE ){
		fprintf(stderr,"%s: Cannot seek to symbol table in source file %s \n",
		utilname, filename);
		exit(1);
		}

	/* ldtbread read the first symbol table entry -- check err */
	if( 0 != ( index = ldtbindex(ldptr))){
		fprintf(stderr,"%s: Cannot get first symbol index [ %d ] in source file %s \n",
		utilname, index, filename);
		exit(1);
		}
	if( ldtbread( ldptr, index, &syment) == FAILURE){
		fprintf(stderr,"%s: Cannot read first symbol in source file %s \n",
		utilname, filename);
		exit(1);
		}

	/* while strncmp to utsname doesnt mach keep ldtbreading */
#ifdef OCC
	while(strncmp("_utsname",ldgetname(ldptr, &syment),9)){
#else
	while(strncmp("utsname",ldgetname(ldptr, &syment),9)){
#endif
	/* if during that time you run out of symbols-exit not found */
	/*
		fprintf(stderr,"[ %d ][ %s ]\n",index,ldgetname(ldptr, &syment));
*/
		if( FAILURE == ( index = ldtbindex(ldptr))){
			fprintf(stderr,"%s: Cannot get next symbol index [ %d ] in source file %s \n",
			utilname, index, filename);
			exit(1);
			}
		if( ldtbread( ldptr, index, &syment) == FAILURE){
			fprintf(stderr,"%s: Cannot read next symbol [ %d ] in source file %s \n",
			utilname, index , filename);
			exit(1);
			}
		}

	/* if found then fseek to the spot in the data section */
	spot = scnhdr.s_scnptr + (syment.n_value - aouthdr.data_start);
#ifdef S3000
	kspot = kv_to_kmem (syment.n_value);
#else
	kspot = syment.n_value;
#endif
	if(incore){
		if( NULL != fseek( kfp, kspot, 0L )){
			fprintf(stderr,"%s: Cannot fseek to utsname data [ %#x ] in source file %s \n",
			utilname, kspot, KMEM);
			exit(1);
			}
		}

	if( NULL != fseek( fp, spot, 0L )){
		fprintf(stderr,"%s: Cannot fseek to utsname data [ %#x ] in source file %s \n",
		utilname, spot, filename);
		exit(1);
		}

	/* read the structure utsname */
	if( incore ){
		if(  1 != fread( &kutsname, sizeof(kutsname), 1, kfp)) {
			fprintf(stderr,"%s: Cannot READ utsname structure in source file %s \n",
			utilname, KMEM);
			exit(1);
			}
		}
	if(  1 != fread( &utsname, sizeof(utsname), 1, fp)) {
		fprintf(stderr,"%s: Cannot READ utsname structure in source file %s \n",
		utilname, filename);
		exit(1);
		}


	/* you might print out the oldname and the new name */
	fprintf(stderr,"OLD NAME (%s) [ %.9s ]\n",filename,utsname.nodename);

	if(incore){
		if(uname(&uutsname)<0){
			fprintf(stderr,"%s: Cannot get uname of running kernel\n",
			utilname);
			exit(1);
			}
		if(strncmp(kutsname.nodename,uutsname.nodename,9)){
			fprintf(stderr,"%s: %s nodename[ %s ] and uname[ %s ] must match\n",
			utilname,KMEM,kutsname.nodename,uutsname.nodename);
			exit(1);
			}
		fprintf(stderr,"OLD NAME (%s) [ %.9s ]\n",KMEM,kutsname.nodename);
		if(strncmp(kutsname.nodename,utsname.nodename,9)){
			fprintf(stderr,"%s: %s nodename[ %s ] and %s nodname[ %s ] must match\n",
			utilname,KMEM,kutsname.nodename,filename,utsname.nodename);
			exit(1);
			}
		}

	/* replace the name in the structure */
	strncpy( utsname.nodename, nodename, 9);
	if( incore )
		strncpy( kutsname.nodename, nodename, 9);

	/* reseek to that location befor writing */
	if( incore ){
		if( NULL != fseek( kfp, kspot, 0L )){
			fprintf(stderr,"%s: Cannot fseek to utsname data [ %#x ] in source file %s \n",
			utilname, kspot, KMEM);
			exit(1);
			}
		}
	if( NULL != fseek( fp, spot, 0L )){
		fprintf(stderr,"%s: Cannot fseek to utsname data [ %#x ] in source file %s \n",
		utilname, spot, filename);
		exit(1);
		}

	/* write out the name to the file */
	if( incore ){
		if( 1 != fwrite( &kutsname, sizeof(kutsname), 1, kfp)) {
			fprintf(stderr,"%s: Cannot WRITE utsname structure in source file %s \n",
			utilname, KMEM);
			exit(1);
			}
		}
	if( 1 != fwrite( &utsname, sizeof(utsname), 1, fp)) {
		fprintf(stderr,"%s: Cannot WRITE utsname structure in source file %s \n",
		utilname, filename);
		exit(1);
		}
	sync();sync();
/* Now check that all wrote ok */
	if( incore ){
		if( NULL != fseek( kfp, kspot, 0L )){
			fprintf(stderr,"%s: Cannot fseek to Confirm utsname data [ %#x ] in source file %s \n",
			utilname, kspot, KMEM);
			exit(1);
			}
		}
	if( NULL != fseek( fp, spot, 0L )){
		fprintf(stderr,"%s: Cannot fseek to Confirm utsname data [ %#x ] in source file %s \n",
		utilname, spot, filename);
		exit(1);
		}
	/* read the structure utsname */
	if( incore ){
		if(  1 != fread( &kutsname, sizeof(kutsname), 1, kfp)) {
			fprintf(stderr,"%s: Cannot READ utsname to Confirm in source file %s \n",
			utilname, KMEM);
			exit(1);
			}
		}
	if(  1 != fread( &utsname, sizeof(utsname), 1, fp)) {
		fprintf(stderr,"%s: Cannot READ utsname to Confirm in source file %s \n",
		utilname, filename);
		exit(1);
		}
	if( incore ){
	if(strncmp(kutsname.nodename,nodename,9)){
		fprintf(stderr,"%s: Warning, bad copy of nodename [ %s ] to file %s\n",
		utilname,kutsname.nodename,KMEM);
		}
		}
	if(strncmp(utsname.nodename,nodename,9)){
		fprintf(stderr,"%s: Warning, bad copy of nodename [ %s ] to file %s\n",
		utilname,utsname.nodename,filename);
		}

	fprintf(stderr,"NEW NAME (%s) [ %.9s ]\n",filename,utsname.nodename);
	if(incore)
		fprintf(stderr,"NEW NAME (%s) [ %.9s ]\n",KMEM,kutsname.nodename);
	/* close the files */
	fclose(fp);
	if(incore)
		fclose(kfp);
	ldclose(ldptr);

	/* sync the system */
	sync();sync();

	/* all done */

} /* end main */

getargs(ac,av)
int ac;
char *av[];
{
int c;
extern char *optarg;	
extern int optind;
	utilname = av[0];
	/* are there enough arguments? */
	if(ac < 3){
		fprintf(stderr,"usage: %s [ -i ] -n new_nodename kernel_file_name \n",
		utilname);
	
		exit(1);
		}
while(optind < ac){
	while ((c = getopt(ac, av, "in:")) != EOF)
		switch(c){
		case 'i':
			incore++;	break;
		case 'n':
			nodename = optarg;	break;
		case '?':
		default:
			exit(1);
			
		} /* end switch */
		if(&filename[0] == '\0')
			filename = av[optind];
		optind++;
	}
} /* end getargs */
