/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) setlp.c: version 25.1 created on 12/2/91 at 16:05:42	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)setlp.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/*
	Line Printer Type Device (parallel) Setup Utility

	use:
		to set line printer parameters indent, columns, lines,
		nocr, and cap. see the following Unix manual sections
		for more information:
			lp(7)    in the administrator reference manual
			lp spooling    in the administrator guide

	history:
		10/17/85  creation date
		3/19/87	  added ackdly option (-d)
 */
	
#include <stdio.h>
#include <sys/lprio.h>

struct lprio lprio;

struct flags {
	char *flgname;
	unsigned char flgbit;
} flags[] = {
	"nocr",NOCR,
	"cap",CAP,
	"raw",LPRAW,
};
#define NUMFLAGS (sizeof(flags)/sizeof(struct flags))

main(argc,argv)
	char *argv[];
{	register struct lprio *lpptr = &lprio;
	register i, minus;
	char *progname;

	if(ioctl(0,LPRGET,lpptr) == -1) {
badarg:
		fprintf(stderr,"usage: setlp [-gi:c:l:d:][-nocr][-cap][-raw] </dev/lp\n");
		exit(2);
	}
	if(argc == 1) {
		printf("indent = %d; columns = %d; lines = %d;\n",
			lpptr->ind, lpptr->col, lpptr->line);
		printflags(lpptr);
		exit(0);
	}
	progname = *argv++; argc--;
	for(; argc > 0; argc--, argv++) {
		if(**argv == '-') {
			minus = 1;
			(*argv)++;
		} else minus = 0;
		for(i=0; i<NUMFLAGS; i++) {
			if(strcmp(*argv,flags[i].flgname) == 0) { /* is it a flag? */
				if(minus) lpptr->flag &= ~flags[i].flgbit; /* turn bit off */
				else lpptr->flag |= flags[i].flgbit; /* turn bit on */
				goto donearg;
			}
		}
		if(minus) { /* options must always be preceeded by a minus */
			switch(**argv) { /* get the option */
				case 'i':
					if((lpptr->ind = getnum(&argv,&argc)) < 0)
						goto badarg;;
					continue;
				case 'c':
					if((lpptr->col = getnum(&argv,&argc)) < 0)
						goto badarg;;
					continue;
				case 'd':
					if((lpptr->ackdly = getnum(&argv,&argc)) < 0)
						goto badarg;;
					continue;
				case 'l':
					if((lpptr->line = getnum(&argv,&argc)) < 0)
						goto badarg;;
					continue;
				case 'g':
					printf("-i%d -c%d -l%d ", lpptr->ind, lpptr->col, lpptr->line);
					printflags(lpptr);
					continue;
			}
		}
		goto badarg; /* not flag or option */
donearg: ;
	}
	ioctl(0,LPRSET,lpptr);
}

printflags(lpptr)
	register struct lprio *lpptr;
{	register i;

	for(i=0; i<NUMFLAGS; i++) {
		printf("%s%s ", !(lpptr->flag & flags[i].flgbit) ? "-" : "", flags[i].flgname);
	}
	printf("\n");
}

getnum(argv_ptr,argc_ptr)
	register char ***argv_ptr;
	int *argc_ptr;
{	int num;
	char *cptr;

	**argv_ptr += 1; /* point to next char */
	if(***argv_ptr == 0) { /* if null point to next argument */
		(*argv_ptr)++; (*argc_ptr)--;
	}
	num = strtol(**argv_ptr,&cptr,10); /* convert ascii to long */
	if((cptr == **argv_ptr && num == 0) || *cptr) {
		fprintf(stderr,"illegal character in decimal number\n");
		return(-1);
	}
	return(num);
}
