#	START NEW ARIX SCCS HEADER
#
#	@(#) mktty.sh: version 25.1 created on 12/2/91 at 16:05:39
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#ident	"@(#)mktty.sh	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
#
#	END NEW ARIX SCCS HEADER
#

is_iopm=no

while :; do
	if [ $1 ]
	then
		type=$1
		shift
	else
		echo "\nWhat kind of board do you want to create nodes for :"
		echo "        SPM/ACRW (S), or IOPM/ACDB (I) ? \c"
		read type
	fi
	if [ "$type" = "q" ]
	then	exit 1;
	fi
	case "$type" in
		[Ss])	MAJOR=`/etc/drvinstall -m spmtydvr -n`
			break 2;;
		[Ii])	is_iopm=yes
			MAJOR=75
			break 2;;
		*)
			echo "\nPlease respond with "S", or "I"."
	esac
done

if [ "$MAJOR" = "" ]
then 	echo $0 : error - cannot find major number, aborting
	exit 1
fi

if [ "$is_iopm" = "yes" ]
then
	while :;do
		if [ $1 ]
		then
			iopmnum=$1
			shift
		else
			echo "\nWhich IOPM/ACDB are these devices for (0-4) ? \c"
			read iopmnum
		fi
		case "$iopmnum" in
			"q")	exit 1;;
			[0-4])	start_minor=`expr 64 \* $iopmnum`
				break 2;;	
			*) echo "Legal values are 0-4"
		esac
	done
else
	start_minor=0
fi

if [ $start_minor -ge 256 ]
then
	MAJOR=76
	start_minor=`expr $start_minor - 256`
fi

while :;do
	if [ $1 ]
	then
		ttynum=$1
		shift
	else
		echo "\nWhat starting tty number would you like to use \c"
		echo "(default $start_minor) ? \c"
		read ttynum
	fi
	case "$ttynum" in
		"q")			exit 1;;
		"")			ttynum=$start_minor;
					break 2;;
		-)			ttynum=$start_minor;
					break 2;;
		[0-9])			break 2;;
		[1-9][0-9])		break 2;;
		[1-9][0-9][0-9])	break 2;;
		*) echo "Legal values are 0-999"
	esac
done

while :;do
	if [ $1 ]
	then
		numttys=$1
		shift
	else
		echo "\nHow many tty devices would you like to create (default 16) ? \c"
		read numttys
	fi
	case "$numttys" in
		"q")	exit 1;;
		"")	numttys=16;
			break 2;;
		-)	numttys=16;
			break 2;;
		[0-9])		break 2;;
		[1-5][0-9])	break 2;;
		6[0-4])		break 2;;
		*) echo "Legal values are 0-64"
	esac
done

minor=$start_minor
end_minor=`expr $start_minor + $numttys`
while [ $minor -lt $end_minor ]
do
	if [ $ttynum -lt 10 ]
	then	dev=/dev/tty0$ttynum
	else 	dev=/dev/tty$ttynum
	fi

	if [ ! -c $dev ]
	then 	makedev=yes
	else	echo "$dev already exists. Do you want to delete it \c"
		echo "and create a new one? \c"
		read answer
		if [ "$answer" = "y" -o "$answer" = "Y" ]
		then 	
			/bin/rm $dev
			makedev=yes
		else 	echo "The old device will be left intact."
			makedev=no
		fi
	fi

	if [ "$makedev" = "yes" ]
	then	echo /etc/mknod $dev c $MAJOR $minor
		/etc/mknod $dev c $MAJOR $minor
		/bin/chmod 644 $dev
		/bin/chgrp sys $dev
		/bin/chown root $dev
	fi

	ttynum=`expr $ttynum + 1`
	minor=`expr $minor + 1`
done
