
#	START NEW ARIX SCCS HEADER
#
#	@(#) mkrmt.sh: version 25.1 created on 12/2/91 at 16:05:35
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#ident	"@(#)mkrmt.sh	25.1	12/2/91 Copyright (c) 1991 by Arix Corporation"
#
#	END NEW ARIX SCCS HEADER
#
while :; do
	echo "\nTo which IOPM/DSDB will this tape drive be connected (0-5)? \c"
	read iopm
	if [ "$iopm" = "q" ]
	then	exit 1;
	fi
	case "${iopm:=X}" in
		q)	exit 1 ;;
		[0-5])
			break 2;;
		*)
			echo "Legal values are 0 - 5."
	esac
done

set `/etc/drvinstall -m iopmb -n`
shift_val=`expr $iopm \* 8 + 1`	# offset into iopmb major number list
if [ $# -le $shift_val ]
then	echo $0 : error - cannot get major number
	exit 1
fi
shift $shift_val
MAJOR=$1


/local/bin/mk_dsdb_auto $iopm

while :; do
	echo "\nWhich scsi id number on IOPM $iopm ? \c"
	read id
	if [ "$id" = "q" ]
	then	exit 1;
	fi
	case "${id:=X}" in
		[0-9])  break 2;;
		1[0-4])	break 2;;
		*)
			echo "\tLegal values are 0 - 14 "
	esac
done

while :; do
     echo "\nDo you want this to be the default cartridge tape drive (y/n) ? \c"
	read default
	if [ "$default" = "y" -o "$default" = "n" ]
	then	
		break
	fi
	echo "\tPlease type 'y' or 'n'"
done

for rewind in 0 1
do
	if [ "$rewind" = "1" ]
	then	suffix="r"
	else	suffix=""
	fi
	dev=/dev/rmt/c${iopm}d$id$suffix
	if [ -c $dev ]
	then 	echo $dev already exists.
	else
		minor=`expr $id \* 16 + $rewind`
		echo /etc/mknod $dev c $MAJOR $minor
		/etc/mknod $dev c $MAJOR $minor
		/bin/chmod 666 $dev
		/bin/chgrp sys $dev
		/bin/chown root $dev
		if [ "$default" = "y" ]
		then
			echo ln $dev /dev/rmt$rewind
			ln $dev /dev/rmt$rewind
		fi
	fi
done
