#	START NEW ARIX SCCS HEADER
#
#	@(#) mkopt.sh: version 25.1 created on 12/2/91 at 16:05:32
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	@(#)mkopt.sh	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation
#
#	END NEW ARIX SCCS HEADER
#

if [ ! -d /dev/opt ]; then
  mkdir /dev/opt
  chmod 777 /dev/opt
fi

if [ -c /dev/opt/* ]; then
  rm /dev/opt/*
fi

while :; do
	echo "\nTo which IOPM/DSDB will the optical drives be attached (0-5)? \c"
	read iopm
	if [ "$iopm" = "q" ]
	then	exit 1;
	fi
	case "${iopm:=X}" in
		[0-5])
			break 2;;
		*)
			echo "Legal values are 0 - 5."
	esac
done

set `/etc/drvinstall -m iopmb -n`
shift_val=`expr $iopm \* 8 `	# offset into iopmb major number list
if [ $# -le $shift_val ]
then	echo $0 : error - cannot get major number
	exit 1
fi
shift $shift_val
MAJOR=$8		# optical driver has 8th major number on a dsdb

id=0
while [ $id != 15 ]
do
	dev=c${iopm}d${id}
	minor=`expr $id \* 16`

	# make character device
	rdev=/dev/opt/$dev
	echo /etc/mknod $rdev c $MAJOR $minor
	/etc/mknod $rdev c $MAJOR $minor
	/bin/chmod 440 $rdev
	/bin/chgrp imix $rdev
	/bin/chown root $rdev

	# make eject on close device 
	minor=`expr $minor + 1`
	ejdev=/dev/opt/"$dev"j 
	echo /etc/mknod $ejdev c $MAJOR $minor
	/etc/mknod $ejdev c $MAJOR $minor
	/bin/chmod 440 $ejdev
	/bin/chgrp imix $ejdev
	/bin/chown root $ejdev

	id=`expr $id + 1`
	if [ $id = 7 ]
	then
		id=`expr $id + 1`
	fi
done 
exit 0
