#	START NEW ARIX SCCS HEADER
#
#	@(#) mklpnod.sh: version 25.1 created on 12/2/91 at 16:05:29
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	@(#)mklpnod.sh	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation
#
#	END NEW ARIX SCCS HEADER
#
#

is_iopm=no

while :; do
	echo "\nWhat kind of board do you want to create nodes for :"
	echo "        SPM/ACRW (S), IOPM/ACDB (I), or quit (q) ? \c"
	read type
	if [ "$type" = "q" ]
	then	exit 1;
	fi
	case "$type" in
		[Ss])	major=`/etc/drvinstall -m spmlpdvr -n`
			dev=/dev/spmplp0
			break 2;;
		[Ii])	is_iopm=yes
			break 2;;
		*)
			echo "\nPlease respond with "S", "I", or "q"."
	esac
done

# if [ "$major" = "" ]
# then 	echo $0 : error - cannot find major number, aborting
# 	exit 1
# fi

if [ "$is_iopm" = "yes" ]
then
	while :;do
		echo "\nWhich IOPM/ACDB is this device for (0-4) ? \c"
		read iopmnum
		case "$iopmnum" in
			"q")	exit 1;;
			[0-4])	minor=`expr 672 + 16 \* $iopmnum`
				break 2;;	
			*) echo "Legal values are 0-4"
		esac
	done

	set -k `/etc/drvinstall -nm iopms`
	while :;do
		major=$1
		if [ $minor -le 255 ]
		then
                        devnum=`expr $minor / 16 - 10`
                        dev=/dev/plp$devnum
			break
		fi
		minor=`expr $minor - 256`
		shift
	done

else
	minor=0
fi

if [ ! -c $dev ]
then 	makedev=yes
else	echo "$dev already exists. Do you want to delete it \c"
	echo "and create a new one? \c"
	read answer
	if [ "$answer" = "y" -o "$answer" = "Y" ]
	then 	
		/bin/rm -f $dev
		makedev=yes
	else 	echo "The old device will be left intact."
		makedev=no
	fi
fi

if [ "$makedev" = "yes" ]
then	echo /etc/mknod $dev c $major $minor
	/etc/mknod $dev c $major $minor
	/bin/chmod 600 $dev
	/bin/chgrp bin $dev
	/bin/chown lp $dev
	echo "\nThe new parallel printer device is $dev."
fi

