
#	START NEW ARIX SCCS HEADER
#
#	@(#) mkdsk.sh: version 25.1 created on 12/2/91 at 16:05:26
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#ident	"@(#)mkdsk.sh	25.1	12/2/91 Copyright (c) 1991 by Arix Corporation"
#
#	END NEW ARIX SCCS HEADER
#

while :; do
	echo "\nTo which IOPM/DSDB will this disk drive be attached (0-5)? \c"
	read iopm
	if [ "$iopm" = "q" ]
	then	exit 1;
	fi
	case "${iopm:=X}" in
		[0-5])
			break 2;;
		*)
			echo "Legal values are 0 - 5."
	esac
done

set `/etc/drvinstall -m iopmb -n`
shift_val=`expr $iopm \* 8 `	# offset into iopmb major number list
if [ $# -le $shift_val ]
then	echo $0 : error - cannot get major number
	exit 1
fi
shift $shift_val
MAJOR=$1


/local/bin/mk_dsdb_auto $iopm

while :; do
	echo "\nWhich scsi id number on IOPM $iopm ? \c"
	read id
	if [ "$id" = "q" ]
	then	exit 1;
	fi
	case "${id:=X}" in
		[0-9])  break 2;;
		1[0-4])	break 2;;
		*)
			echo "\tLegal values are 0 - 14 "
	esac
done
while :; do
	echo "\nHow many logical slices should be created for this drive ? \c"
	read slice
	if [ "$slice" = "q" ]
	then	exit 1;
	fi
	case "$slice" in
		[1-9]|1[0-6])
			break 2;;
		*)
			echo "\tLegal values are 1 - 16"
	esac
done
i=0
while [ $i -lt $slice ]
do
	dev=c${iopm}d${id}s$i

	minor=`expr $id \* 16 + $i`
	if [ -b /dev/dsk/$dev ]
	then	echo /dev/dsk/$dev already exists.
	else
		echo /etc/mknod /dev/dsk/$dev b $MAJOR $minor
		/etc/mknod /dev/dsk/$dev b $MAJOR $minor
		/bin/chmod 400 /dev/dsk/$dev
		/bin/chgrp sys /dev/dsk/$dev
		/bin/chown root /dev/dsk/$dev
	fi
	if [ -c /dev/rdsk/$dev ]
	then	echo /dev/rdsk/$dev already exists.
	else 
		echo /etc/mknod /dev/rdsk/$dev c $MAJOR $minor
		/etc/mknod /dev/rdsk/$dev c $MAJOR $minor
		/bin/chmod 400 /dev/rdsk/$dev
		/bin/chgrp sys /dev/rdsk/$dev
		/bin/chown root /dev/rdsk/$dev
	fi	

	i=`expr $i + 1`
done
exit 0
