

while :; do
	echo "\nTo which IOPM/DSDB will this CD ROM drive be connected (0-5)? \c"
	read iopm
	if [ "$iopm" = "q" ]
	then	exit 1;
	fi
	case "${iopm:=X}" in
		q)	exit 1 ;;
		[0-5])
			break 2;;
		*)
			echo "Legal values are 0 - 5."
	esac
done

set `/etc/drvinstall -m iopmb -n`
shift_val=`expr $iopm \* 8 + 4`	# offset into iopmb major number list
if [ $# -le $shift_val ]
then	echo $0 : error - cannot get major number
	exit 1
fi
shift $shift_val
MAJOR=$1

/local/bin/mk_dsdb_auto $iopm

while :; do
	echo "\nWhich scsi id number on IOPM $iopm ? \c"
	read id
	if [ "$id" = "q" ]
	then	exit 1;
	fi
	case "${id:=X}" in
		[0-9])  break 2;;
		1[0-4])	break 2;;
		*)
			echo "\tLegal values are 0 - 14 "
	esac
done

dev=c${iopm}d$id

if [ -c /dev/rcdrom/$dev ]
then 	echo /dev/rcdrom/$dev already exists.
else
	minor=`expr $id \* 16`
	echo /etc/mknod /dev/rcdrom/$dev c $MAJOR $minor
	/etc/mknod /dev/rcdrom/$dev c $MAJOR $minor
	/bin/chmod 600 /dev/rcdrom/$dev
	/bin/chgrp sys /dev/rcdrom/$dev
	/bin/chown sys /dev/rcdrom/$dev
fi

if [ -b /dev/cdrom/$dev ]
then 	echo /dev/cdrom/$dev already exists.
else
	minor=`expr $id \* 16`
	echo /etc/mknod /dev/cdrom/$dev b $MAJOR $minor
	/etc/mknod /dev/cdrom/$dev b $MAJOR $minor
	/bin/chmod 600 /dev/cdrom/$dev
	/bin/chgrp sys /dev/cdrom/$dev
	/bin/chown sys /dev/cdrom/$dev
fi
