

if [ "$1" = "" ]
then
	echo usage: $0 iopm_number
	exit 1
fi
iopm=$1
case "$1" in
	[0-5])
		break;;
	*)
		echo "$0: legal values for iopm number are 0-5."
esac

set `/etc/drvinstall -m iopmb -n`
shift_val=`expr $iopm \* 8 + 3`	# offset into iopmb major number list
if [ $# -le $shift_val ]
then	echo $0 : error - cannot get major number
	exit 1
fi
shift $shift_val
pt_maj=$1

for id in 0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15
do
	pt_dev=/dev/scsi_pt/c${iopm}d$id
	if [ -c $pt_dev ]
	then continue
	fi
	/etc/mknod $pt_dev c $pt_maj $id
	/bin/chown sys $pt_dev
	/bin/chgrp sys $pt_dev
	/bin/chmod 0600 $pt_dev
	if [ ! -c $pt_dev ]
	then 	echo "$0: unable to create device $pt_dev."
		exit 1
	fi
done


#
# create /dev/dsdb_sar/c$iopm if it does not already exist.
#

set `/etc/drvinstall -m iopmb -n`
shift_val=`expr $iopm \* 8 + 5`	# offset into iopmb major number list
if [ $# -le $shift_val ]
then	echo $0 : error - cannot get major number for
	exit 1
fi
shift $shift_val
sa_maj=$1

sar_dev=/dev/dsdb_sar/c$iopm
if [ -c $sar_dev ]
then exit 0
fi
/etc/mknod $sar_dev c $sa_maj 0
/bin/chown bin $sar_dev
/bin/chgrp bin $sar_dev
/bin/chmod 0444 $sar_dev

if [ ! -c $sar_dev ]
then 	echo "$0: unable to create device $sar_dev."
	exit 1
fi

exit 0

