#################################################################
if [ $# -ne 1 ]
then
	echo "usage: $0 file-system-mount-point"
	exit 1
fi
# if its a mounted file system, see if lost+found needs to be made
if  /etc/mount | grep "^$1 " > /dev/null
then
	if [ -d $1/lost+found ]
	then
		echo Working in existing $1/lost+found
	else
		echo Creating $1/lost+found
		/bin/mkdir $1/lost+found
	fi

	echo Creating temporary files in $1/lost+found
	i=0
	while [ $i -lt 300 ]; do
		> $1/lost+found/$i
		i=`expr $i + 1`
	done
	echo Removing temporary files from $1/lost+found
	i=0
	while [ $i -lt 300 ]; do
		rm -f $1/lost+found/$i
		i=`expr $i + 1`
	done
else
	echo "$0: $1  is not a mounted file system"
	exit 3
fi
#################################################################
