/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) lsnames.c: version 25.1 created on 12/2/91 at 16:04:07	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)lsnames.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	AT&T: #ident	"listen:lsnames.c	1.2"		*/

#ident	"@(#)listen:lsnames.c	25.1"


#include <string.h>
#include <ctype.h>
#include <sys/utsname.h>

#include "lsparam.h"		/* listener parameters		*/
#include "lserror.h"

/*
 * getnodename:	return "my" nodename in a char string.
 */

static struct utsname myname;
static char _nodename[sizeof(myname.nodename) + 1];

char *
getnodename()
{
	register struct utsname *up = &myname;

	DEBUG((9,"in getnodename, sizeof(_nodename) = %d", sizeof(_nodename)));

	if ( uname(up) )
		sys_error(E_UNAME, EXIT);

	/* will be null terminated by default */
	strncpy(_nodename,up->nodename,sizeof(up->nodename));
	return(_nodename);
}

