#	START NEW ARIX SCCS HEADER
#
#	@(#) listen.mk: version 25.1 created on 12/2/91 at 16:03:43
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	@(#)listen.mk	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation
#
#	END NEW ARIX SCCS HEADER
#
#	Copyright (c) 1984 AT&T
#	  All Rights Reserved

#	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T
#	The copyright notice above does not evidence any
#	actual or intended publication of such source code.
#	AT&T: #ident	"listen:listen.mk	1.14.2.1"

#ident	"@(#)listen:listen.mk	25.1"

#
# listen.mk:
# makefile for network listener - System V release 3.1
#

IROOT =
SROOT =
include $(IROOT)/macdefs

# INC	= $(ROOT)/usr/include
# OPT	= -O
# CFLAGS	= -Um68k -Um68 -Umc68k -US4 -Uvax  -UMICROOMS -Updp11 -Uu3b -Du3b2 -I$(INC) ${OPT}
# LDFLAGS	= $(LLDFLAGS)
LDLIBS = -lnsl_s
LSTINC	= .

# change the next two lines to compile with -g
# OPT	= -g
# LLDFLAGS= -s
OPTION	= -DDEBUGMODE

CHKDIR = $(ROOT)/usr/net $(ROOT)/usr/net/nls
INSDIR = $(ROOT)/usr/net/nls

LSUID	= 81
LSGID	= adm
LIBID	= bin

# LLDLIBS	=  $(LIBNLS)


# The DEBUG module can always be included...
# if DEBUGMODE is undefined, no code gets compiled.
# doprnt.o is from system V rel 5.0.5.

DBGOBJ	= doprnt.o
DBGSRC	= doprnt.c

SOURCE	= \
	listen.c \
	lsdata.c \
	lsdbf.c \
	lslog.c \
	lssmb.c \
	nlsaddr.c \
	nlsdata.c $(DBGSRC)

S4SRC = \
	lsnames.c \
	nlsconnect.c \
	nlsname.c \
	nlsestab.c \
	putenv.c

PRODUCT	= $(INSDIR)/listen

LSOBJS	= \
	listen.o \
	lslog.o \
	lsdbf.o \
	lssmb.o \
	lsdata.o \
	nlsdata.o \
	nlsaddr.o

S4OBJS = \
	lsnames.o \
	nlsconnect.o \
	nlsname.o \
	nlsestab.o \
	putenv.o

all:	listen

# 
# SHAREDLIB version
#

listen:		$(LSOBJS) $(LLDLIBS) 
		$(CC) $(CFLAGS) -o listen $(LSOBJS) \
			$(LDFLAGS) $(LLDLIBS) $(LDLIBS)
#		$(CC) $(CFLAGS) -o listen $(LSOBJS) $(DBGOBJ) \
			$(LDFLAGS) $(LLDLIBS) $(LDLIBS)

s4stuff:	$(S4OBJS)
		$(CC) -c $(S4OBJS)

listen.o:	listen.c
lsdbf.o:	lsdbf.c
lslog.o:	lslog.c
lssmb.o:	lssmb.c
lsdata.o:	lsdata.c
nlsdata.o:	nlsdata.c
nlsaddr.o:	nlsaddr.c
doprnt.o:	doprnt.c

# listener library routines and /usr/include headers:
# putenv.o should only be included on an S4. (not included in s4's libc.a)
# In addition, nlsconnect.o, nlsestab.o, and nlsname.o are only on the S4.

# S4 stuff only

nlsconnect.o:	nlsconnect.c
nlsname.o:	nlsname.c
nlsestab.o:	$(LSTINC)/listen.h nlsestab.c
putenv.o:	putenv.c


install:	all $(CHKDIR)
		$(INS) listen $(INSDIR)/listen
		chmod 755 $(INSDIR)/listen
		chgrp $(LSGID) $(INSDIR)/listen
		chown $(LSUID) $(INSDIR)/listen

$(CHKDIR):
		mkdir $@
		chown $(LSUID) $@
		chgrp $(LSGID) $@

ctags:
	ctags	$(SOURCE)
	echo 'grep $$* \\' > greplist
	for i in $(SOURCE)		;\
	do echo "$$i \\" >> greplist	;\
	done
	echo /dev/null >> greplist
	chmod +x greplist

clean:
	-rm -f *.o

clobber: clean
	-rm -f listen

FRC:
