/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) xtstats.c: version 25.1 created on 12/2/91 at 16:00:47	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)xtstats.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	ATT:#ident	"xt:xtstats.c	2.3"	*/
	
#ident	"@(#)layers:xtstats.c	25.1"


/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*
**	Routine to print 'xt' driver statistics
*/

#include	"sys/types.h"
#include	"sys/tty.h"
#include	"sys/jioctl.h"
#include	"sys/xtproto.h"
#include	"sys/xt.h"
#include	"stdio.h"

#if	XTSTATS == 1
Stats_t		Stats[S_NSTATS];

char *		Descs[S_NSTATS]	=
{
	 "packets transmitted"
	,"packets received"
	,"CRC errors"
	,"bad ack"
	,"bad nak"
	,"packets out of sequence"
	,"retransmissions generated by naks"
	,"duplicate packets received"
	,"naks received"
	,"naks transmitted"
	,"acks received"
	,"acks transmitted"
	,"packets with bad headers"
	,"packets with bad size"
	,"acks not received"
	,"bad control packets"
	,"bad control data packets"
	,"system free list empty"
	,"received packets with command size/data size mismatch"
	,"received packets with channel out of range"
	,"received packets with unrecognised command"
	,"channel 0 receive buffer unavailable for command"
	,"receive packets terminated by timeout"
	,"retransmissions generated by timeouts"
	,"wakeups for wflushes"
	,"wakeups for writes"
};

extern long		time();
extern char *		ctime();

#define	SYSERROR	(-1)
#endif



void
xtstats(cfd, ofd)
	int		cfd;
	register FILE *	ofd;
{
#	if	XTSTATS == 1
	register long	l;
	register int	i;
	register int	count = 0;

	if ( ioctl(cfd, XTIOCSTATS, Stats) == SYSERROR )
		return;

	for ( i = 0 ; i < S_NSTATS ; i++ )
		if ( l = Stats[i] )
		{
			if ( count++ == 0 )
			{
				long	t;

				(void)time(&t);
				(void)fprintf(ofd, "\n%15.15s Xt Statistics:-\n", ctime(&t)+4);
			}
			(void)fprintf(ofd, "%11ld %s\n", l, Descs[i]);
		}
	if ( count )
		(void)fflush(ofd);
#	endif
}
