/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) labelit.c: version 25.1 created on 12/2/91 at 15:59:33	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)labelit.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	ATT:#ident	"labelit:labelit.c	1.14"		*/

#ident	"@(#)labelit:labelit.c	25.1"

#include <stdio.h>
#include <sys/param.h>
#ifndef	RT
#include <signal.h>
#include <sys/types.h>
#endif
#include <sys/sysmacros.h>
#include <sys/fs/s5filsys.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <mnttab.h>

#define DEV 1
#define FSNAME 2
#define VOLUME 3
#define Fs4b	3
#define Fs8b	4
#define MNTTAB "/etc/mnttab"
#define FREMOTE	0x0002	/* file is remote (see <sys/user.h>)  */
 /* write fsname, volume # on disk superblock */
struct {
	char fill1[BSIZE/2];
	union {
		char fill2[BSIZE/2];
		struct filsys fs;
	} f;
} super;
#ifdef RT
#define IFTAPE(s) (equal(s,"/dev/mt",7)||equal(s,"mt",2))
#define TAPENAMES "'/dev/mt'"
#else
#define IFTAPE(s) (equal(s,"/dev/rmt",8)||equal(s,"rmt",3)||equal(s,"/dev/rtp",8)||equal(s,"rtp",3))
#define TAPENAMES "'/dev/rmt' or '/dev/rtp'"
#endif
struct	mnttab	Mp;
int fi, n;
int i,j;
char s3[]="";

struct {
	char	t_magic[8];
	char	t_volume[6];
	char	t_reels,
		t_reel;
	long	t_time,
		t_length,
		t_dens;
	char	t_fill[484];
} Tape_hdr;

sigalrm()
{
	signal(SIGALRM, sigalrm);
}


main(argc, argv) 
char **argv; 
{
	int fsi, fso, type;
	long curtime;
	struct stat statb;
	static char *usage = "Usage: labelit /dev/??? [fsname volume [-n]]\n";
	char *s2="r";
	static char spec[32], *specp1, *specp2, *p1, *p2;

	signal(SIGALRM, sigalrm);

#ifdef RT
	setio(-1,1);	/* use physical io */
#endif

	if(argc!=4 && argc!=2 && argc!=5)  {
		fprintf(stderr, usage);
		exit(2);
	}
	if((fsi = open(argv[DEV],0)) < 1) {
		fprintf(stderr, "labelit: cannot open %s\n",argv[DEV]);
		exit(2);
	}
	if(fstat(fsi, &statb)<0 || (statb.st_mode&S_IFMT)!=S_IFCHR){
		fprintf(stderr,"%s is not a character-special device\n",argv[DEV]);
		close(fsi);
		exit(2);
	}
					/* shen SPR# 1469 6/13/89 */
	if((fi = open(MNTTAB, 0)) < 0) {
		fprintf(stderr, "labelit: cannot open %s\n",MNTTAB);
		exit(1);
	}

		n=0;	
		strcpy(&spec,&s3);
	    	specp2= strpbrk(argv[DEV], s2);
		if (specp2  !=0) {
		specp2--;
		for (p1=argv[DEV]; p1<=specp2; p1++) n++;	  	
		p2=spec;
		for (j=0; j<n; j++) p2++;
		strncpy(&spec, argv[DEV], n);
		specp2++;
		specp2++;
		n=strlen(argv[DEV])-n-1;
		strncpy(p2, specp2,  n);
	}

	while ((i = read(fi, &Mp, sizeof(Mp))) == sizeof(Mp)) {
	  if ( (Mp.mt_ro_flg & FREMOTE) || (strlen(Mp.mt_dev)==0))
			continue;

		if (strcmp(Mp.mt_dev,spec ) ==0) {
		fprintf(stderr,"labelit: %s already mounted\n",  argv[DEV]);
		exit(1);
	  }
	}
	close (fi);

	ioctl(fsi,PERGET,&type); /* if ioctl fails, assume disk device */
	if(argc==5) {
		if(strcmp(argv[4], "-n")!=0) {
			close(fsi);
			fprintf(stderr, usage);
			exit(2);
		}
		if(!type) {
			close(fsi);
			fprintf(stderr, "labelit: `-n' option for tape only\n");
			fprintf(stderr, usage);
			exit(2);
		}
		printf("Skipping label check!\n");
		goto do_it;
	}

	if(type) {
		alarm(5);
		read(fsi, &Tape_hdr, sizeof(Tape_hdr));
		alarm(0);
		if(!(equal(Tape_hdr.t_magic, "Volcopy", 7)||
		    equal(Tape_hdr.t_magic,"Finc",4))) {
			close(fsi);
			fprintf(stderr,"labelit: %s is not labelled!\n",argv[DEV]);
			exit(2);
		}
		printf("%s tape volume: %s, reel %d of %d reels\n",
			Tape_hdr.t_magic, Tape_hdr.t_volume, Tape_hdr.t_reel, Tape_hdr.t_reels);
		printf("Written: %s", ctime(&Tape_hdr.t_time));
		if(argc==2 && Tape_hdr.t_reel>1) {
			close(fsi);
			exit(0);
		}
	}
	if((i=read(fsi, &super, sizeof(super))) != sizeof(super))  {
		close(fsi);
		fprintf(stderr, "labelit: cannot read superblock\n");
		exit(2);
	}

#define	S	super.f.fs
	printf("Current fsname: %.6s, Current volname: %.6s,",
		S.s_fname, S.s_fpack, S.s_fsize);
	if (S.s_magic != FsMAGIC){
		close(fsi);
		printf("\nIllegal magic number (%d)\n", S.s_magic);
		exit(1);
		}
	if ((S.s_type == Fs2b) || (S.s_type == FsSEC1)) 
#ifdef u3b5
		printf(" Blocks: %ld, Inodes: %d\nFS Units: 2Kb, ",
			S.s_fsize * 4, (S.s_isize - 2) * 32);
#else
		printf(" Blocks: %ld, Inodes: %d\nFS Units: 1Kb, ",
			S.s_fsize /* * 2 */, (S.s_isize - 2) * 16);
#endif
	if (S.s_type == Fs4b)
		printf(" Blocks: %ld, Inodes: %d\nFS Units: 2Kb, ",
			S.s_fsize * 4 , (S.s_isize - 2) * 32);
	if ((S.s_type == Fs8b) || (S.s_type == FsSEC4))
		printf(" Blocks: %ld, Inodes: %d\nFS Units: 4Kb, ",
			S.s_fsize * 8 , (S.s_isize - 2) * 64);
	printf("Date last mounted: %s", ctime(&S.s_time));
	if(argc==2){
		close(fsi);
		exit(0);
	}
do_it:
	printf("NEW fsname = %.6s, NEW volname = %.6s -- DEL if wrong!!\n",
		argv[FSNAME], argv[VOLUME]);
	sleep(10);
	sprintf(super.f.fs.s_fname, "%.6s", argv[FSNAME]);
	sprintf(super.f.fs.s_fpack, "%.6s", argv[VOLUME]);
	super.f.fs.s_magic = FsMAGIC;

	close(fsi);
	fso = open(argv[DEV],1);
	if(type) {
		strcpy(Tape_hdr.t_magic, "Volcopy");
		sprintf(Tape_hdr.t_volume, "%.6s", argv[VOLUME]);
		if(write(fso, &Tape_hdr, sizeof(Tape_hdr)) < 0) {
			close(fso);
			fprintf(stderr,"labelit: cannot write tape header to %s\n",argv[DEV]);
			exit(2);
		}
	}
	if(write(fso, &super, sizeof(super)) < 0) {
		close(fso);
		fprintf(stderr,"labelit: cannot write superblock to %s\n",argv[DEV]);
		exit(2);
	}
	close(fso);
	exit(0);
}
equal(s1, s2, ct)
char *s1, *s2;
int ct;
{
	register i;

	for(i=0; i<ct; ++i) {
		if(*s1 == *s2) {;
			if(*s1 == '\0') return(1);
			s1++; s2++;
			continue;
		} else return(0);
	}
	return(1);
}
