.SA 1
.sp 2
.ce
KSH-88 - The KornShell Command and Programming Language
.sp 2
.al
.P
KSH-88 is the most recent version of the KornShell Language
described in
"The KornShell Command and Programming Language,"
by Morris Bolsky and David Korn of AT&T Bell Laboratories.
The KornShell is a shell programming language,
which is upward compatible with "sh" (the Bourne Shell), with many added
features.
KSH-88 provides an enhanced programming environment in
addition to the major command-entry features of the BSD
shell "csh".  With KSH-88, medium-sized programming tasks can be
performed at shell-level without a significant loss in performance.
In addition, "sh" scripts can be run on KSH-88 without modification.
.P
A number of enhancements and bug fixes have been made, many of which
were to enhance portability with certain compile options driven by
the characteristics of the target system.
Most of the code now conforms
to the IEEE POSIX 1003.1 standard and to the proposed ANSI-C standard.
Like the previous version, KSH-I,
it is designed to accept eight bit character sets
transparently, thereby making it internationally compatible.
It can support multi-byte characters sets with some characteristics
of the character set given at run time.
.P
KSH-88 provides the following features, which were also inherent in
KSH-I:
.BL
.LI
Enhanced Command Re-entry Capability:  The KSH-88 history
function records commands entered at any shell level and stores
them, up to a user-specified limit, even after you log off.
This allows you to re-enter long commands with a few keystrokes
- even those commands you entered yesterday.
The history file allows for eight bit characters in
commands and supports essentially unlimited size histories.
.LI
In-line Editing: In "sh", the only way to fix mistyped
commands is to backspace or retype the line. KSH-88 allows you
to edit a command line using a choice of EMACS-TC or "vi"
functions.
You can use the in-line editors to complete filenames as
you type them.
You may also use this editing feature when entering
command lines from your history file.
.LI
Extended I/O Capabilities:  KSH-88 provides several I/O
capabilities not available in "sh", including the ability to:
.BL
.LI
specify a file descriptor for input
.LI
start up and run co-processes
.LI
produce a prompt at the terminal before a read
.LI
easily format and interpret responses to a menu
.LI
echo lines exactly as output without escape processing
.LI
read and echo lines ending in "\e".
.LE
.LI
Improved performance: KSH-88 executes many scripts faster
than the System V Bourne shell. A major reason for this is
that many of the functions provided by "echo" and "expr" are
built-in.
.LI
Integer Arithmetic: A built-in command in KSH-88 allows you
to do integer arithmetic in any base from two to thirty-six.
Almost the complete set of C language operators are available.
Further, variables in arithmetic expressions may include
one-dimensional arrays.  Arithmetic expressions can be used to
form arguments to commands.
.LI
Shell Functions and Aliases: Two mechanisms - functions and
aliases - can be used to assign a user-selected identifier to
an existing command or shell script.
Functions allow local variables and provide scoping
for exception handling.
Functions can be searched for and loaded on first reference the
way scripts are.
.LI
Substring Capabilities:  KSH-88 allows you to create a
substring of any given string directly by stripping off leading
or trailing substrings during parameter substitution.
You can also specify attributes, such as upper and lower case,
field with, and justification to shell variables.
.LI
More pattern matching capabilities:  KSH-88 allows you to specify
regular expressions for file and string matches.
.LI
Improved debugging:  KSH-88 can generate line numbers on execution
traces.  Also, I/O redirections are now traced.
There is a DEBUG trap that gets evaluated after each command
so that errors can be localized.
.LI
Job Control: On systems that support job control, including
System V Release 4, KSH-88
provides a job-control mechanism almost identical to that of
the BSD "csh", version 4.1.
This feature allows you
to stop and restart programs, and to move programs between the
foreground and the background.
.LI
Added security:
KSH-88 can execute scripts which do not have read permission
and scripts which have the setuid and/or setgid set when
invoked by name, rather than as an argument to the shell.
It is possible to log or control the execution of setuid and/or
setgid scripts.
The noclobber option prevents you from accidentally erasing
a file by redirecting to an existing file.
.LE
Documentation for KSH-88 consists of an "Introduction to KSH-88",
"Compatibility with the Bourne Shell" and a manual page and a
README file.  In addition, the "KornShell Command and Programming
Language," book is available from Prentice Hall.

Product specs follow...


