#	START NEW ARIX SCCS HEADER
#
#	@(#) ksh.mk: version 25.1 created on 12/2/91 at 15:55:02
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	@(#)ksh.mk	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation
#
#	END NEW ARIX SCCS HEADER
#
include	$(IROOT)/macdefs

# This is a posix binary.  Turn off the SVID flag
SVID_FLAG=

# Bug in optimized code.  Turn off optimization for now.
OPTFLAG =

INC = $(INCRT)
INS = install
SHLIB = shlib
DEBUG = # -DJOBDEBUG # -DDBUG
DONEWGRP=	-DNEWGRP	# enable internal version of newgrp command
DOKILL	=	-DKILL	# enable internal version of kill command

LOCAL_CFLAGS = $(DEBUG) $(DONEWGRP) $(DOKILL) -I$(INC) -DARETE -DARIX -DLSTAT

LIBS =
STRIP = strip
SIZE = size
BIN = $(ROOT)/bin
ETC = $(ROOT)/etc
Ins = install
LInc = include
Sh = sh
SH = ksh
RDONLY = $(Ins)/readonly

all:	$(SH) suid_exec

$(SH):	$(LInc)/sh_config.h arith.o args.o blok.o builtin.o cmd.o ctype.o \
		defs.o edit.o echo.o error.o expand.o fault.o history.o \
		io.o jobs.o macro.o main.o msg.o name.o print.o service.o \
		string.o stak.o test.o word.o xec.o emacs.o vi.o libsh.a
	$(CC) $(LDFLAGS) -o $(SH) arith.o args.o blok.o builtin.o cmd.o \
		ctype.o defs.o edit.o echo.o error.o expand.o fault.o  \
		history.o io.o jobs.o macro.o main.o msg.o name.o print.o \
		service.o string.o stak.o test.o word.o xec.o emacs.o \
		vi.o libsh.a $(LIBS)

$(LInc)/sh_config.h:
		$(Ins)/config > newconfig
		if	test -r $(LInc)/sh_config.h && \
			cmp -s newconfig $(LInc)/sh_config.h;\
		then	rm newconfig	 ;\
		else	mv newconfig $(LInc)/sh_config.h;\
		fi

$(RDONLY):
		chmod +x $(Ins)/gen_rdonly
		CC=$(CC) $(Ins)/gen_rdonly 2> /dev/null
		chmod +x $(RDONLY)

arith.o:	$(Sh)/arith.c $(LInc)/streval.h $(LInc)/sh_config.h \
		$(LInc)/defs.h $(LInc)/stak.h $(LInc)/shnodes.h \
		$(LInc)/brkincr.h $(LInc)/name.h $(LInc)/flags.h
	$(CC) -I$(LInc) $(CFLAGS) -DKSHELL -c $(Sh)/arith.c

args.o:	$(Sh)/args.c $(LInc)/builtins.h $(LInc)/sym.h $(LInc)/jobs.h \
		$(LInc)/terminal.h $(LInc)/defs.h $(LInc)/stak.h \
		$(LInc)/shnodes.h $(LInc)/brkincr.h $(LInc)/name.h \
		$(LInc)/flags.h
	$(CC) -I$(LInc) $(CFLAGS) -DKSHELL -c $(Sh)/args.c

blok.o:	$(Sh)/blok.c $(LInc)/defs.h $(LInc)/stak.h $(LInc)/shnodes.h \
		$(LInc)/brkincr.h $(LInc)/name.h $(LInc)/flags.h
	$(CC) -I$(LInc) $(CFLAGS) -DKSHELL -c $(Sh)/blok.c

builtin.o:	$(Sh)/builtin.c $(LInc)/sym.h $(LInc)/jobs.h \
		$(LInc)/terminal.h $(LInc)/builtins.h $(LInc)/history.h \
		$(LInc)/defs.h $(LInc)/stak.h $(LInc)/shnodes.h \
		$(LInc)/brkincr.h $(LInc)/name.h $(LInc)/flags.h
	$(CC) -I$(LInc) $(CFLAGS) -DKSHELL -c $(Sh)/builtin.c

cmd.o:	$(Sh)/cmd.c $(LInc)/test.h $(LInc)/builtins.h $(LInc)/history.h \
		$(LInc)/sym.h $(LInc)/defs.h $(LInc)/stak.h \
		$(LInc)/shnodes.h $(LInc)/brkincr.h $(LInc)/name.h \
		$(LInc)/flags.h
	$(CC) -I$(LInc) $(CFLAGS) -DKSHELL -c $(Sh)/cmd.c

ctype.o:	$(RDONLY) $(Sh)/ctype.c
	chmod +x $(RDONLY)
	$(RDONLY) -I$(LInc) $(CFLAGS) -DKSHELL $(Sh)/ctype.c

defs.o:	$(Sh)/defs.c $(LInc)/timeout.h $(LInc)/edit.h $(LInc)/history.h \
		$(LInc)/sym.h $(LInc)/jobs.h $(LInc)/terminal.h \
		$(LInc)/defs.h $(LInc)/stak.h $(LInc)/shnodes.h \
		$(LInc)/brkincr.h $(LInc)/name.h $(LInc)/flags.h
	$(CC) -I$(LInc) $(CFLAGS) -DKSHELL -c $(Sh)/defs.c

edit.o:	$(Sh)/edit.c $(LInc)/edit.h $(LInc)/history.h $(LInc)/sym.h \
		$(LInc)/builtins.h $(LInc)/terminal.h $(LInc)/defs.h \
		$(LInc)/stak.h $(LInc)/shnodes.h $(LInc)/brkincr.h \
		$(LInc)/name.h $(LInc)/flags.h
	$(CC) -I$(LInc) $(CFLAGS) -DKSHELL -c $(Sh)/edit.c

echo.o:	$(Sh)/echo.c $(LInc)/defs.h $(LInc)/stak.h $(LInc)/shnodes.h \
		$(LInc)/brkincr.h $(LInc)/name.h $(LInc)/flags.h
	$(CC) -I$(LInc) $(CFLAGS) -DKSHELL -c $(Sh)/echo.c

error.o:	$(Sh)/error.c $(LInc)/history.h $(LInc)/jobs.h \
		$(LInc)/terminal.h $(LInc)/defs.h $(LInc)/stak.h \
		$(LInc)/shnodes.h $(LInc)/brkincr.h $(LInc)/name.h \
		$(LInc)/flags.h
	$(CC) -I$(LInc) $(CFLAGS) -DKSHELL -c $(Sh)/error.c

expand.o:	$(Sh)/expand.c $(LInc)/sh_config.h
	$(CC) -I$(LInc) $(CFLAGS) -DKSHELL -c $(Sh)/expand.c

fault.o:	$(Sh)/fault.c $(LInc)/timeout.h $(LInc)/sym.h $(LInc)/jobs.h \
		$(LInc)/terminal.h
	$(CC) -I$(LInc) $(CFLAGS) -DKSHELL -c $(Sh)/fault.c

history.o:	$(Sh)/history.c $(LInc)/history.h $(LInc)/builtins.h
	$(CC) -I$(LInc) $(CFLAGS) -DKSHELL -c $(Sh)/history.c

io.o:	$(Sh)/io.c $(LInc)/history.h $(LInc)/sym.h
	$(CC) -I$(LInc) $(CFLAGS) -DKSHELL -c $(Sh)/io.c

jobs.o:	$(Sh)/jobs.c $(LInc)/history.h $(LInc)/jobs.h $(LInc)/terminal.h
	$(CC) -I$(LInc) $(CFLAGS) -DKSHELL -c $(Sh)/jobs.c

macro.o:	$(Sh)/macro.c $(LInc)/builtins.h $(LInc)/sym.h $(LInc)/terminal.h
	$(CC) -I$(LInc) $(CFLAGS) -DKSHELL -c $(Sh)/macro.c

main.o:	$(Sh)/main.c $(LInc)/builtins.h $(LInc)/timeout.h \
		$(LInc)/history.h $(LInc)/sym.h $(LInc)/jobs.h \
		$(LInc)/terminal.h
	$(CC) -I$(LInc) $(CFLAGS) -DKSHELL -c $(Sh)/main.c

msg.o:	$(RDONLY) $(Sh)/msg.c $(LInc)/history.h $(LInc)/timeout.h $(LInc)/test.h \
		$(LInc)/builtins.h $(LInc)/sym.h
	chmod +x $(RDONLY)
	$(RDONLY) $(CFLAGS) -I$(LInc) -DKSHELL $(Sh)/msg.c

name.o:	$(Sh)/name.c $(LInc)/timeout.h $(LInc)/history.h \
		$(LInc)/builtins.h $(LInc)/sym.h
	$(CC) -I$(LInc) $(CFLAGS) -DKSHELL -c $(Sh)/name.c

print.o:	$(Sh)/print.c $(LInc)/builtins.h
	$(CC) -I$(LInc) $(CFLAGS) -DKSHELL -c $(Sh)/print.c

service.o:	$(Sh)/service.c $(LInc)/history.h $(LInc)/builtins.h \
		$(LInc)/sym.h $(LInc)/jobs.h $(LInc)/terminal.h
	$(CC) -I$(LInc) $(CFLAGS) -DKSHELL -c $(Sh)/service.c

string.o:	$(Sh)/string.c $(LInc)/sym.h
	$(CC) -I$(LInc) $(CFLAGS) -DKSHELL -c $(Sh)/string.c

stak.o:	$(Sh)/stak.c
	$(CC) -I$(LInc) $(CFLAGS) -DKSHELL -c $(Sh)/stak.c

test.o:	$(Sh)/test.c $(LInc)/sym.h $(LInc)/test.h
	$(CC) -I$(LInc) $(CFLAGS) -DKSHELL -c $(Sh)/test.c

word.o:	$(Sh)/word.c $(LInc)/test.h $(LInc)/builtins.h $(LInc)/sym.h
	$(CC) -I$(LInc) $(CFLAGS) -DKSHELL -c $(Sh)/word.c

xec.o:	$(Sh)/xec.c $(LInc)/builtins.h $(LInc)/test.h $(LInc)/sym.h \
		$(LInc)/jobs.h $(LInc)/terminal.h
	$(CC) -I$(LInc) $(CFLAGS) -DKSHELL -c $(Sh)/xec.c

emacs.o:	$(Sh)/emacs.c $(LInc)/edit.h $(LInc)/history.h
	$(CC) -I$(LInc) $(CFLAGS) -DKSHELL -c $(Sh)/emacs.c

vi.o:	$(Sh)/vi.c $(LInc)/terminal.h $(LInc)/edit.h $(LInc)/history.h
	$(CC) -I$(LInc) $(CFLAGS) -DKSHELL -c $(Sh)/vi.c

libsh.a:	adjust.o assign.o assnum.o cannon.o chkid.o convert.o \
		findnod.o gettree.o strmatch.o growaray.o gsort.o \
		linknod.o namscan.o rjust.o strdata.o streval.o tilde.o \
		unassign.o utos.o valup.o optget.o
	$(AR) cr libsh.a adjust.o assign.o assnum.o cannon.o chkid.o \
		convert.o findnod.o gettree.o strmatch.o growaray.o gsort.o \
		linknod.o namscan.o rjust.o strdata.o streval.o tilde.o \
		unassign.o utos.o valup.o optget.o

adjust.o:	$(SHLIB)/adjust.c $(LInc)/name.h $(LInc)/flags.h $(LInc)/sh_config.h
	$(CC) -I$(LInc) $(CFLAGS) -DKSHELL -c $(SHLIB)/adjust.c

assign.o:	$(SHLIB)/assign.c $(LInc)/name.h $(LInc)/flags.h $(LInc)/sh_config.h
	$(CC) -I$(LInc) $(CFLAGS) -DKSHELL -c $(SHLIB)/assign.c

assnum.o:	$(SHLIB)/assnum.c $(LInc)/name.h $(LInc)/flags.h
	$(CC) -I$(LInc) $(CFLAGS) -DKSHELL -c $(SHLIB)/assnum.c

cannon.o:	$(SHLIB)/cannon.c $(LInc)/sh_config.h
	$(CC) -I$(LInc) $(CFLAGS) -DKSHELL -c $(SHLIB)/cannon.c

chkid.o:	$(SHLIB)/chkid.c $(LInc)/sh_config.h
	$(CC) -I$(LInc) $(CFLAGS) -DKSHELL -c $(SHLIB)/chkid.c

convert.o:	$(SHLIB)/convert.c
	$(CC) -I$(LInc) $(CFLAGS) -DKSHELL -c $(SHLIB)/convert.c

findnod.o:	$(SHLIB)/findnod.c $(LInc)/name.h $(LInc)/flags.h $(LInc)/sh_config.h
	$(CC) -I$(LInc) $(CFLAGS) -DKSHELL -c $(SHLIB)/findnod.c

gettree.o:	$(SHLIB)/gettree.c $(LInc)/name.h $(LInc)/flags.h
	$(CC) -I$(LInc) $(CFLAGS) -DKSHELL -c $(SHLIB)/gettree.c

strmatch.o:	$(SHLIB)/strmatch.c
	$(CC) -I$(LInc) $(CFLAGS) -DKSHELL -c $(SHLIB)/strmatch.c

growaray.o:	$(SHLIB)/growaray.c $(LInc)/name.h $(LInc)/flags.h
	$(CC) -I$(LInc) $(CFLAGS) -DKSHELL -c $(SHLIB)/growaray.c

gsort.o:	$(SHLIB)/gsort.c
	$(CC) -I$(LInc) $(CFLAGS) -c $(SHLIB)/gsort.c

linknod.o:	$(SHLIB)/linknod.c $(LInc)/name.h $(LInc)/flags.h
	$(CC) -I$(LInc) $(CFLAGS) -DKSHELL -c $(SHLIB)/linknod.c

namscan.o:	$(SHLIB)/namscan.c $(LInc)/name.h $(LInc)/flags.h
	$(CC) -I$(LInc) $(CFLAGS) -DKSHELL -c $(SHLIB)/namscan.c

rjust.o:	$(SHLIB)/rjust.c
	$(CC) -I$(LInc) $(CFLAGS) -DKSHELL -c $(SHLIB)/rjust.c

strdata.o:	$(RDONLY) $(SHLIB)/strdata.c $(LInc)/streval.h $(LInc)/sh_config.h
	chmod +x $(RDONLY)
	$(RDONLY) $(CFLAGS) -I$(LInc) -DKSHELL $(SHLIB)/strdata.c

streval.o:	$(SHLIB)/streval.c $(LInc)/streval.h $(LInc)/sh_config.h
	$(CC) -I$(LInc) $(CFLAGS) -DKSHELL -c $(SHLIB)/streval.c

tilde.o:	$(SHLIB)/tilde.c $(LInc)/sh_config.h
	$(CC) -I$(LInc) $(CFLAGS) -DKSHELL -c $(SHLIB)/tilde.c

unassign.o:	$(SHLIB)/unassign.c $(LInc)/name.h $(LInc)/flags.h
	$(CC) -I$(LInc) $(CFLAGS) -DKSHELL -c $(SHLIB)/unassign.c

utos.o:	$(SHLIB)/utos.c
	$(CC) -I$(LInc) $(CFLAGS) -c $(SHLIB)/utos.c

valup.o:	$(SHLIB)/valup.c $(LInc)/name.h $(LInc)/flags.h
	$(CC) -I$(LInc) $(CFLAGS) -DKSHELL -c $(SHLIB)/valup.c

optget.o:	$(SHLIB)/optget.c $(LInc)/sh_config.h
	$(CC) -I$(LInc) $(CFLAGS) -DKSHELL -c $(SHLIB)/optget.c

suid_exec:	suid_exec.o
	$(CC) $(CFLAGS) -o suid_exec suid_exec.o

suid_exec.o :	$(Sh)/suid_exec.c $(LInc)/sh_config.h
	$(CC) -I$(LInc) $(CFLAGS) -c $(Sh)/suid_exec.c

clobber :	clean
	rm -f ./$(SH) libsh.a core a.out make.out nohup.out install/readonly
	rm -f suid_exec
	rm -f */tags

clean :
	rm -f *.o

install : strip
	-rm -f $(BIN)/$(SH)
	$(INS) -o -m 555 -u bin -g root -f $(BIN) $(SH)
	-rm -f $(ETC)/suid_exec
	$(INS) -o -m 4511 -u root -g root -f $(ETC) suid_exec
	rm -f $(BIN)/r$(SH)
	ln -f $(BIN)/$(SH) $(BIN)/r$(SH)

size: all
	$(SIZE)  $(SH) suid_exec

strip: all
	$(STRIP)  $(SH) suid_exec

