/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) ldiopm.c: version 25.1 created on 12/2/91 at 15:49:21	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)ldiopm.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include <stdio.h>
#include <filehdr.h>
#include <aouthdr.h>
#include <scnhdr.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/sbus_iopm.h>
#include <sys/iopmioctl.h>

/* Global data variables						*/
struct filehdr	filehdr = {0};		/* object file header		*/
struct aouthdr 	aouthdr = {0};		/* object file opt. header	*/
struct scnhdr 	scnhdr[4] = {0};	/* object file section headers	*/
long		entry;			/* object file entry point	*/
char		*tbuf = NULL;		/* text section buffer		*/
char		*dbuf = NULL;		/* data section buffer		*/
long		tsize;			/* text section size		*/
long		dsize;			/* data section size		*/
long		bsize;			/* bss section size		*/
long		tstart;			/* starting text section addr	*/
long		dstart;			/* starting data section addr	*/
int 		iopmfd;			/* fd of IOPM device		*/

extern char	*malloc();		/* memory allocator		*/

#define FALSE		0
#define TRUE		1

main(argc, argv)
int	argc;			
char 	**argv;
{
	register uint	s;		/* # of -s config strings	*/
	register uint	b;		/* # of -b config strings	*/
	uint 		devEntered;	/* iopm device name entered?	*/
	uint		error;		/* error detected?		*/
	char 		*didFile;	/* did file name		*/
	char 		*osFile;	/* iopm OS file name		*/
	char		*sArray[NUM_CONFIG];/* array of -s config strings*/
	char		*bArray[NUM_CONFIG];/* array of -b config strings*/
	char 		argument;	/* cmd arguments		*/
	char		deviceName[40];	/* IOPM device name		*/

	extern char  	*optarg;
	extern int   	optind;
	extern int   	opterr;
	extern int	errno;		/* system errno			*/
	extern void	parseConfig();	/* parse -s or -b config string	*/
	extern void	displayHelp();	/* display help message		*/

	/* Initialize variables						*/
	devEntered = FALSE;		/* iopm number not entered	*/
	error = FALSE;			/* no error seen yet		*/
	*deviceName = '\0';		/* Set deviceName to NULL	*/
	osFile = (char *)NULL;		/* no IOPM OS file name entered	*/
	didFile = (char *)NULL;		/* no did file name entered	*/
	for(s = 0; s < NUM_CONFIG; s++)	/* clear sArray[]		*/
		sArray[s] = (char *)NULL;
	for(b = 0; b < NUM_CONFIG; b++)	/* clear bArray[]		*/
		bArray[b] = (char *)NULL;

	s = 0;				/* reset count variable		*/
	b = 0;				/* reset count variable		*/
	while(((argument = getopt(argc, argv, "d:f:F:s:b:")) != EOF) && !error)
	{
		switch (argument)
		{
		    case 'd':			/* iopm device name 	*/
			if(devEntered)
			{
				printf("ldiopm: ");
				printf("Only 1 -d option per ldiopm command\n");
				error = TRUE;
			}
			else
			{
				devEntered = TRUE;
				sprintf(deviceName,"%s",optarg);
			}
			break;

		    case 'F':			/* iopm OS load 	*/
			if(osFile)
			{
				printf("ldiopm: ");
				printf("Only 1 -F option per ldiopm command\n");
				error = TRUE;
			}
			else
				osFile = optarg;
			break;

		    case 'f':			/* did load		*/
			if(didFile)
			{
				printf("ldiopm: ");
				printf("Only 1 -f option per ldiopm command\n");
				error = TRUE;
			}
			else
				didFile = optarg;
			break;

		    case 's':			/* streams config string*/
			if(s > NUM_CONFIG)
			{
				printf("ldiopm: Too many -s strings\n");
				printf("ldiopm: Only %d supported\n",
					NUM_CONFIG);
				error = TRUE;
			}
			sArray[s] = optarg;
			s++;
			break;

		    case 'b':			/* bufs config string	*/
			if(b > NUM_CONFIG)
			{
				printf("ldiopm: Too many -b strings\n");
				printf("ldiopm: Only %d supported\n",
					NUM_CONFIG);
				error = TRUE;
			}
			bArray[b] = optarg;
			b++;
			break;

		    case '?':
			displayHelp(argument);
			error = TRUE;
			break;
		}
	}

	/* Make sure a device name was entered				*/
	if(!devEntered)
	{
		printf("ldiopm: ");
		printf("IOPM device name must be entered (-d option)\n");
		error = TRUE;
	}

	/* Make sure only one of -F or -f was entered			*/
	if(osFile && didFile)
	{
		printf("ldiopm: Both -F and -f options specified.\n");
		printf("ldiopm: These options are mutually exclusive\n");
		error = TRUE;
	}

	/* Make sure -s or -b was not entered with a -F option		*/
	if(osFile && (sArray[0] || bArray[0]))
	{
		printf("ldiopm: -s and -b options are invalid with -F\n");
		error = TRUE;
	}

	/* Make sure a -f option was specified with -s or -b		*/
	if(!didFile && (sArray[0] || bArray[0]))
	{
		printf("ldiopm: -f option must be specified with -s or -b\n");
		error = TRUE;
	}

	/* If we found a command error give up now			*/
	if(error)
		exit(1);

	/* open iopm device						*/
	if((iopmfd = open(deviceName, O_RDWR)) < 0 )
	{
		printf("ldiopm: Open of IOPM device %s failed\n",deviceName);
		perror("ldiopm");
		exit(1);
	}

	/* if -F option was entered, load IOPM OS file			*/
	if(osFile)
		ldiopm(osFile);

	/* if -f option was entered, load did				*/
	if(didFile)
		ldDID(didFile);

	/* For each config string entered, configure iopm OS		*/
	for(s = 0; sArray[s]; s++)
		parseConfig(sArray[s], STR_DEVSW);
	for(b = 0; bArray[b]; b++)
		parseConfig(bArray[b], BUF_DEVSW);

	/* If a didFile was loaded, issue a start command		*/
	if(didFile)
	{
		if(ioctl(iopmfd, START_MOD, entry))
		{
			printf("ldiopm: BOOT failed\n");
			perror("ldiopm");
			exit(1);
		}
	}

	/* Close IOPM device						*/
	close(iopmfd);
}

ldiopm(File)
char	*File;			/* name of IOPM OS file			*/
{
	int results;

	extern errno;

	/* Read IOPM OS file into memory buffers			*/
	if(!readfile(File))
		exit(errno);

	/* Reset the IOPM						*/
	if(ioctl(iopmfd, RESETIOPM, 0) < 0)
	{
		printf("ldiopm: IOPM reset failed\n");
		perror("ldiopm");
		exit(1);
	}

	/* Seek to physical mem loc where IOPM OS text will be loaded	*/
	if(lseek(iopmfd, tstart - IOPM_RAM_START, 0) < 0)
	{
		printf("ldiopm: %s text section lseek failed\n",File);
		perror("ldiopm");
		exit(1);
	}

	/* Write text out to IOPM memory				*/
	if((results = write(iopmfd, tbuf, tsize)) != tsize)
	{
		printf("ldiopm: %s text write failed\n",File);
		perror("ldiopm");
		exit(1);
	}

	/* Seek to physical mem loc where IOPM OS data will be loaded	*/
	if(lseek(iopmfd, dstart - IOPM_RAM_START, 0) < 0)
	{
		printf("ldiopm: %s data section lseek failed\n",File);
		perror("ldiopm");
		exit(1);
	}

	/* Write data out to IOPM memory				*/
	if(write(iopmfd, dbuf, dsize) != dsize)
	{
		printf("ldiopm: %s data write failed\n",File);
		perror("ldiopm");
		exit(1);
	}

	/* Start the IOPM						*/
	if(ioctl(iopmfd, UNRESETIOPM, entry) < 0)
	{
		printf("ldiopm: IOPM Reset failed\n");
		perror("ldiopm");
		exit(1);
	}
}

/* load a did file to the IOPM 						*/
ldDID(didFile)
char	*didFile;		/* did file to load			*/
{
	struct iopmioctlw 	iopmioctlw;

	extern int		errno;

	/* Read did file into memory buffers				*/
	if (!readfile(didFile))
		exit(errno);

	iopmioctlw.taddr = tstart;
	iopmioctlw.tlength = tsize;
	iopmioctlw.daddr = dstart;
	iopmioctlw.dlength = dsize + bsize;

	if(ioctl(iopmfd, LOAD_WHERE, &iopmioctlw) < 0)
	{
		printf("ldiopm: LOAD_WHERE ioctl for did %s failed\n",didFile);
		perror("ldiopm");
		exit(1);
	}

	/* seek to physcial mem location where did text will be loaded	*/
	if(lseek(iopmfd, iopmioctlw.taddr - IOPM_RAM_START, 0) < 0)
	{
		printf("ldiopm: did %s text section lseek failed\n",didFile);
		perror("ldiopm");
		exit(1);
	}

	/* Write did text section into IOPM memory			*/
	if(write(iopmfd, tbuf, tsize) != tsize)
	{
		printf("ldiopm: Write of text section for did %s failed\n",
			didFile);
		perror("ldiopm");
		exit(1);
	}


	/* seek to physcial mem location where did data will be loaded	*/
	if(lseek(iopmfd, iopmioctlw.daddr - IOPM_RAM_START, 0) < 0)
	{
		printf("ldiopm: did %s data section lseek failed\n",didFile);
		perror("ldiopm");
		exit(1);
	}

	/* Write did data section into IOPM memory			*/
	if(write(iopmfd, dbuf, dsize) != dsize)
	{
		printf("ldiopm: Write of text section for did %s failed\n",
			didFile);
		perror("ldiopm");
		exit(1);
	}
}

void
parseConfig(cfgString, type)
char  	*cfgString;
uint	type;			/* bufs or streams config stream	*/
{
	char			*savstring = cfgString;
	struct iopmioctld	iopmioctld;
	register int		i;
	char			*numstart;

	/* initialize variables						*/
	iopmioctld.port = 0xffffffff;	/* assume port not entered	*/
	iopmioctld.clonemin = 0xffff;	/* assume clone not entered	*/

	iopmioctld.imin = 0;
	/* get driver name						*/
	if(*cfgString)
		skipcomma(&cfgString,savstring);
	i = 0;
	while(*cfgString && *cfgString != ',')
		iopmioctld.prefix[i++] = *cfgString++;
	iopmioctld.prefix[i] = '\0';	/* null terminate		*/

	/* is there more?						*/

	/* get starting kernel minor number 				*/
	if(*cfgString)
	{
		skipcomma(&cfgString,savstring);
		iopmioctld.kmin = getshort(&cfgString,savstring);
	}
	else
		return;

	/* get number of kernel minors 					*/
	if(*cfgString)
	{
		skipcomma(&cfgString,savstring);
		iopmioctld.numdev = getshort(&cfgString,savstring);
		if(iopmioctld.numdev == 0)
		{
			printf("-s or -b string syntax error: # of minors can't be 0: '%s'\n",savstring);
			exit(1);
		}
	}
	else
	{
		printf("-s or -b string syntax error: # of minors required: '%s%\n",savstring);
		exit(1);
	}

	/* Check for optional parameters				*/
	while(*cfgString)
	{
		skipcomma(&cfgString,savstring);
		switch(*cfgString)
		{
			case 'p':		/* port number		*/
			case 'P':
				cfgString++;	/* move over 'p'	*/

				if(*cfgString)
				{
					char  *numstart = cfgString;
					iopmioctld.port = strtol(cfgString,
					  &cfgString, 10);
					if(cfgString == numstart)
					{
						printf("-s or -b string syntax error: decimal number (%s) expected: '%s'\n",
						  numstart,savstring);
						exit(1);
					}
				}
				else
				{
					printf("-s or -b string syntax error: port number expected: '%s'\n",savstring);
					exit(1);
				}
				if(*cfgString)
				{
					skipcomma(&cfgString,savstring);
					iopmioctld.imin = getshort(&cfgString,
					  savstring);
				}
				break;

			case 'c':		/* clone minor number	*/
			case 'C':
				if(type == STR_DEVSW)
				{
					cfgString++;	/* move over 'c'	*/
					iopmioctld.clonemin =
					  getshort(&cfgString, savstring);
					break;
				}
				else
				{
					printf("-b string syntax error: No clone minor argument for bufs drivers: '%s'\n",savstring);
					exit(1);
				}
			
			default:
				printf("-s or -b string syntax error: '%s'\n",
				  savstring);
				exit(1);
		}
	}

	if(ioctl(iopmfd, type, &iopmioctld) < 0)
	{
		printf("ldiopm: Set devsw params ioctl error\n");
		perror("ldiopm");
		exit(1);
	}
}

skipcomma(cfgStringp,savstring)
char  **cfgStringp;
char  *savstring;
{
	if(**cfgStringp == ',')
		(*cfgStringp)++;
	else
	{
		printf("-s or -b string syntax error: comma expected: '%s'\n",
		  savstring);
		exit(1);
	}
}

getshort(cfgStringp,savstring)
char  **cfgStringp;
char  *savstring;
{
	long  retval;
	char  *numstart = *cfgStringp;

	retval = strtol(*cfgStringp, cfgStringp, 10);
	if(*cfgStringp == numstart)
	{
		printf("-s or -b string syntax error: decimal number (%s) expected: '%s'\n",
		  numstart,savstring);
		exit(1);
	}
	if(retval > 0xffff)
	{
		printf("-s or -b string number out of range: '%s'\n",
		  numstart);
		exit(1);
	}

	return retval;
}

#define FAILURE	0
#define SUCCESS	1

readfile(cfile)
register char	*cfile;			/* file that will be loaded	*/
{
	register int 	i;		/* loop variable		*/
	FILE 		*filePtr;	/* input file ptr		*/

	extern 		errno;		/* system errno			*/

	/* open file to load						*/
	if((filePtr = fopen(cfile, "r")) == NULL)
	{
		printf("ldiopm: Cannot open file %s\n",cfile);
		perror("ldiopm");
		return(FAILURE);
	}

	/* read file header 						*/
	if(fread(&filehdr, FILHSZ, 1, filePtr) != 1)
	{
		printf("ldiopm: Could not read filehdr of file %s\n",cfile);
		perror("ldiopm");
		return(FAILURE);
	}

	/* Read aouthdr information					*/
	if(fread(&aouthdr, filehdr.f_opthdr, 1, filePtr) != 1)
	{
		printf("ldiopm: Could not read aouthdr of file %s\n",cfile);
		perror("ldiopm");
		return(FAILURE);
	}

	/* Read each section header 					*/
	for(i=0; i < filehdr.f_nscns; i++)
	{
		if(fread(&scnhdr[i], SCNHSZ, 1, filePtr) != 1)
		{
			printf("ldiopm: Could not read scnhdr[%d] of file %s\n",
				i, cfile);
			perror("ldiopm");
			return(FAILURE);
		}
	}

	/* Save text, data, bss size, starting address, and entry point  */
	tsize = scnhdr[0].s_size;		/* text size		*/
	dsize = scnhdr[1].s_size;		/* data size		*/
	bsize = scnhdr[2].s_size;		/* bss size		*/
	tstart = scnhdr[0].s_paddr;		/* text addr		*/
	dstart = scnhdr[1].s_paddr;		/* data addr		*/
	entry = aouthdr.entry;			/* module entry point	*/

	/* allocate a buffer for text and data				*/
	if((tbuf = malloc(tsize + dsize)) == NULL)
	{
		printf("ldiopm: ");
		printf("Text and data space malloc failed for file %s\n",cfile);
		perror("ldiopm");
		return(FAILURE);
	}

	/* seek to beginning of text space in file			*/
	if(fseek(filePtr, scnhdr[0].s_scnptr, 0))
	{
		printf("ldiopm: ");
		printf("Text fseek(%x) failed for file %s\n",scnhdr[0].s_scnptr,
			cfile);
		perror("ldiopm");
		return(FAILURE);
	}

	/* Read text data into buffer					*/
	if(fread(tbuf, tsize, 1, filePtr) != 1)
	{
		printf("ldiopm: ");
		printf("Text read of %d bytes failed from file %s\n",tsize,
			cfile);
		perror("ldiopm");
		return(FAILURE);
	}

	/* Read data section into buffer, if there is one		*/
	if(dsize)
	{
		/* seek to beginning of data section			*/
		if(fseek(filePtr, scnhdr[1].s_scnptr, 0))
		{
			printf("ldiopm: ");
			printf("Data section fseek(%x) failed for file %s\n",
				scnhdr[1].s_scnptr, cfile);
			perror("ldiopm");
			return(FAILURE);
		}

		/* set up dbuf and read in data section			*/
		dbuf = &tbuf[tsize];
		if(fread(dbuf, dsize, 1, filePtr) != 1)
		{
			printf("ldiopm: ");
			printf("Data read of %d bytes failed from file %s\n",
				dsize, cfile);
			perror("ldiopm");
			return(FAILURE);
		}
	}
	return(SUCCESS);	/* return success			*/
}


void
displayHelp(argument)
char	argument;		/* invalid argument			*/
{
	printf("ldiopm: Invalid Option (%c).  Valid options are:\n",argument);
	printf("\td<IOPM device name>\n");
	printf("\tf<name of did file>\n");
	printf("\tF<name of IOPM OS file>\n");
	printf("\ts(streams)<driver name>[,<starting kernel minor>,<# kernel minors>[,P<port #,starting IOPM minor #>[,C<clone minor>]]]\n");
	printf("\tb(uffs)<driver name>[,<starting kernel minor>,<# kernel minors>[,P<port #,starting IOPM minor #>[,C<clone minor>]]]\n");
}
