/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) configiopm.c: version 25.1 created on 12/2/91 at 15:49:14	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)configiopm.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include <stdio.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stream.h>
#include "sys/iopmioctl.h"

#define	TRUE	1	
#define	FALSE	0	

int nblk[NCLASS] = {0};

main(argc, argv)
int	argc;
char 	**argv;
{
	register int	error;		/* error flag			*/
	int 		iopmFD;		/* IOPM device fd		*/
	char 		argument;	/* cmd line argument		*/
	int 		devEntered;	/* device name entered flag	*/
	int 		blksEntered;	/* data blocks entered?		*/
	uint 		numQueues;	/* # queues to configure	*/
	uint 		bp;		/* # bufs headers w/o buffers	*/
	uint 		buf;		/* # bufs headers w/ buffers	*/
	uint 		class;		/* data block class		*/
	char		devname[40];	/* IOPM device name		*/
	uint		numtcb;		/* number of tasks		*/

	extern char  	*optarg;
	extern int   	optind;
	extern int   	opterr;
	extern int	errno;		/* system error number		*/
	extern void	displayHelp();

	/* Intialize variables						*/
	opterr = 0;		/* disable getopt error messages	*/
	*devname = '\0';	/* Set devname to NULL			*/
	devEntered = FALSE;	/* No device name entered yet		*/
	blksEntered = FALSE;	/* No data block classes entered yet	*/
	numQueues = 0;		/* No queues configured yet		*/
	error = FALSE;		/* No error yet				*/
	bp = 0;			/* bufs header w/o buffers not entered	*/
	buf = 0;		/* bufs header w/ buffers not entered	*/
	numtcb = 0;		/* no additional task control blocks	*/

	while(((argument=getopt(argc, argv, "d:q:c:b:B:t:")) != EOF) && !error)
	{
		switch(argument)
		{
		    case 'd':		/* IOPM device name		*/
			if(devEntered)
			{
				printf("configiopm: ");
				printf("Only 1 -d option per configiopm cmd\n");
				error = TRUE;
			}
			else
			{
				devEntered = TRUE;
				sprintf(devname,"%s",optarg);
			}
			break;

		    case 'q':		/* # queues to configure	*/
			numQueues = strtol(optarg, (char **)NULL, 10);
			break;

		    case 'c':		/* class and # of streams bufs	*/
			class = strtol(optarg, &optarg, 10);
			if(class >= NCLASS)
			{
				printf("configiopm: ");
				printf("Invalid data blk class (%d) entered\n");
				printf("configiopm: Valid classes are 0 to %d\n"
					,(NCLASS - 1));
				error = TRUE;
			}
			else
			{
				optarg++; /* skip to # of blocks	*/
				nblk[class] = strtol(optarg, &optarg, 10);
				blksEntered = TRUE;
			}
			break;

		    case 'b':		/* bufs headers w/o buffers	*/
			bp = strtol(optarg, &optarg, 10);
			break;

		    case 'B':		/* bufs header w/ buffers	*/
			buf = strtol(optarg, &optarg, 10);
			break;

		    case 't':		/* task control blocks		*/
			numtcb = strtol(optarg, &optarg, 10);
			break;

		    case '?':
			displayHelp(argument);
			error = TRUE;
			break;
		}
	}

	/* Make sure a IOPM device name was entered			*/
	if(!devEntered)
	{
		printf("configiopm: ");
		printf("IOPM device name must be entered (-d option)\n");
		error = TRUE;
	}

	/* If we found a command error give up now			*/
	if(error)
		exit(1);

	if((iopmFD = open(devname, O_RDWR)) < 0)
	{
		printf("configiopm: Open of %s failed\n",devname);
		perror("configiopm");
		exit(1);
	}

	if(numQueues && ioctl(iopmFD, SET_QUEUES, numQueues))
	{
		printf("configiopm: SET_QUEUES failed\n");
		perror("configiopm");
		exit(1);
	}

	if(blksEntered && ioctl(iopmFD, SET_NMSG, nblk))
	{
		printf("configiopm: SET_NMSG failed\n");
		perror("configiopm");
		exit(1);
	}

	if(bp && ioctl(iopmFD, SET_BP, bp))
	{
		printf("configiopm: SET_BP failed\n");
		perror("configiopm");
		exit(1);
	}

	if(buf && ioctl(iopmFD, SET_BUF, buf))
	{
		printf("configiopm: SET_BUF failed\n");
		perror("configiopm");
		exit(1);
	}

	if(numtcb && ioctl(iopmFD, SET_NUMTCB, numtcb))
	{
		printf("configiopm: SET_NUMTCB failed\n");
		perror("configiopm");
		exit(1);
	}
}

void
displayHelp(argument)
char	argument;		/* invalid argument			*/
{
	printf("configiopm: Invalid Option (%c).  Valid options are:\n",
		argument);
	printf("\td<IOPM device name>\n");
	printf("\tq<# queues>\n");
	printf("\tc<data blk class>,<# data blks>: one for each blk class\n");
	printf("\tb<# buffer headers>\n");
	printf("\tB<size (in K) of buffer pool>\n");
}
