#	START NEW ARIX SCCS HEADER
#
#	@(#) umountall.sh: version 25.1 created on 12/2/91 at 15:49:04
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	ident	"@(#)umountall.sh	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
#
#	END NEW ARIX SCCS HEADER
#


#	Unmounts all but the root, "/", file system.
#	Note: written to depend on as few commands as possible.

#!	chmod +x ${file}

kill=
if [ $# -ge 1 ]
then
	case "$1" in
	-k )
		if [ ! -x /etc/fuser ]
		then
			echo >&2 "$0:  -k option not available.  No /etc/fuser found."
			exit 1
		fi
		kill=yes
		;;
	* )
		echo >&2 "Usage:  $0 [ -k ]
-k	kill processes with files open in each file system before unmounting."
		exit 1
	esac
fi

/etc/mount  |
	sort -r  |
	while read fs dummy1 dev mode mode2 dummy2
	do
		case "${mode}" in
		'read/write/remote')
			mode=-d		# remote resource
			;;
		'read')
			case "${mode2}" in
			'only/remote')
				mode=-d
				;;
			esac
			;;
		esac

		case "${fs}" in
		/  |  '' )
			continue
			;;
		* )
			if [ "${mode}" = "-d" ]
			then
				/etc/umount -d ${dev}
			else
				if [ ${kill} ]
				then
					/etc/fuser -k ${dev}
					sleep 10
				fi
				/etc/umount ${fs}
			fi
		esac
	done 

