#	START NEW ARIX SCCS HEADER
#
#	@(#) shutdown.sh: version 25.1 created on 12/2/91 at 15:48:57
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	ident	"@(#)shutdown.sh	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
#
#	END NEW ARIX SCCS HEADER
#

#	Sequence performed to change the init stat of a machine.

#	This procedure checks to see if you are permitted and allows an
#	interactive shutdown.  The actual change of state, killing of
#	processes and such are performed by the new init state, say 0,
#	and its /etc/rc0.

#	Usage:  shutdown [ -y ] [ -g<grace-period> ] [ -i<init-state> ]

#!	chmod +x ${file}

tty=`tty`
if [ "$tty" != "not a tty" ]
then
	console=`basename $tty`
fi

if [ $console ]
then
	if [ $console != console ]
	then
		echo "$0:   You must be on the console to run /etc/shutdown."
		exit 1
	fi
fi

if [ `pwd` != / ]
then
	echo "$0:  You must be in the / directory to run /etc/shutdown."
	exit 1
fi

#	Check the user id.
if [ -x /usr/bin/id ]
then
	eval `id  |  sed 's/[^a-z0-9=].*//'`
	if [ "${uid:=0}" -ne 0 ]
	then
	        echo "$0:  Only root can run /etc/shutdown."
		exit 2
	fi
fi


grace=60		# default grace = 60
askconfirmation=yes
initstate=1
while [ $# -gt 0 ]
do
	case $1 in
	-g[0-9]* )
		grace=`expr "$1" : '-g\(.*\)'`
		;;
	-i[sS1] ) 	# do an init "1" (leaves you in init S)
		initstate=1
		;;
	-i[056] )	# jc0
		initstate=`expr "$1" : '-i\(.*\)'`	# jc0
		;;
	-i[234] )
		initstate=`expr "$1" : '-i\(.*\)'`	# jc0
		echo "$0:  Initstate $i is not for system shutdown"	# jc0
		exit 1
		;;
	-y )
		askconfirmation=
		;;
	-* )
		echo "Illegal flag argument '$1'"
		exit 1
		;;
	* )
		echo "Usage:  $0 [ -y ] [ -g<grace> ] [ -i<initstate> ]"
		exit 1
	esac
	shift
done

if [ -n "${askconfirmation}" -a -x /etc/ckbupscd ]
	then
	#	Check to see if backups are scheduled at this time
	BUPS=`/etc/ckbupscd`
	if [ "$BUPS" != "" ]
		then
		echo "$BUPS"
		echo "Do you wish to abort this shutdown and return to 
command level to do these backups? [y, n] \c"
		read YORN
		if [ "$YORN" = "y" -o "$YORN" = "Y" ]
			then 
			exit 1
		fi
	fi
fi

if [ -z "${TZ}"  -a  -r /etc/TIMEZONE ]
then
	. /etc/TIMEZONE
fi

echo '
Shutdown started.    \c'
date
echo

sync
cd /

trap ""  1
trap "exit 1"  2 15

a="`who  |  wc -l`"
if [ ${a} -gt 1  -a  ${grace} -gt 0 ]
then
	su adm -c /etc/wall<<-!
		The system will be shut down in ${grace} seconds.
		Please log off now.

	!
	sleep ${grace}
fi

/etc/wall <<-!
	THE SYSTEM IS BEING SHUT DOWN NOW ! ! !
	Log off now or risk your files being damaged.

!
sleep ${grace}

if [ ${askconfirmation} ]
then
	echo "Do you want to continue? (y or n):   \c"
	read b
else
	b=y
fi
if [ "$b" != "y" ]
then
	/etc/wall <<-\!
		False Alarm:  The system will not be brought down.
	!
	echo 'Shut down aborted.'
	exit 1
fi

echo "The system is comming down ...Please wait"

# the following is from the 5.2 port - jc0
/usr/lib/acct/shutacct
echo "Process accounting stopped."

/etc/init ${initstate} 

# This is so init can have a running start. 
sleep 20
