#	START NEW ARIX SCCS HEADER
#
#	@(#) rc2.sh: version 25.1 created on 12/2/91 at 15:48:42
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	ident	"@(#)rc2.sh	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
#
#	END NEW ARIX SCCS HEADER
#


#	"Run Commands" executed when the system is changing to init state 2,
#	traditionally called "multi-user".

#	Pickup start-up packages for mounts, daemons, services, etc.
set `who -r`
if [ $9 = "S" ]
then
	echo 'The system is coming up.  Please wait.'
	BOOT=yes

elif [ $7 = "2" ]
then
	echo 'Changing to state 2.'
	if [ -d /etc/rc2.d ]
	then
		for f in /etc/rc2.d/K*
		{
			if [ -s ${f} ]
			then
				/bin/sh ${f} stop
			fi
		}
	fi
fi

if [ -d /etc/rc2.d ]
then
	for f in /etc/rc2.d/S*
	{
		if [ -s ${f} ]
		then
			/bin/sh ${f} start
		fi
	}
fi
if [ "${BOOT}" = "yes" ]
then
	/bin/stty sane tab3 2>/dev/null
fi

if [ "${BOOT}" = "yes" -a -d /etc/rc.d ]
then
	for f in `/bin/ls /etc/rc.d`
	{
		if [ ! -s /etc/init.d/${f} ]
		then
			/bin/sh /etc/rc.d/${f} 
		fi
	}
fi

if [ "${BOOT}" = "yes" -a $7 = "2" ]
then
	echo 'The system is ready.'
elif [ $7 = "2" ]
then
	echo 'Change to state 2 has been completed.'
fi

