#	START NEW ARIX SCCS HEADER
#
#	@(#) rc0.sh: version 25.1 created on 12/2/91 at 15:48:35
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	ident	"@(#)rc0.sh	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
#
#	END NEW ARIX SCCS HEADER
#

#	"Run Commands" for init state 0
#	Leaves the system in a state where it is safe to turn off the power
#	or go to firmware.

echo 'The system is coming down.  Please wait.'

#	The following segment is for historical purposes.
#	There should be nothing in /etc/shutdown.d.
if [ -d /etc/shutdown.d ]
then
	for f in /etc/shutdown.d/*
	{
		if [ -s $f ]
		then
			/bin/sh ${f}
		fi
	}
fi
#	End of historical section

if [ -d /etc/rc0.d ]
then
	/bin/ls -r /etc/rc0.d/K* | while read f
	do
	{
		if [ -s ${f} ]
		then
			/bin/sh ${f} stop
		fi
	}
	done

#	system cleanup functions ONLY (things that end fast!)	

	for f in /etc/rc0.d/S*
	{
		if [ -s ${f} ]
		then
			/bin/sh ${f} start
		fi
	}
fi

sleep 10
sync

echo "killing all remaining user processes"
killall

echo "unmounting all file systems"
/etc/mount | /bin/sort -r |    sed -n -e '/^\/ /d' -e 's/^.* on\(.*\) read.*/umount \1/p'|/bin/sh -

sync; sleep 2
echo "SHUTDOWN FINISHED"

set `who -r`
case $7 in 
	
	0) echo "Powering the system off..."
	   uadmin 2 0   
	   ;;
	1) init S    # We never stay in init 1...go to init s
	   ;;
	5) echo "Powering down to PROM LEVEL...."
	   uadmin 2 2 103
	   ;;
	6) echo "Rebooting the System....."
	   uadmin 2 1 
	   ;;
esac

