#	START NEW ARIX SCCS HEADER
#
#	@(#) mountall.sh: version 25.1 created on 12/2/91 at 15:48:21
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	ident	"@(#)mountall.sh	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
#
#	END NEW ARIX SCCS HEADER
#

#	Mount file systems according to file system table /etc/fstab.
#	Note: written to depend on as few commands as possible.

#	file-system-table format:
#
#	column 1	block special file name of file system
#	column 2	mount-point directory
#	column 3	"-r" if to be mounted read-only
#			"-d" if distributed (remote) resource
#	column 4	file system type (may be column 4)
#	column 5+	ignored
#	White-space separates columns.
#	Lines beginning with "#" are comments.  Empty lines are ignored.
#	a '-' in any field is a no-op.

mnt_rd()
{
	while  read dev fs fsflags fstype dummy
	do
		switch=`echo $dev | sed -e 's/^\#.*/\#/'`
		case ${switch} in
		\# | '')	#  Ignore comments, empty lines
			continue
		esac
		case ${dev} in
		'-')		#  Ignore no-action lines
			continue
		esac 
		case ${fsflags} in
		'-r') 		# This is the only valid flag in mountall
			;;
		'-d' | '-dr' | '-rd') #  remote mounts are done in rmountall
			continue
			;;

		'-')		# Ignore '-'
			fsflags=''
			;;

		*)		# It isn't an option, must be fstype
			fstype=${fsflags}
			fsflags=''
			;;
		esac 
 		if [ "${fstype}" = "-" ]
 		then
 			fstype=''
 		fi
		if [ "${fstype}" != "" ]
		then 
 			case ${fstype} in
 			'S51K' | 'PROC'| 'S54K')# local file systems
 				;;
 			*)			# other file system types
 				continue;
 				;;
 			esac
 			fstype="-f ${fstype}"
		fi

		#	First check file system state and repair if necessary.

		if [ "${dev}" = "-" ]
		then
			
			/etc/mount ${fsflags} ${fstype} ${dev} ${fs}
			continue
		fi

		msg=`/etc/fsstat ${dev} 2>&1`
		case $? in
		0)
			/etc/mount ${fsflags} ${fstype} ${dev} ${fs}
			;;
		1)
			rdev=`basename ${dev}`
			if [ -c /dev/rdsk/${rdev} ]
			then
				rdev=/dev/rdsk/${rdev}
			elif [ -c /dev/r${rdev} ]
			then
				rdev=/dev/r${rdev}
			else
				rdev=${dev}
			fi
			echo "${msg}
	 ${rdev} is being checked."
			/etc/fsck -y -t /tmp/mnt$$ -D ${rdev}

			/etc/mount ${fsflags} ${fstype} ${dev} ${fs}
			;;
		2)
			echo "${dev} already mounted"
			;;
		3)
			/etc/mount ${fsflags} ${fstype} ${dev} ${fs}
			if [ $? != 0 ]
			then
				echo "${dev} is not a valid filesystem"
			fi
			;;
		esac
	done
}


if test $# -ge 0 && test $# -lt 2
then
	case $#
	in
		0)
			fstab=/etc/fstab
		;;
		1)
			if test ${1} = '-'
			then
				mnt_rd
				exit
			fi

			fstab=${1}
			if test ! -r ${fstab}
			then
				echo mountall : File is un-readable
				exit
			fi
		;;
		*)
			echo mountall : Too many arguments
			exit
		;;
	esac
	cat ${fstab} | mnt_rd
else
	echo mountall : Too many arguments
	exit
fi

