#	START NEW ARIX SCCS HEADER
#
#	@(#) initpkg.mk: version 25.1 created on 12/2/91 at 15:48:14
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	@(#)initpkg.mk	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation
#
#	END NEW ARIX SCCS HEADER
#
#	Copyright (c) 1984 AT&T
#	  All Rights Reserved

#	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T
#	The copyright notice above does not evidence any
#	actual or intended publication of such source code.
#	ATT: ident	"initpkg:./initpkg.mk	1.10"

#ident	"@(#)initpkg:initpkg.mk	25.1"

include	$(IROOT)/macdefs

INSDIR = $(ROOT)/etc
INSDIR2 = $(ROOT)/usr/etc
TOUCH=/bin/touch

SCRIPTS= bcheckrc brc inittab fstab rstab mountall powerfail rc0 rc2 rc3 \
	singlepwr shutdown umountall mrinit

DIRECTORIES= init.d rc0.d rc2.d rc3.d brc.d

all:
	cp bcheckrc.sh bcheckrc 
	cp brc.sh brc
	cp inittab.sh inittab
	cp fstab.sh fstab
	cp rstab.sh rstab
	cp mountall.sh mountall
	cp powerfail.sh  powerfail
	cp rc0.sh rc0
	cp rc2.sh  rc2
	cp rc3.sh  rc3
	cp singlepwr.sh singlepower
	cp shutdown.sh shutdown
	cp umountall.sh umountall
	cp mrinit.sh mrinit

mrinit: mrinit.sh
	cp mrinit.sh mrinit; \
	$(INS) mrinit $(INSDIR)/mrinit; \
	chmod 744 $(INSDIR)/mrinit; \
	chgrp sys $(INSDIR)/mrinit; \
	$(TOUCH) $(OLDDATE) $(INSDIR)/mrinit; \
	chown root $(INSDIR)/mrinit

install:	scripts directories
	echo "**** initpkg.mk complete ****"

scripts: $(SCRIPTS)

directories:
	@for i in  $(DIRECTORIES) ; \
	do \
	if [ -d $$i ] ;\
	then \
	echo "(cd $$i; $(MAKE) -$(MAKEFLAGS)f $$i.mk install clobber)";\
	(cd $$i; pwd; $(MAKE) -$(MAKEFLAGS)f $$i.mk install clobber ); \
	fi ;\
	done

clean:	clobber

clobber:
	rm -f $(SCRIPTS) singlepower

# Also create empty bcheckrc in usr/etc so boot from /usr won't complain
bcheckrc::
	cp bcheckrc.sh bcheckrc
	$(INS) bcheckrc $(INSDIR)/bcheckrc
	chmod 744 $(INSDIR)/bcheckrc
	chgrp sys $(INSDIR)/bcheckrc
	$(TOUCH) 0101000070 $(INSDIR)/bcheckrc
	chown root $(INSDIR)/bcheckrc

	$(TOUCH) 0101000070 $(INSDIR2)/bcheckrc
	chmod 744 $(INSDIR2)/bcheckrc
	chgrp sys $(INSDIR2)/bcheckrc
	chown root $(INSDIR2)/bcheckrc

brc::
	cp brc.sh brc
	$(INS) brc $(INSDIR)/brc
	chmod 744 $(INSDIR)/brc
	chgrp sys $(INSDIR)/brc
	$(TOUCH) 0101000070 $(INSDIR)/brc
	chown root $(INSDIR)/brc

fstab::
	cp fstab.sh fstab
	$(INS) fstab $(INSDIR)/fstab
	chmod 664 $(INSDIR)/fstab
	chgrp sys $(INSDIR)/fstab
	$(TOUCH) 0101000070 $(INSDIR)/fstab
	chown root $(INSDIR)/fstab

rstab::
	cp rstab.sh  rstab
	$(INS) rstab $(INSDIR)/rstab
	chmod 664 $(INSDIR)/rstab
	chgrp sys $(INSDIR)/rstab
	$(TOUCH) 0101000070 $(INSDIR)/rstab
	chown root $(INSDIR)/rstab

inittab::
	cp inittab.sh inittab
	$(INS) inittab $(INSDIR)/inittab
	chmod 644 $(INSDIR)/inittab
	chgrp sys $(INSDIR)/inittab
	$(TOUCH) 0101000070 $(INSDIR)/inittab
	chown root $(INSDIR)/inittab

powerfail::
	cp powerfail.sh powerfail
	$(INS) powerfail $(INSDIR)/powerfail
	chmod 744 $(INSDIR)/powerfail
	chgrp sys $(INSDIR)/powerfail
	$(TOUCH) 0101000070 $(INSDIR)/powerfail
	chown root $(INSDIR)/powerfail

singlepwr::
	cp singlepwr.sh singlepower
	$(INS) singlepower $(INSDIR)/singlepower
	chmod 744 $(INSDIR)/singlepower
	chgrp sys $(INSDIR)/singlepower
	$(TOUCH) 0101000070 $(INSDIR)/singlepower
	chown root $(INSDIR)/singlepower

mountall::
	cp mountall.sh mountall
	$(INS) mountall $(INSDIR)/mountall
	chmod 744 $(INSDIR)/mountall
	chgrp sys $(INSDIR)/mountall
	$(TOUCH) 0101000070 $(INSDIR)/mountall
	chown root $(INSDIR)/mountall

rc0::
	cp rc0.sh rc0
	$(INS) rc0 $(INSDIR)/rc0
	chmod 744 $(INSDIR)/rc0
	chgrp sys $(INSDIR)/rc0
	$(TOUCH) 0101000070 $(INSDIR)/rc0
	chown root $(INSDIR)/rc0

rc2::
	cp rc2.sh rc2
	$(INS) rc2 $(INSDIR)/rc2
	chmod 744 $(INSDIR)/rc2
	chgrp sys $(INSDIR)/rc2
	$(TOUCH) 0101000070 $(INSDIR)/rc2
	chown root $(INSDIR)/rc2

rc3::
	cp rc3.sh rc3
	$(INS) rc3 $(INSDIR)/rc3
	chmod 744 $(INSDIR)/rc3
	chgrp sys $(INSDIR)/rc3
	$(TOUCH) 0101000070 $(INSDIR)/rc3
	chown root $(INSDIR)/rc3

shutdown::
	cp shutdown.sh shutdown
	$(INS) shutdown $(INSDIR)/shutdown
	chmod 744 $(INSDIR)/shutdown
	chgrp sys $(INSDIR)/shutdown
	$(TOUCH) 0101000070 $(INSDIR)/shutdown
	chown root $(INSDIR)/shutdown

umountall::
	cp umountall.sh umountall
	$(INS) umountall $(INSDIR)/umountall
	chmod 744 $(INSDIR)/umountall
	chgrp sys $(INSDIR)/umountall
	$(TOUCH) 0101000070 $(INSDIR)/umountall
	chown root $(INSDIR)/umountall

