#	START NEW ARIX SCCS HEADER
#
#	@(#) help.mk: version 25.1 created on 12/2/91 at 15:44:54
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	@(#)help.mk	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation
#
#	END NEW ARIX SCCS HEADER
#
#	Copyright (c) 1984 AT&T
#	  All Rights Reserved

#	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T
#	The copyright notice above does not evidence any
#	actual or intended publication of such source code.
#	ATT: ident	"help:help.mk	1.13"
#       help makefile

#ident	"@(#)help:help.mk	25.1"

include	$(IROOT)/macdefs

BIN	= $(ROOT)/usr/bin
ADM	= $(ROOT)/etc
LIB	= $(ROOT)/usr/lib/help
DB	= $(LIB)/db
TMP	= ./tmp
nfs:	fetch
	mkdir -p $(TMP)/descriptions
	cp db/descriptions/* $(TMP)/descriptions
	-./replace descriptions.a $(TMP)/descriptions/*

all:		help interact keysrch fetch helpadm admstart admgloss \
		editcmd defnlen checklen locking glossary xdb
 
interact:	interact.c switch.h
	$(CC) $(CFLAGS) -o interact interact.c $(LDFLAGS) -lcurses

fetch:		fetch.c fetch.h
#	cc -I$(LOCALINCS) -o replace fetch.c -lld
	cc  -o replace fetch.c -lld
	$(CC) $(CFLAGS) -o fetch fetch.c $(LDFLAGS) -lld

# dux#1: modification for new (12/8) integration scheme.
# xdb will generate the libraries without installing them.
# Also, instead of using the fetch installed in lib, use the local fetch
xdb:	fetch
	mkdir $(TMP)
	mkdir $(TMP)/descriptions
	cp db/descriptions/* $(TMP)/descriptions
	mkdir $(TMP)/options
	cp db/options/* $(TMP)/options
	mkdir $(TMP)/examples
	cp db/examples/* $(TMP)/examples
	mkdir $(TMP)/glossary
	cp db/glossary/* $(TMP)/glossary
	mkdir $(TMP)/screens
	cp db/screens/* $(TMP)/screens
	mkdir $(TMP)/screensfoot
	cp db/screensfoot/* $(TMP)/screensfoot
	-./replace descriptions.a $(TMP)/descriptions/*
	-./replace examples.a $(TMP)/examples/*
	-./replace options.a $(TMP)/options/*
	-./replace glossary.a $(TMP)/glossary/*
	-./replace screens.a $(TMP)/screens/*
	-./replace screens.a $(TMP)/screensfoot/*
	-rm -fr $(TMP)



db:	$(TMP) install_fetch
	mkdir $(TMP)/descriptions
	cp db/descriptions/* $(TMP)/descriptions
	-chmod 644 $(TMP)/descriptions/*
	-chgrp bin $(TMP)/descriptions/*
	-chown root $(TMP)/descriptions/*

	mkdir $(TMP)/options
	cp db/options/* $(TMP)/options
	-chmod 644 $(TMP)/options/*
	-chgrp bin $(TMP)/options/*
	-chown root $(TMP)/options/*

	mkdir $(TMP)/examples
	cp db/examples/* $(TMP)/examples
	-chmod 644 $(TMP)/examples/*
	-chgrp bin $(TMP)/examples/*
	-chown root $(TMP)/examples/*

	mkdir $(TMP)/glossary
	cp db/glossary/* $(TMP)/glossary
	-chmod 644 $(TMP)/glossary/*
	-chgrp bin $(TMP)/glossary/*
	-chown root $(TMP)/glossary/*

	mkdir $(TMP)/screens
	cp db/screens/* $(TMP)/screens
	-chmod 644 $(TMP)/screens/*
	-chgrp bin $(TMP)/screens/*
	-chown root $(TMP)/screens/*

	mkdir $(TMP)/screensfoot
	cp db/screensfoot/* $(TMP)/screensfoot
	-chmod 644 $(TMP)/screensfoot/*
	-chgrp bin $(TMP)/screensfoot/*
	-chown root $(TMP)/screensfoot/*

	-./replace $(TMP)/descriptions.a $(TMP)/descriptions/*
	-./replace $(TMP)/examples.a $(TMP)/examples/*
	-./replace $(TMP)/options.a $(TMP)/options/*
	-./replace $(TMP)/glossary.a $(TMP)/glossary/*
	-./replace $(TMP)/screens.a $(TMP)/screens/*
	-./replace $(TMP)/screens.a $(TMP)/screensfoot/*

	-rm -fr $(TMP)/descriptions $(TMP)/examples $(TMP)/options $(TMP)/glossary \
	$(TMP)/screens $(TMP)/screensfoot

install:	install_interact install_fetch install_help install_keysrch \
		install_helpadm install_db log install_glossary

install_fetch:	fetch lib
	@rm -f $(LIB)/fetch $(LIB)/list $(LIB)/extract $(LIB)/delete $(LIB)/replace
	$(INS) fetch $(LIB)/fetch
	chmod 755 $(LIB)/fetch
	chgrp bin $(LIB)/fetch
	chown bin $(LIB)/fetch
	ln $(LIB)/fetch $(LIB)/extract
	ln $(LIB)/fetch $(LIB)/list
	ln $(LIB)/fetch $(LIB)/delete
	ln $(LIB)/fetch $(LIB)/replace

install_interact:	interact lib
	@rm -f $(LIB)/interact
	$(INS) interact $(LIB)/interact
	chmod 755 $(LIB)/interact
	chgrp bin $(LIB)/interact
	chown bin $(LIB)/interact

install_help:	help
	@rm -f $(BIN)/help $(BIN)/glossary $(BIN)/locate $(BIN)/starter $(BIN)/usage
	$(INS) help $(BIN)/help
	chmod 755 $(BIN)/help
	chgrp bin $(BIN)/help
	chown bin $(BIN)/help
	ln $(BIN)/help $(BIN)/glossary
	ln $(BIN)/help $(BIN)/locate
	ln $(BIN)/help $(BIN)/starter
	ln $(BIN)/help $(BIN)/usage

install_keysrch:	keysrch lib
	@rm -f $(LIB)/keysrch
	$(INS) keysrch $(LIB)/keysrch
	chmod 755 $(LIB)/keysrch
	chgrp bin $(LIB)/keysrch
	chown bin $(LIB)/keysrch

install_glossary:	glossary lib
	@rm -f $(LIB)/glossary
	$(INS) glossary $(LIB)/glossary
	chmod 755 $(LIB)/glossary
	chgrp bin $(LIB)/glossary
	chown bin $(LIB)/glossary

install_helpadm:	helpadm admgloss admstart checklen defnlen editcmd locking lib
	@rm -f $(ADM)/helpadm $(LIB)/admstart $(LIB)/admgloss \
		$(LIB)/editcmd $(LIB)/defnlen $(LIB)/checklen $(LIB)/locking
	$(INS) helpadm $(ADM)/helpadm
	chmod 750 $(ADM)/helpadm
	chgrp bin $(ADM)/helpadm
	chown bin $(ADM)/helpadm
	$(INS) admstart $(LIB)/admstart
	chmod 750 $(LIB)/admstart
	chgrp bin $(LIB)/admstart
	chown bin $(LIB)/admstart
	$(INS) admgloss $(LIB)/admgloss
	chmod 750 $(LIB)/admgloss 
	chgrp bin $(LIB)/admgloss
	chown bin $(LIB)/admgloss
	$(INS) editcmd $(LIB)/editcmd
	chmod 750 $(LIB)/editcmd
	chgrp bin $(LIB)/editcmd
	chown bin $(LIB)/editcmd
	$(INS) defnlen $(LIB)/defnlen
	chmod 750 $(LIB)/defnlen
	chgrp bin $(LIB)/defnlen
	chown bin $(LIB)/defnlen
	$(INS) checklen $(LIB)/checklen
	chmod 750 $(LIB)/checklen
	chgrp bin $(LIB)/checklen
	chown bin $(LIB)/checklen
	$(INS) locking $(LIB)/locking
	chmod 750 $(LIB)/locking
	chgrp bin $(LIB)/locking
	chown bin $(LIB)/locking

install_db:	db lib daba tables
	@rm -f $(DB)/tables/display $(DB)/tables/keywords $(DB)/tables/responses \
	$(DB)/descriptions.a $(DB)/examples.a \
	$(DB)/options.a $(DB)/glossary.a $(DB)/screens.a
	$(INS) db/tables/display $(DB)/tables/display
	$(INS) db/tables/keywords $(DB)/tables/keywords
	$(INS) db/tables/responses $(DB)/tables/responses
	$(INS) $(TMP)/descriptions.a $(DB)/descriptions.a
	$(INS) $(TMP)/examples.a $(DB)/examples.a
	$(INS) $(TMP)/options.a $(DB)/options.a
	$(INS) $(TMP)/glossary.a $(DB)/glossary.a
	$(INS) $(TMP)/screens.a $(DB)/screens.a

	chmod 664 $(DB)/tables/display
	chgrp bin $(DB)/tables/display
	chown root $(DB)/tables/display

	chmod 664 $(DB)/tables/keywords
	chgrp bin $(DB)/tables/keywords
	chown root $(DB)/tables/keywords

	chmod 664 $(DB)/tables/responses
	chgrp bin $(DB)/tables/responses
	chown root $(DB)/tables/responses

	chmod 664 $(DB)/descriptions.a
	chgrp bin $(DB)/descriptions.a
	chown root $(DB)/descriptions.a

	chmod 664 $(DB)/examples.a
	chgrp bin $(DB)/examples.a
	chown root $(DB)/examples.a

	chmod 664 $(DB)/options.a
	chgrp bin $(DB)/options.a
	chown root $(DB)/options.a

	chmod 664 $(DB)/glossary.a
	chgrp bin $(DB)/glossary.a
	chown root $(DB)/glossary.a

	chmod 664 $(DB)/screens.a
	chgrp bin $(DB)/screens.a
	chown root $(DB)/screens.a

log:
	> $(LIB)/HELPLOG
	chmod 555 $(LIB)/HELPLOG
	chgrp bin $(LIB)/HELPLOG
	chown bin $(LIB)/HELPLOG
	$(INS) helpclean $(LIB)/helpclean
	chgrp bin $(LIB)/helpclean
	chown bin $(LIB)/helpclean
lib:
	if [ ! -d $(LIB) ];\
	then mkdir $(LIB)  ;\
	fi;
	chmod 755 $(LIB)
	chgrp bin $(LIB)
	chown bin $(LIB)

daba:
	if [ ! -d $(DB) ];\
	then mkdir $(DB)	;\
	fi;
	chmod 775 $(DB)
	chgrp bin $(DB)
	chown root $(DB)

tables:
	if [ ! -d $(DB)/tables ];\
	then mkdir $(DB)/tables	;\
	fi;
	chmod 775 $(DB)/tables
	chgrp bin $(DB)/tables
	chown root $(DB)/tables

$(TMP):
	if [ ! -d $(TMP) ]	;\
	then mkdir ./tmp	;\
	fi ;
	chmod 775 $(TMP)
	chgrp bin $(TMP)
	chown root $(TMP)

clean:	
	-rm -rf *.o
	-rm -f ./replace

clobber: clean
	rm -f help display fetch interact keysrch helpadm glossary \
		admgloss admstart checklen defnlen editcmd locking
	rm -rf descriptions.a examples.a options.a glossary.a screens.a screens.a
	rm -rf $(TMP)

.PRECIOUS:	help.sh keysrch.sh interact.c fetch.c helpadm.sh glossary.sh
