/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) groups.c: version 25.1 created on 12/2/91 at 15:21:43	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)groups.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/*	Copyright (c) 1989 ARIX	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF ARIX	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/
/*	ATT: #ident	"groups:groups.c	1.1"			*/

#ident	"@(#)groups:groups.c	25.1"

/* Original port, mer */
#include <limits.h>
#include <grp.h>
#include <pwd.h>
#include <stdio.h>
#include <errno.h>

struct	group	*getgrent (), *getgrgid ();
struct  passwd	*getpwnam ();

main(argc, argv)
int argc;
char *argv[];
{
gid_t	groups[NGROUPS_MAX];
int ngroups, i;
struct group *gr;

	if (argc > 1)

		showgroups(argv[1]);

	if ((ngroups = getgroups(NGROUPS_MAX, groups)) < 0 ) {
		if ( errno == EACCES ) {
			fprintf( stderr, 
			"SVID: supplementary groups not available\n" );
			exit(1);
		}
		else {
			fprintf( stderr, " can't read groups\n");
			exit(1);
		}
	}
	for (i = 0; i < ngroups; i++) {
		if ( groups[i] == (gid_t)-1 )
			break;
		setgrent ();
		gr = getgrgid(groups[i]);
		if (gr == NULL)
			printf("%d " , (unsigned int)groups[i]);
		else
			printf("%s ", gr->gr_name);
	}
	printf("\n");
	exit(0);
}

showgroups(user)
	register char *user;
{
	register struct group *gr;
	register struct passwd *pw;
	register char **cp;

	if ((pw = getpwnam(user)) == NULL) {

		fprintf(stderr, "No such user\n");
		exit(1);
	}

	while (gr = getgrent()) {

		if (pw->pw_gid == gr->gr_gid) {

			printf("%s ", gr->gr_name);
			continue;
		}	

		for (cp = gr->gr_mem; cp && *cp; cp++)

			if (strcmp(*cp, user) == 0) {

				printf("%s ", gr->gr_name);
				break;
			}
	}
	printf("\n");
	exit(0);
}
