/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) root.c: version 25.1 created on 12/2/91 at 15:15:54	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)root.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	ATT:#ident	"graf:src/stat.d/root.c	1.3"	*/
	
#ident	"@(#)graf/src/stat.d:root.c	25.1"

/* <:t-5 d:> */
#include "stdio.h"
#include "statd.h"
char *nodename;
#define DFLTR 2

struct options{
	double r;	/* root */
	int col;	/* number of scalars per line */
} op = { DFLTR,DFLTCOL };

main(argc,argv) /* calculate root */
int argc;
char *argv[];
{
	FILE *fdi;
	int ac, argf, i;
	char **av, *cp;

	double x, pow1();
	char lab[MAXLABEL];

	nodename = *argv;
	for( ac=argc-1,av=argv+1; ac>0; ac--,av++ )
		if( *(cp=av[0])=='-' && *++cp!='\0' ) {
			while( *cp!='\0' )
				switch(*cp++) {
				case 'c': SETINT(op.col,cp); break;
				case 'r': SETDOUB(op.r,cp); break;
				case ' ': case ',': break;
				default: ERRPR1(%c?,*(cp-1));
				}
			--argc;
		}

	if(argc <= 1) { argc=2; argf=0; } /* no args, use stdin */
	else argf=1;

	while(argc-- > 1) {
		if( strcmp(*++argv,"-")==0 || !argf ) fdi=stdin;
		else if( **argv!='-' ) {
			if( (fdi=fopen(*argv,"r"))==NULL ) {
				ERRPR1(cannot open %s, *argv);
				continue;
			}
		} else { argc++; continue; }

		TITOUT2(fdi,lab,MAXLABEL,root,op.r);
		for(i=1; getdoub(fdi,&x)!=EOF; i++)
			PRINT(pow1(x,(op.r == 0) ? 0 : 1/op.r),i,op.col);
		if(i%op.col != 1) putchar('\n');
		fclose(fdi);
	}
	exit(0);
}
