/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) getmajor.c: version 25.1 created on 12/2/91 at 15:03:13	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)getmajor.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	ATT: #ident	"getmajor:getmajor.c	1.2"		*/
/*
 *		Copyright 1984 AT&T
 */
/*	Most of code was taken from the icb command usr/src/icb/cmd/icb.c */

#ident	"@(#)cmd/getmajor:getmajor.c	1.2"

#include "stdio.h"
#include "fcntl.h"
#include "sys/icb.h"
#include "sys/mac.h"
#include <sys/types.h>
#include <sys/vreg.h>

#define ONEMEG	1048576			/*	sw0	*/
#define CPU12	1			/* ken#2 */
#define CPU25	2			/* ken#2 */

#define VERSIZE		40
#define VER_MAGIC_SIZE	7
char	*ver_magic = "012345:";

#ifdef S3000
#	include <sys/sbus.h>
#	define	NUM_SLOTS	NUM_ICB_DEVS_PER_SYS
#else
#	include <sys/iop.h>
#	define	NUM_SLOTS	MAXSLOT
#endif

extern int errno;
int all, found;

struct icb icb;

char buffer[0x10];

#define	TRUE	1
#define	FALSE	0

main(argc, argv)
int argc;
char **argv;
{
	register c;
	register char *nptr;
	extern char *optarg;
	int	reset_okay;

	all = 0;
	found = 0;

	if(argc > 1)
		nptr = (char *)argv[1];
	else
		usage();
	
	if (geteuid()==0)	/* we are root */
		reset_okay=TRUE;
	else
		reset_okay=FALSE;
	

	if( *nptr == '-') {
		++nptr;
		switch (*nptr) {
		case 'a':
			all = 1;
			found = 1;
			list();
			break;
		case 'r':
			if (reset_okay==FALSE) {
				printf("Error:  you must be root to use reset.\n");
				exit (1);
			}
			reset(atoi(optarg));
			break;
		default:
			usage();
			break;
		}
	}
	else list(nptr);
}

usage()				/*	sw0	*/
{
	printf("Usage: getmajor  [-a|name] [-r name]\n");
	printf("       where name is the device in the form: /dev/icb??\n");
	exit(1);
}

list(nptr)
char *nptr;
{
	register icbfd, i;
	register memory,bits;
	char	cpu_speed[4];
	int	cpu_cnt=0,cpu_support;
	char icb_dev[16];

	printf("  device    slot    type   board    status     memory\n");

#ifndef S3000
	sprintf(icb_dev,"/dev/icb00");
	if ((icbfd=open(icb_dev,O_RDONLY)) < 0) {		/* beg ken#2 */
		printf("error - %d: can't open %s.\n",errno,icb_dev);
		exit(1);
	}
	if ((cpu_support=ioctl(icbfd, ICBCPUSPD, cpu_speed)) < 0)
		printf("CPU SPEED option not supported\n");
	close(icbfd);						/* end ken#2 */
#endif

	for(i=0; i < NUM_SLOTS; i++) {
		sprintf(icb_dev,"/dev/icb%02d",i);
		if ((icbfd = open(icb_dev, O_RDONLY)) > 0) {
			if ( !all )
				if (strcmp(icb_dev,nptr) == 0 )
					found = 1;
				else  continue;
			printf(icb_dev);
			if (ioctl(icbfd, ICBGET, &icb) < 0) {
				printf(" ICBGET failed\n");
				close(icbfd);
				continue;
			}
			close(icbfd);
			printf("   %2d     ",icb.slot);
			switch(icb.type) {
			case MASTERCPU :	printf("MSTR "); break;
			case SLAVECPU  :	printf("SLAV "); break;
			case DMC :		printf("DMC2 "); break;
			case DTC :		printf("DTC  "); break;
			case ASP :		printf("ASP  "); break;
			case HSDT :		printf("HSDT "); break;
			case MEM :		printf("MEM  "); break;
			case GCP :
				if (icb.ramsiz == 0x20000)
					printf("GCP  ");
				else
					printf("EGCP ");
				break;
			case MAC :		printf("MAC  "); break;
			case DMC4 :		printf("DMC4 "); break;
			case MASTERCPU20 :	printf("MC20 "); break;
			case SLAVECPU20 :	printf("SL20 "); break;
			case EDT :		printf("EDT  "); break;
			case SCSIEDT :		printf("SCSI "); break; /* jc0 */
			case DMC4_2 :		printf("DM42 "); break;
			case EGCP :		printf("GC16 "); break;
			case MEM32 :		printf("MEM32"); break;
			default :		printf("???  "); break;
			}
			printf("   %2d    [",icb.board);
			if(icb.status & ICBACTIV)	printf("A");
			else				printf("_");
			if(icb.status & ICBPRFEN)	printf("P");
			else				printf("_");
			if(icb.status & ICBREAD)	printf("R");
			else				printf("_");
			if(icb.status & ICBWRITE)	printf("W");
			else				printf("_");
			if(icb.status & ICBEXEC)	printf("X");
			else				printf("_");
			if(icb.status & ICBVREG)	printf("V");
			else				printf("_");
			if(icb.status & ICBDWNLD)	printf("D"); /* sw0 */
			else				printf("_");
			if(icb.status & ICBERROR)	printf("E");
			else				printf("_");
			printf("]");
			if(icb.status & ICBDPMEM)
				printf(" dpr:%6x",icb.dpmem);
			if(icb.ramsiz > 0 || icb.type == MEM32 ) {
				switch (icb.type) {
				case (MEM):
				case (MEM32):
					bits=(icb.ramsiz & 0xc0)>>6;
					memory=(icb.type == MEM32) ?
						ONEMEG * 8 : ONEMEG;
					while(bits--)
						memory *= 2;
					printf(" ram:%6x",memory);
					break;
				default:
					printf(" ram:%6x",(icb.ramsiz+ICBDPMEMSZ));
				}
			}
			if (icb.type == HSDT || icb.type == EDT || icb.type == SCSIEDT) 
			{
				printf("\t\t\t");
				getversion();
			}
			else if ((icb.type == MASTERCPU20 ||
				icb.type == SLAVECPU20 ) &&
				cpu_support >= 0 ) {
				printf("\t\t\t");
				switch (cpu_speed[cpu_cnt++]) {
					case 0: printf("	dead cpu");
						break;
					case CPU12: printf("	12.5 MHz");
						break;
					case CPU25: printf("	25 MHz");
						break;
				}
			}
			printf("\n");
		}
	}
	if (!found) printf("%s is not a device on this system.\n",nptr);
}

reset(dev)
register dev;
{
	register icbfd;
	char icb_dev[16];

	sprintf(icb_dev,"/dev/icb%02d",dev);
	if ((icbfd = open(icb_dev, O_RDONLY)) < 0) {
		printf(" OPEN failed\n");
		exit(1);
	}
	if (ioctl(icbfd, ICBRESET, 0) < 0) {
		printf(" ICBRESET failed\n");
		exit(1);
	}
	close( icbfd );
}

puthex(c)
register unsigned char c;
{
	putnib(c>>4);
	putnib(c);
}

putnib(c)
register unsigned char c;
{
	c &= 0xf;
	if (c < 10)
		c += '0';
	else
		c += 'A' - 10;
	putchar(c);
}

getversion()
{
	register int	kfd;
	char		verbuf[VERSIZE];
	struct bd_desc	bdesc;
	unsigned	offset;

#ifdef S3000
	printf("       n/a");
#else
	if (  (kfd = open("/dev/kmem", 0)) < 0 ) {
		return;
	}

	if ( (int)icb.bdptr < 0x600000 ||  (int)icb.bdptr > 0x72ffff ) {
		return;
	}

	if ( lseek(kfd, (unsigned)icb.bdptr, 0) == -1 ) {
		return;
	}

	/* read in bd_desc for this board */
	if ( read(kfd, &bdesc, sizeof(struct bd_desc))
	  != sizeof(struct bd_desc) ) {
		return;
	}

	/* get offset for version string pointer */
	offset = (unsigned)bdesc.sysinfptr;

	if ( offset < 0 || offset > (0xffff - VERSIZE) ) {
		return;
	}

	offset = (unsigned)bdesc.sysinfptr + (unsigned)IOP_BASE(icb.slot);

	if ( lseek(kfd, offset, 0) == -1 ) {
		return;
	}

	/* read in version string */
	if ( read(kfd, verbuf, VERSIZE) != VERSIZE ) {
		return;
	}


	if ( strncmp(verbuf, ver_magic, VER_MAGIC_SIZE) ) {
		return;
	}

	printf("         %s", &verbuf[VER_MAGIC_SIZE]);
#endif
}
