/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) fuser.c: version 25.1 created on 12/2/91 at 15:02:38	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)fuser.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*
 *	System V NFS - Release 3.2/V3
 *
 *	Copyright 1986, 1987, 1988 Lachman Associates, Incorporated (LAI)
 *
 *	All Rights Reserved.
 *
 *	The copyright above and this notice must be preserved in all
 *	copies of this source code.  The copyright above does not
 *	evidence any actual or intended publication of this source
 *	code.
 *
 *	This is unpublished proprietary trade secret source code of
 *	Lachman Associates.  This source code may not be copied,
 *	disclosed, distributed, demonstrated or licensed except as
 *	expressly authorized by Lachman Associates.
 */
static char SysVr3NFSID[] = "@(#)fuser.c	3.3 LAI System V NFS Release 3.2/V3	source";
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ident	"@(#)fuser:fuser.c	1.27.2.1"

/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*			The last swap based fuser for the 3B5
			and the 3B2 is rev 1.17 */
/* kd1 - changed mask to fit 25Mhz cpus				*/
/* kd2 - above change was not complete				*/
/* hh1 - initial S90 port - kv_to_kmem macros, leave out 25 mhz a1000 stuff */
/* hh2 - didn't work on regular files, + s90 no swplo structure in kernel */


#include <nlist.h>
#include <fcntl.h>
#include <pwd.h>
#include <stdio.h>

#include <sys/param.h>
#include <sys/types.h>

#include <sys/fs/s5dir.h>
#include <sys/file.h>
#include <sys/inode.h>

#ifdef u3b
#include <sys/page.h>
#include <sys/region.h>
#endif

#ifdef u3b2
#include <sys/immu.h>
#include <sys/psw.h>
#include <sys/pcb.h>
#include <sys/region.h>
#include <sys/sbd.h>
#endif

#ifdef i386
#include <sys/immu.h>
#include <sys/region.h>
#endif

#include <sys/proc.h>
#include <sys/signal.h>
#include <sys/stat.h>
#include <sys/sysmacros.h>
#include <sys/user.h>
#include <sys/var.h>
#include <sys/mount.h>
#include <sys/sema.h>
#include <sys/comm.h>
#include <sys/ofile.h>

#include <mnttab.h>		/* begin sh0 			*/
#include <sys/conf.h>		/* get struct bdevsw from here */

#define	MNTTAB	"/etc/mnttab"	/* end sh0			*/

/* definition of memory page size */
#if m68k || M68020
#define PSIZE	4096
#define PSHIFT	12
#endif
#if pdp11 || vax
#define PSIZE	512
#define PSHIFT	9
#endif
#ifdef u3b2
#define PSIZE	2048
#define PSHIFT	11
#endif

/* symbol names */
#if pdp11 || vax
#define V_STR		"_v"
#define PROC_STR	"_proc"
#define FILE_STR	"_file"
#define INODE_STR	"_inode"
#define SWPLO_STR	"_swplo"
#define SBRPTE_STR	"_sbrpte"
#endif
#if u3b || u3b5 || u3b2 || m68k || M68020
#define V_STR		"v"
#define PROC_STR	"proc"
#define FILE_STR	"file"
#define INODE_STR	"inode"
#define MOUNT_STR	"mount"
#define NUMCPU25	"num_cpu25" /*kd2*/
#ifdef u3b
#define SWPLO_STR	"swaplow"
#endif
#if u3b5 || u3b2 || m68k || M68020
#ifndef S3000 /* hh2 */  
#define	SWPLO_STR	"swplo"
#endif
#endif
#endif
#define NSNDD_STR "nsndd"
#define SNDD_STR  "sndd"
#define NRCVD_STR "nrcvd"
#define RCVD_STR  "rcvd"
#define RFSFST_STR  "dufstyp"

#define NFSFST_STR "nfsfstyp"	/* shouldn't be present if no NFS begin shen0*/
#define	BDEVSW_STR "bdevsw"
#define NFSSTRAT_STR "nfsdstrategy"	/* end sh0 */
#ifdef u3b2
#define MAJOR_STR "MAJOR"
#endif /* u3b2 */

#define NFSTYPE "NFS"		/* for mnttab */

#ifdef S3000 /* hh1 */
#	define SYSTEM "/arix"
#include <sys/kmem.h>	/* hh1 for kv_to_mem macro */
#else 
#	define SYSTEM "/syst"
#endif

#define MEMF "/dev/mem"


/*	types of files, etc */
#define LOCAL	1
#define	REMOTE	2
#define	RESRC	3
#define YNFS	4	/*  sh0 */

/*
** returned by is_nfs routine
*/

#define NOTNFS	0	/* sh0 */
#define ISNFS	1	/* sh0 */

#define IEQ(X, Y) ((X.i_dev == Y.i_dev) && (X.i_number == Y.i_number)) || \
	(((X.i_ftype & IFMT) == IFBLK) && (X.i_rdev == Y.i_dev))
#define MIN(X, Y)  ((X < Y) ? X : Y)

#ifdef u3b
/* NOTE:  On 3b nlist can't find FILE_STR do to a name
 * conflict with minfo.file (see sysinfo.h)
 * the u3b code should be changed when the nlist problem is fixed
 * i.e., remove this ifdef, keep the code in the else clause.
 */
#define valid_file(X) (X != 0)
#else
#define valid_file(X) (file_adr <= (unsigned) X &&\
	(unsigned) X < file_adr + v.v_file * sizeof (struct file))
#endif

#define valid_inode(X) (inode_adr <= (unsigned) X &&\
	(unsigned) X < (inode_adr + (v.v_inode * sizeof (struct inode))))

void exit(), perror();
extern char *malloc();

int gun = 0, usrid = 0;
struct inode ina, inb;
int nsndd;
struct sndd sndd_ina, sndd_inb, *snddp;
int nrcvd;
struct rcvd *rcvdp;

struct nlist nl[] = {
	{V_STR},
	{PROC_STR},
	{FILE_STR},
	{INODE_STR},
	{MOUNT_STR},
#ifndef S3000	/* hh2 */
	{SWPLO_STR},
#endif
	{NSNDD_STR},
	{SNDD_STR},
	{NRCVD_STR},
	{RCVD_STR},
	{RFSFST_STR},
#ifndef S3000 	/* hh1 */
 	{NUMCPU25}, 	/*kd2*/
#endif
	{NFSFST_STR},
	{BDEVSW_STR},
	{NFSSTRAT_STR},
#ifdef u3b2
	{MAJOR_STR},
#endif /* u3b2 */
	{""}
};

copylval(symbol, ptr)
char *symbol;
unsigned *ptr;
{		/* Copies the lvalue of the UNIX symbol "symbol" into
		 * the variable pointed to by "ptr". The lvalue of
		 * "symbol" is read from SYSTEM.
		 */
	int i = 0;

	while(nl[i].n_name[0] != '\0') {
		if(!strcmp(symbol,nl[i].n_name)) {
			if(nl[i].n_value == 0) {
				return(-1);
			}
			*ptr = nl[i].n_value;
			return(0);
		}
		i++;
	}
	return(1);
}

copyrval(symbol, ptr, size, memdev)
char *symbol, *ptr;
int memdev, size;
{	/* Copies the rvalue of the UNIX symbol "symbol" into the structure
	 * pointed to by "ptr". The rvalue is read from memory at the location
	 * specified by the value of "symbol" in the name list file "nl_file".
	 */
	int mem;
	unsigned lval;

	if(copylval(symbol, &lval)) {
		printf("Copyrval: did not find '%s'\n",symbol);
		exit(1);
	}
	if(memdev >= 0) mem = memdev;
	else if((mem = open(MEMF, O_RDONLY)) == -1)
	{	perror(MEMF);
		exit(1);
	}
#ifdef vax
	lval &= 0x3fffffff;
#endif
	rread(mem, (long) lval, ptr, size);
	if(memdev != mem) close(mem);
}

file_to_inode(file_adr, in, memdev)
int memdev;
struct inode *in;
struct file *file_adr;
{	/* Takes a pointer to one of the system's file entries
	 * and copies the inode  to which it refers into the area
	 * pointed to by "in". "file_adr" is a system pointer, usually
	 * from the user area. */
	int mem;
	struct file f;
	union /* used to convert pointers to numbers */
	{	char	*ptr;
		unsigned addr; /* must be same length as char * */
	} convert;

	convert.ptr = (char *) file_adr;
#ifdef vax
	convert.addr &= 0x3fffffff;
#endif
	if(convert.addr == 0) return(-1);
	if(memdev >= 0) mem = memdev;
	else if((mem = open(MEMF, O_RDONLY)) == -1)
	{	perror(MEMF);
		return(-1);
	}

	/* read the file table entry */
	rread(mem, (long) convert.addr, (char *) &f, sizeof f);
	if(memdev != mem) close(mem);
	if(f.f_flag)
		return(read_inode(f.f_inode, in, memdev));
	else return(-1);
}
struct var v;
struct mount *mnt, *mp;
unsigned proc_adr;
short rfstyp;
unsigned *pofile;
struct proc p;
char *progname;
int cpuflag;	/*kd2*/

/*
** nfs file system type value
*/

int		nfsfstyp;

main(argc, argv)
int argc;
char **argv;
{
	int mem, newfile = 0, errcnt = 0;
	register i, j, k;
	struct user *ublock;
	unsigned file_adr, inode_adr, mount_adr;
	unsigned nsndd_adr, sndd_adr, nrcvd_adr, rcvd_adr, rfstyp_adr;

	unsigned	nfsfstyp_adr;
	unsigned	bdevsw_adr;
	unsigned	major_adr;
	int 		(*nfsdstrategy)();	/* NFS strat routine address */
	int		nfsdevflg;
#ifdef u3b2
	char		MAJOR[128];
#endif /* u3b2 */
	char		mountbuf[64];

	/*
	** save argv[0] for other routines which might need
	** to print it.
	*/

	progname = argv[0];

	/* once only code */
	if(argc < 2) {
		fprintf(stderr, "Usage:  %s { [-[ku]] file } ... \n", argv[0]);
		exit(1);
	}

	/* open file to access memory */
	if((mem = open(MEMF, O_RDONLY)) == -1) {
		fprintf(stderr, "%s: ", argv[0]);
		perror(MEMF);
		exit(1);
	}
	/* get values of system variables */
	if(nlist(SYSTEM, nl) == -1) {
		perror("nlist:");
		return(-1);
	}

	/* get values of system variables and address of process table */
	copyrval(V_STR, (char *) &v, sizeof v, mem);
	ublock = (user_t *)malloc(sizeof(user_t) + sizeof(int) * v.v_nofiles);
	if(copylval(PROC_STR, &proc_adr)) {
		printf("Copyrval: did not find '%s'\n",PROC_STR);
		exit(1);
	}
#ifdef vax
	proc_adr &= 0x3fffffff;
#endif
	if(copylval(FILE_STR, &file_adr)) {
		printf("Copyrval: did not find '%s'\n",FILE_STR);
		exit(1);
	}
	if(copylval(INODE_STR, &inode_adr)) {
		printf("Copyrval: did not find '%s'\n",INODE_STR);
		exit(1);
	}

/*kd2*/
#ifndef S3000 /* hh1 */
	copyrval(NUMCPU25,(char *)&cpuflag, sizeof cpuflag, mem);
#endif
/* NFS */
	
	/*
	** load the address of the bdev table
	*/

	if (copylval(BDEVSW_STR, &bdevsw_adr)) {
		printf("Copylval: did not find '%s'\n",BDEVSW_STR);
		exit(1);
	}
#ifdef u3b2	
	if(copylval(MAJOR_STR, &major_adr)) {
		printf("Copylval: did not find '%s'\n",MAJOR_STR);
		exit(1);
	}

	rread(mem,(long)major_adr,MAJOR,sizeof(MAJOR));
#endif /* u3b2 */
/* RFS */
	/* space for mount table */

	if((copylval(MOUNT_STR, &mount_adr))) 
		mnt = 0;
	else
		mnt = (struct mount *)malloc(v.v_mount * sizeof(struct mount));
	if(mnt) 
		rread(mem, (long)mount_adr, mnt, v.v_mount * sizeof(struct mount));

	/* space for send descriptors */

	if((copylval(NSNDD_STR, &nsndd_adr )) 
	|| (copylval(SNDD_STR, &sndd_adr))) 
		snddp = 0;
	else {
		rread(mem, (long)nsndd_adr, (char *)&nsndd, (int)sizeof(nsndd));
		snddp = (struct sndd *)malloc(nsndd * sizeof(struct sndd));
	}
	if(snddp) 
		rread(mem, (long)sndd_adr, (char *)snddp, (int)(nsndd * sizeof(struct sndd)));

	/* space for receive descriptors */

	if((copylval(NRCVD_STR, &nrcvd_adr )) 
	|| (copylval(RCVD_STR, &rcvd_adr))) 
		rcvdp = 0;
	else {
		rread(mem, nrcvd_adr, &nrcvd, sizeof(nrcvd));
		rcvdp = (struct rcvd *)malloc(nrcvd * sizeof(struct rcvd));
	}
	if(copylval(RFSFST_STR, &rfstyp_adr ))
		rfstyp = -1; 
	else {
		rread(mem, rfstyp_adr, &rfstyp, sizeof(rfstyp));
		if (rfstyp == 0)
			rfstyp = -1;
	}

	/*
	** see if NFS is installed in kernel
	*/

	if (copylval(NFSSTRAT_STR, &nfsdstrategy))
		nfsdstrategy = 0;

	if (copylval(NFSFST_STR, &nfsfstyp_adr))
		nfsfstyp = -1;
	else {
		rread(mem,nfsfstyp_adr, &nfsfstyp, sizeof(nfsfstyp));
		if (nfsfstyp == 0)
			nfsfstyp = -1;		/* no NFS */
	}

	if(rcvdp) 
		rread(mem, rcvd_adr, rcvdp, nrcvd * sizeof(struct rcvd));

	/* for each argunent on the command line */
	for(i = 1; i < argc; i++) {
		if(argv[i][0] == '-') {
			/* options processing */
			if(newfile) {
				gun = 0;
				usrid = 0;
			}
			newfile = 0;
			for(j = 1; argv[i][j] != '\0'; j++)
			switch(argv[i][j]) {
			case 'k':
				gun++; 
				break;
			case 'u':
				usrid++; 
				break;
			default:
				fprintf(stderr,
					"Illegal option %c ignored.\n",
						argv[i][j]);
			}
			continue;
		} else
			newfile = 1;
		fflush(stdout);
	
		/* First print file name on stderr (so stdout (pids) can
		 * be piped to kill) */
		fprintf(stderr, "%s: ", argv[i]);

#ifdef NFSMNT				/* shen0 */
		/* then convert the path into an inode */
/* NFS */
		/* 
		** We have to check if it's NFS first, because a
		** stat can succeed on an NFS file and still not
		** be handled properly due to i-number differences
		** over NFS.  This way, we take no chances.
		** If the file isn't NFS, then we just do the
		** regular stuff.
		*/

		if (nfsfstyp != -1 &&
			is_nfs(argv[i],&nfsdevflg, bdevsw_adr, mem, 
				nfsdstrategy, 
#ifdef u3b2
				MAJOR,
#else /* u3b2 */
				0,
#endif /* u3b2 */
				mountbuf)) {

				/*
				** if not a block special file,
				** look up the file on nfs
				*/

				if (!nfsdevflg)
					nfs_lookup(argv[i], &ina, mem);
				
				/*
				** otherwise map to a mount point
				** and then check all file mount
				** points to see if they match
				*/

				else {
					nfs_lookup(mountbuf, &ina, mem);
					ina.i_ftype = IFBLK;
				}
		}
		else 
#endif				/* shen0 */

			if(path_to_inode(argv[i], &ina) != 0) {
/* RFS */
			if(rsrc_to_inode(argv[i], &ina, mem) != -1) {
				rread(mem, (struct sndd *)(ina.i_fsptr),
					&sndd_ina, sizeof(struct sndd));
			}
			else {
				fprintf(stderr," not found\n");
				errcnt++;
				continue;
			}
		}
		/* then for each process */
		for(j = 0; j < v.v_proc; j++) {
			/* read in the per-process info */
			rread(mem, (long) (proc_adr + j * sizeof p),
					(char *) &p, sizeof p);
			if(p.p_stat == 0 
			|| p.p_stat == SZOMB 
			|| p.p_stat == SIDL) 
				continue;
			/* and the user area */
			read_user(&p, ublock, mem, j);
/* why calculate pofile if we never use it???
			pofile = (unsigned *)((unsigned)ublock 
				+ ((unsigned)(ublock->u_pofile) & 0xffff));
*/
			if(valid_inode(ublock->u_cdir) &&
				read_inode(ublock->u_cdir, &inb, mem) == 0)
				if(ckuse(mem, "c")) {
					errcnt++;
					continue;
				}
	
	/* This code is only valid in transient cases and the inodes
	 * (pointed to by u_pdir) are not cleared after their use.
	*/
	/*		if(valid_inode(ublock->u_pdir) &&
	/*			read_inode(ublock->u_pdir, &inb, mem) == 0)
	/*			if(ckuse(mem, "p")) {
	/*				errcnt++;
	/*				continue;
	/*			}
	*/
	
			if(valid_inode(ublock->u_rdir) &&
				read_inode(ublock->u_rdir, &inb, mem) == 0)
				if(ckuse(mem, "r")) {
					errcnt++;
					continue;
				}

			/* then, for each file */
			for(k = 0; k < ublock->u_nofiles; k++)
			{
				struct file *get_ofile();
				struct file *ufp = get_ofile(mem, ublock, k);
				if(!valid_file(ufp)) 
					continue;
				if(file_to_inode(ufp, &inb, mem))
					continue;
				if(ckuse(mem, strncmp(ublock->u_comm,"server",6)
						== 0 ? "S" :  "")) {
					errcnt++;
					break;
				}
			}
		}
	
/* RFS */
		/* for each receive descriptor entry */
		/* scan receive descriptors for:
			1. pointers to the file table (open files)
			2. pointers to inodes (cd, mount, etc.)
	
		in either case, get the inode and 'chkuse()'
	*/
		if(rcvdp) 
		for(k = 0; k < nrcvd; k++) {
			
			if(rcvdp[k].rd_stat & RDUNUSED)
				continue;
				/* The next 'if' assumes the only valid addresses
				   in the receive descriptor is a file pointer
				   or an inode pointer.
				   If the valid_file macro problem is ever fixed,
				   the line below should read:
					if(valid_file((rcvdp[i].rd_file))
				*/
			if(!valid_inode(rcvdp[k].rd_inode)) {
				if(file_to_inode(rcvdp[k].rd_file, &inb, mem))
					continue;
			}
			else if(valid_inode(rcvdp[k].rd_inode)) {
				if(read_inode(rcvdp[k].rd_inode, &inb, mem))
					continue;
			}
			else 
				break;
	
		/*** who is the owner of this receive descriptor? ***/

			if(ckuse(mem, "U")) {
				errcnt++;
				continue;
			}
		}
		printf("\n");
	}
	exit(errcnt);
}

rsrc_to_inode(name, ino, mem)
char *name;
struct inode *ino;
{
	int i;

			/* search kernel mount table for the resource name. */
	if(mnt)
		for(i = 0, mp = mnt; i < v.v_mount; i++, mp++)
			if(mp->m_flags & MINUSE)
			if(nmck(name, mp->m_name, mem))
				if(read_inode(mp->m_mount, ino, mem) != -1)
					return(0);
	return(-1);	/* resource not found in mount table */
}

nmck(n1,addr,mem)
char *n1;
{
	char *nm, kname[NMSZ];

	rread(mem, addr, kname, NMSZ);
	if(!strncmp(n1, kname, NMSZ))
		return(1);
	return(0);
}

ckuse(mem, fc)
char *fc;
{

	struct inode in;
	struct mount mn;

/* NFS */

	/*
	** For NFS, read in inb's mount pointer and then its
	** mount pointer's inode
	** Only match if we're looking for a "special device"
	** and if the mount point matches.  This way we
	** get all files, just as if we'd done 
	** "fuser /dev/dsk/xxxx"
	*/
	if (ina.i_fstyp == nfsfstyp && inb.i_fstyp == nfsfstyp) {
		rread(mem, (long) inb.i_mntdev, (char *)&mn, 
			sizeof (struct mount));
		read_inode(mn.m_mount, &in, mem);
		if (ina.i_ftype == IFBLK && in.i_dev == ina.i_dev)
			goto pun;
	}

/* RFS */
			/* determine if the inodes in question are 
			local or remote */

			/* if both are remote */

	if(ina.i_fstyp == rfstyp) {
		if(inb.i_fstyp == rfstyp) {
			rread(mem, (struct sndd *)(inb.i_fsptr),
				&sndd_inb, sizeof(struct sndd));
			if((sndd_ina.sd_queue == sndd_inb.sd_queue)
			&& (sndd_ina.sd_mntindx == sndd_inb.sd_mntindx))
				goto pun;
			else
				return(0);
		} else
			return(0);
	}
	else 
		if(inb.i_fstyp == rfstyp)
			return(0);

	if(IEQ(ina, inb)) {
 		if(fc[0] == 'U') 
			fprintf(stdout,"REMOTE USER(S)");
pun:		fprintf(stdout, " %7d", (int) p.p_pid);
		fflush(stdout);
		switch(fc[0]) {
		case 'c':
		case 'p':
		case 'r':
		case 'S':
			fprintf(stderr,"%c", fc[0]);
		}
		if(usrid) 
			puname();
		if((fc[0] != 'S') && (gun)) {
			kill((int) p.p_pid, 9);
			return(1);
		}
	}
	return(0);
}

path_to_inode(path, in)
char *path;
struct inode *in;
{	/* Converts a path to inode info by the stat system call */

	struct stat s;

	if(stat(path, &s) == -1) {
/*			don't want to do this cuz it's normal for resources 
		perror("stat"); */
		return(-1);
	}

	/*
	** Negate if NFS -- this is for compat with find -local.
	*/

	if (s.st_dev < 0)
		s.st_dev = ~s.st_dev;

	in->i_ftype = s.st_mode;
	in->i_dev = s.st_dev;
	in->i_number = s.st_ino;
	in->i_rdev = s.st_rdev;

	return(0);
}

puname()
{	struct passwd *getpwuid(), *pid;

	pid = getpwuid(p.p_uid);
	if(pid == NULL) return;
	fprintf(stderr, "(%s)", pid->pw_name);
}

read_inode(inode_adr, i, memdev)
int memdev;
struct inode *i, *inode_adr;
{	/* Takes a pointer to one of the system's inode entries
	 * and reads the inode into the structure pointed to by "i" */

	int mem;
	union {		/* used to convert pointers to numbers */
		char	*ptr;
		unsigned addr; /* must be same length as char * */
	} convert;

	convert.ptr = (char *) inode_adr;
#ifdef vax
	convert.addr &= 0x3fffffff;
#endif
	if(convert.addr == 0) return(-1);
	if(memdev >= 0) mem = memdev;
	else if((mem = open(MEMF, O_RDONLY)) == -1) {
		perror(MEMF);
		return(-1);
	}

	/* read the inode */
	rread(mem, (long) convert.addr, (char *) i, sizeof (struct inode));
	if(memdev != mem) close(mem);
#if vax || u3b || u3b5
	i->i_dev = brdev(i->i_dev);	/* removes bits to distinguish small and large FS */
	i->i_rdev = brdev(i->i_rdev);	/* removes bits to distinguish small and large FS */
#endif
	if(i->i_count == 0)
		return(-1);
	return(0);
}

read_user(pr, ub, memdev, pndx)
int memdev, pndx;
struct proc *pr;
struct user *ub;
{	/* Copies the system's user area (in memory) pointed
	 * to by "pr" into the structure pointed to by "u"
	 */

	int i, x;
	static int mdev = -1;
#ifndef S3000 /* hh2 */
	static daddr_t	swplo = (daddr_t) -1;

	if(swplo == (daddr_t) -1)
	  copyrval(SWPLO_STR, (char *) &swplo, sizeof swplo, memdev);
#endif

	/* Method depends on the machine */

#if m68k || M68020
 	if(mdev < 0 && (mdev = open(MEMF, O_RDONLY)) == -1) {
 		perror(MEMF);
 		exit(1);
 	}
 	
#ifdef S3000			/* hh 1 */
	x = (int)pr->p_userp ;
#else
 	if(cpuflag)	/*cpu is 25MZ*/
 		x=(pr->p_addr.pgi.pg_pde & 0x3fff0000) >> 4; /*kd2*/
 	else
 		x=(pr->p_addr.pgi.pg_pde & 0x0fff0000) >> 4; /*kd2*/
#endif
 
 	rread( mdev, (long)x, (char *) ub, 
		sizeof(user_t) + sizeof(int) * v.v_nofiles); /* hh2 */
 /*	This was the ching su 5.3 method for getting the upage
 	x = (pr->p_ubptbl[0].pgm.pg_pfn & 0x0fff) << PNUMSHFT;
 	rread(mdev, (long)x, (char *)ub, (sizeof(user_t) + sizeof(int) * v.v_nofiles)); */
#endif /*m68k || M68020*/
	
	/* VAX */
#ifdef vax
	if(sbrpte == -1) {
		copyrval(SBRPTE_STR, (char *)&sbrpte,
		  sizeof sbrpte, memdev);
		sbrpte &= 0x3fffffff;
	}
	if(mdev < 0 && (mdev = open("/dev/mem", O_RDONLY)) == -1) {
		perror("/dev/mem");
		exit(1);
	}
	x = (int) (pr->p_spt + (pr->p_nspt - 1) * 128);
	x = (sbrpte + ((x & 0x3fffffff) >> PSHIFT) * 4) & 0x3fffffff;
	rread(mdev, (long) x, (char *) &spte, sizeof spte);
	rread(mdev, (long) ((spte&0x1fffff) << PSHIFT),
	  (char *) upte, sizeof upte);

	for(i = 0; i < sizeof (*ub); i += PSIZE)
		rread(mdev,
		   (long) ((upte[128-USIZE+i/PSIZE]&0x1fffff) << PSHIFT),
		   ((char *) ub) + i, MIN(PSIZE, sizeof(*ub) - i));
#endif

	/* Paging */
#ifdef u3b
	if((mdev < 0) && ((mdev = open("/dev/mem", O_RDONLY)) == -1)) {
		perror("/dev/mem");
		exit(1);
	}

	for(i = 0; i < sizeof (*ub); i += NBPP)
		rread(mdev, (long)(pr->p_uptbl[i/NBPP] & PG_ADDR),
			((char *) ub) + i, MIN(NBPP, sizeof(*ub) - i));
#endif


	/* Paging */
#ifdef u3b2
	if((mdev < 0) && ((mdev = open("/dev/mem", O_RDONLY)) == -1)) {
		perror("/dev/mem");
		exit(1);
	}
	i = ((char *)ubptbl((proc_t *)(proc_adr + pndx * sizeof(proc_t)))
	    - (char *)(proc_adr + pndx * sizeof(proc_t))
	    - ((char *)pr->p_ubptbl - (char *)pr)) >> 2;

	for(x = 0; x < sizeof(*ub) + sizeof(int) * v.v_nofiles; x += NBPP, i++) {
		rread(mdev, (long)(pr->p_ubptbl[i].pgm.pg_pfn << 11) - MAINSTORE,
			((char *) ub) + x,
			MIN(NBPP,(sizeof(*ub) + sizeof(int) * v.v_nofiles) - x));
	}
#endif

	/* Paging */
#ifdef u3b5
	if((mdev < 0) && ((mdev = open("/dev/mem", O_RDONLY)) == -1)) {
		perror("/dev/mem");
		exit(1);
	}
	rread(mdev, (long) pr->p_addr << PNUMSHFT, (char *)ub, 
		    sizeof (struct user));
#endif

	/* Paging */
#ifdef pdp11
	if(pr->p_flag & SLOAD /* in core */) {
		if((mdev < 0) &&
			((mdev = open("/dev/mem", O_RDONLY)) == -1))
		{	perror("/dev/mem");
			exit(1);
		}
		rread(mdev, ctob((long) pr->p_addr), (char *) ub, sizeof *ub);
	} else  {	/* swapped */
		if((sdev < 0) &&
			((sdev = open("/dev/swap", O_RDONLY)) == -1)) {
			perror("/dev/swap");
			exit(1);
		}
		rread(sdev, (pr->p_addr + swplo) << 9, (char *) ub, sizeof *ub);
	}
#endif
}

rread(device, position, buffer, count)
char *buffer;
int count, device;
long position;
{	/* Seeks to "position" on device "device" and reads "count"
	 * bytes into "buffer". Zeroes out the buffer on errors.
	 */
	int i;
	long lseek();
#ifdef S3000 /* hh1 */
	if ( position & 0x80000000 ) /* this is a seek into /dev/mem KLUDGE hh*/
		position = kv_to_mem(position);
#endif
	if(lseek(device, position, 0) == (long) -1) {
		fprintf(stderr, "Seek error for file number %d: ", device);
		perror("");
		for(i = 0; i < count; buffer++, i++) *buffer = '\0';
		return;
	}
	if(read(device, buffer, (unsigned) count) == -1) {
		fprintf(stderr, "Read error for file number %d: ", device);
		perror("");
		for(i = 0; i < count; buffer++, i++) *buffer = '\0';
	}
}
#ifdef NFSMNT

/*
** is_nfs:  -- determine whether s is an nfs file or not
**
** arguments:
**
**	char *s;	 -- pathname to check
**	int  *nfsdevflg; -- flag value for block device
**	unsigned addr;   -- address in memory of bdev table
**	int mem;	 -- the memory file descriptor
**	int (*nfsdstrategy)(); -- kernel address of nfs strat routine
**	char MAJOR[];	 -- array of internal major numbers
**	char mountbuf[]; -- used to save filesystem name for later
**
** returns:
**
**	int --		0 == not nfs, 1 == nfs
**
** modifies:
**
**	*nfsdevflg;	1 == treat as block device, 0 == normal file
**
*/

/*
** Warning:
** bmajor macro copied from <sys/sysmacros.h>
** If something goes wrong, it would be a good idea to check that
** this is still the same as the one in the include file.  
** It is surrounded by #ifdef INKERNEL, so I did not want to 
** to define INKERNEL due to fear of what might result.
*/
#ifdef u3b2
#define bmajor(x) (int)(MAJOR[(unsigned)((x)>>8)&0x7F])
#else /* u3b2 */
#define bmajor(x)       (int)((unsigned)((x)>>8)&0x7F)
#endif /* u3b2 */
int is_nfs(s, nfsdevflg, addr, mem, nfsdstrategy, MAJOR, mountbuf)
char		*s;
int		*nfsdevflg;
unsigned	addr;
int		mem;
int		(*nfsdstrategy)();
char		MAJOR[];
char		mountbuf[];
{

	struct stat	sb;
	struct mnttab	mb;
	int		m;
	char		*cp1, *cp2;
	extern char 	*strchr();
	struct bdevsw	bdev;
	int		maj;

	*nfsdevflg = 0;

	/*
	** Check to see if we can stat this file.  If we can't,
	** it may be an nfs pathname (eg host:/path).  If there's
	** a :/ sequence in it, check in mnttab
	*/

	if (stat(s, &sb) == -1) {
		cp1 = strchr(s,':');
		cp2 = strchr(s,'/');
		if (++cp1 == cp2) {

			m = open(MNTTAB, O_RDONLY);
			if (m < 0) {
				perror(MNTTAB);
				return NOTNFS;
			}

			while (read(m, &mb, sizeof(mb)) == sizeof(mb)) {
				if (strncmp(s,mb.mt_dev,strlen(s)))
					continue;

				/*
				** Found in mnttab.
				*/
				if (strncmp(NFSTYPE,mb.mt_fstyp,3))
					continue;
				
				/*
				** It's NFS.  Save its filesystem
				** name so we don't have to do this
				** again.
				*/
				*nfsdevflg = 1;
				strncpy(mountbuf, mb.mt_filsys, 32);
				mountbuf[32] = '\0';
				return YNFS;
			}

				return NOTNFS;
		}

		return NOTNFS;
	}

	/*
	** Stat succeeded -- check if file is on an NFS
	** device.  Do this by snarfing the block device
	** information in the bdev switch and then comparing
	** the address of the strategy routine with that
	** of the nfs strategy routine.
	**
	** We must negate the st_dev field if it is less than zero.
	** NFS does this for compatability with RFS and find -local.
	*/

	if (sb.st_dev < 0)
		sb.st_dev = ~sb.st_dev;	/* Local Vs. Remote, see find(1) */

	/*
	** Read the block device info for st_dev
	*/

	maj = bmajor(sb.st_dev);

	rread(mem, (long)(addr + (maj * sizeof(struct bdevsw))),
		(char *)&bdev, (int)sizeof(struct bdevsw));


	/*
	** Check the strategy routines... What could be simpler?
	*/

	if (bdev.d_strategy == nfsdstrategy)
		return ISNFS;
	
	return NOTNFS;
}

/*
** nfs_lookup: perform a lookup of an NFS file
**
** Arguments:
**
**	char	*s;		-- file name
**	struct inode *ino;	-- inode field to fill in
**	int	mem;		-- fd of memory device
**
** Returns:
**
**	int -- status of operation -- 1 == success, 0 == failure
*/

int nfs_lookup(s, ino, mem)
char		*s;
struct inode	*ino;
int		mem;
{

	int		f;
	int		i;
	extern int	getpid();
	struct	user	*ublock;
	int		pid;
	struct proc	pr;

	/*
	** malloc enough space to hold all of the user area's file info
	*/

	ublock = (user_t *)malloc(sizeof(user_t) + sizeof(int) * v.v_nofiles);

	pid = getpid();

	f = open(s, O_RDONLY);

	if (f < 0)		/* hopefully won't happen since we're root */
		return 0;

	/*
	** Search the proc table for our own process
	*/

	for (i = 0; i < v.v_proc; i++) {
		rread(mem, (long) (proc_adr + i * sizeof pr),
			(char *) &pr, sizeof pr);
		if (pr.p_pid == pid) {
			break;
		}

	}

	/*
	** Read the user area to get the file information
	*/

	read_user(&pr, ublock, mem, i);

	/*
	** Now read the file table entry
	*/

	file_to_inode(ublock->u_ofile[f], ino, mem);

	close(f);		/* make sure we don't show up */
	free(ublock);

	return 1;
}
#endif


struct file *
get_ofile(memfd, uap, fd)
int 	memfd;
user_t	*uap;
int 	fd;
{
	ofile_chain_t	*chain_p = uap->u_ofile_chain;
	struct file	*fp;

	if (fd < NOFILES_IN_U)
		return(uap->u_fp[fd]);

	fd -= NOFILES_IN_U;

	for (; fd > NOFILES_PER_CHAIN; fd -= NOFILES_PER_CHAIN) {
		lseek(memfd, kv_to_mem((uint)(&chain_p->link)), 0);
		read(memfd, &chain_p, sizeof(chain_p));
		if (chain_p == NULL)
			return(NULL); 
	}

	lseek(memfd, kv_to_mem((uint)(&chain_p->fp[fd])), 0);

	read(memfd, &fp, sizeof(fp));

	return(fp);
}
