/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) s5fstyp.c: version 25.1 created on 12/2/91 at 15:01:37	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)s5fstyp.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	ATT:#ident	"fstyp:s5fstyp.c	1.4.1.1"	*/

#ident	"@(#)fstyp:s5fstyp.c	25.1"
#define	FsSEC1	6
#define	FsSEC4	7

#include <stdio.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/fsid.h>
#include <sys/ino.h>
#include <sys/param.h>
#include <sys/fs/s5param.h>
#include <sys/fs/s5filsys.h>

#define  SUCCESS	 0
#define  FAILURE	-1
#define  cmd		s5fstyp

#define S52K	"S52K"
#define S54K	"S54K"
#define	P1K	"ARIX1K"
#define	P4K	"ARIX4K"
#define ISIZE	inode_size(argv[1])

void	exit();
long	lseek();
int	ino_size;

main(argc,argv)
int	argc;
char	*argv[];
{

	int	fd;
	long	bsize = 0;
	char	*dev;
	char	*usage = "s5fstyp special";
	struct	stat	buf;
	struct	filsys	*sblock;
	char *fbuf , *cp, malloc();


	if (argc != 2) {
		fprintf(stderr,"Usage: %s\n",usage);
		exit(1);
	}

	dev = argv[1];
	if (stat(dev, &buf) < 0) {
		fprintf(stderr, "s5fstyp: cannot stat <%s>\n",dev);
		exit(1);
	}

	if (((buf.st_mode & S_IFMT) != S_IFBLK) 
		&& ((buf.st_mode & S_IFMT) != S_IFCHR)) {
		fprintf(stderr,"s5fstyp: <%s> is not a block, or a character device\n",dev);
		exit(1);
	}

	/*
	 *	Read the super block associated with the device. 
	 */

	if ((fd = open(dev, O_RDONLY)) < 0) {
		fprintf(stderr,"s5fstyp: cannot open <%s>\n",dev);
		exit(1);
	}

	fbuf=malloc(BSIZE);
	
	if (lseek(fd, (long)0, 0) < 0
		|| read(fd, fbuf, BSIZE) != BSIZE) {
		fprintf(stderr,"s5fstyp: cannot read superblock\n");
		close(fd);
		exit(1);
	}
	close(fd);
	
	cp= fbuf+512;
	sblock=(struct filsys *)cp;

	/*
	 *	Determine if it is a System V file system and set the
	 *	block size.
 	 */
	
	if (sblock->s_magic == FsMAGIC) {
		switch (sblock->s_type) {
			case Fs1b:
				bsize = BSIZE;
				break;
			case Fs2b:
			case FsSEC1:
#ifdef u3b15
				bsize = 4 * BSIZE;
#else
				bsize = 2 * BSIZE;
#endif
				break;
			case Fs4b:
				bsize = 2 * BSIZE;
				break;
			case Fs8b:
			case FsSEC4:
				bsize = 4 * BSIZE;
				break;
			default:
				fprintf(stderr,"s5fstyp: <%s> is not a System V or POSIX file system\n",dev);
				exit(1);
		}
	} else {
		fprintf(stderr,"s5fstyp: <%s> is not a System V or POSIX file system\n",dev);
		exit(1);
	}

	ino_size = ISIZE;

	if (sanity_check(sblock,bsize) == FAILURE) {
		fprintf(stderr,"s5fstyp: System V/POSIX file system sanity check failed\n");
		exit(1);
	}
	switch (sblock->s_type) {
	case Fs4b :
		fprintf(stdout,"%s\n",S52K);
		break;
	case Fs8b :
		fprintf(stdout,"%s\n",S54K);
		break;
	case FsSEC1 :
		fprintf(stdout,"%s\n",P1K);
		break;
	case FsSEC4 :
		fprintf(stdout,"%s\n",P4K);
		break;
	default :
		fprintf(stdout,"%s\n",S51K);
	}
	exit(0);
}

sanity_check(sblock,bsize)
struct	filsys	*sblock;
long	bsize;
{


	sblock->s_isize -= 2;
	if (sblock->s_fsize <= sblock->s_isize
		|| sblock->s_fsize < sblock->s_tfree
/*		|| sblock->s_isize < sblock->s_tinode*sizeof(struct dinode)/bsize
		|| (long)sblock->s_isize*bsize/sizeof(struct dinode) > 0x10000L) {
*/
		|| sblock->s_isize < sblock->s_tinode* ino_size /bsize
		|| (long)sblock->s_isize*bsize/ ino_size > 0x10000L) {
		return(FAILURE);
	}
	return(SUCCESS);
}
