/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) fsstat.c: version 25.1 created on 12/2/91 at 15:01:21	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)fsstat.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	ATT:#ident	"fsstat:fsstat.c	1.2"		*/

#ident	"@(#)fsstat:fsstat.c	23.1"


#include <stdio.h>
#include <fcntl.h>
#include <sys/param.h>
#include <sys/types.h>
/*	#include <sys/filsys.h> */
#include <sys/fs/s5filsys.h>
#include <sys/stat.h>
#include <ustat.h>

#define DEV_ROOT	"/dev/root"	/* root psuedo-device */

/*
 * exit 0 - file system is unmounted and okay
 * exit 1 - file system is unmounted and needs checking
 * exit 2 - file system is mounted
 *          for root file system
 * exit 0 - okay
 * exit 1 - needs checking
 *
 * exit 3 - unexpected failures
 */
main(argc, argv)
char *argv[];
{
	register dev;
	register char *fp;
	struct filsys fb;
	struct stat stbd, stbr, stb_rd;
	struct ustat usb;

	if (argc != 2) {
		fprintf(stderr, "usage: fsstat special\n");
		exit(3);
	}
	fp = argv[1];
	if ((dev = open(fp, O_RDONLY)) < 0) {
		fprintf(stderr, "fsstat: cannot open %s\n", fp);
		exit(3);
	}
	fstat(dev, &stbd);
	if ((stbd.st_mode&S_IFMT) != S_IFBLK) {
		fprintf(stderr, "fsstat: %s not a block device\n", fp);
		exit(3);
	}
	stat("/", &stbr);
	lseek(dev, SUPERBOFF, 0);
	if (read(dev, &fb, sizeof fb) != sizeof fb) {
		fprintf(stderr, "fsstat: cannot read %s\n", fp);
		exit(3);
	}
	if (stat(DEV_ROOT, &stb_rd) < 0) {
		stb_rd.st_rdev = ~0;
	}
	/*
	 * root file system is always mounted
	 */
	if (stbr.st_dev == stbd.st_rdev || stbd.st_rdev == stb_rd.st_rdev) {
		if (fb.s_state != FsACTIVE) {
			fprintf(stderr, "fsstat: root file system needs checking\n");
			exit(1);
		} else {
			fprintf(stderr, "fsstat: root file system okay\n");
			exit(0);
		}
	}
	if (ustat(stbd.st_rdev, &usb) == 0) {
		fprintf(stderr, "fsstat: %s mounted\n", fp);
		exit(2);
	}
	if (fb.s_magic != FsMAGIC) {
		fprintf(stderr, "fsstat: %s not a valid file system\n", fp);
		exit(3);
	}
	if ((fb.s_state + (long)fb.s_time) != FsOKAY) {
		fprintf(stderr, "fsstat: %s needs checking\n", fp);
		exit(1);
	}
	fprintf(stderr, "fsstat: %s okay\n", fp);
	exit(0);
}

