/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) fold.c: version 25.1 created on 12/2/91 at 15:00:24	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)fold.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*
 * Copyright (c) 1980 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 */

#include <stdio.h>
#define	DO_BACKSPC	0x01	/* Backspaces decrease line length */
#define	BREAK_AT_SPC	0x02	/* Break at word boundary, before
				   line is 'fold' long, of possible */

int	flags, fold = 80;
extern	char	*optarg;
extern	int	optind;

main(argc, argv)
int argc;
char **argv;
{
	register c;
	register int	opt;
	FILE *f;

	while( (opt = getopt( argc, argv, "bsw:")) != EOF ) {

		switch (opt) {

		/* Backspace will decrement line length by one */
		case 'b':
			flags |= DO_BACKSPC;
			break;

		case 's':
			flags |= BREAK_AT_SPC;
			break;

		case 'w':
			if ( (fold = atoi (optarg)) < 1){

				fold = 80;
				fprintf (stderr, "Warning, width must be > 0, 80 used\n");
			}
			break;
	
		default:
			usage();
			break;
		}
	}

	argc -= optind;
	argv += optind;

	do {
		if (argc > 0 ) {

			if (strcmp (argv[0], "-") != 0){

			    if ( freopen (argv[0], "r", stdin) == NULL) {

				fprintf (stderr, "fold: Unable to open file %s\n",
				    argv[0]);
				exit (1);
			    }
			}

			argc--, argv++;
		}

		for (;;) {
			c = getc(stdin);
			if (c == -1)
				break;
			putch(c);
		}
	} while (argc > 0);

	exit(0);
}

int	col;

putch(c)
	register c;
{
	register ncol;

	switch (c) {

		case '\n':
			ncol = 0;
			break;

		case '\t':
			ncol = (col + 8) &~ 7;
			break;

		case '\b':
			if ( (flags & DO_BACKSPC) == DO_BACKSPC )

			    ncol = col ? col - 1 : 0;

			else

			    ncol = col + 1;

			break;

		case '\r':
			ncol = 0;
			break;

		default:
			ncol = col + 1;
	}

	if (ncol > fold)

		putchar('\n'), col = 0;

	putchar(c);
	switch (c) {

		case '\n':
			col = 0;
			break;

		case '\t':
			col += 8;
			col &= ~7;
			break;

		case '\b':
			if ( (flags & DO_BACKSPC) == DO_BACKSPC){

			    if (col)

				col--;

			}
			else

			    col++;

			break;

		case '\r':
			col = 0;
			break;

		default:
			col++;
			break;
	}
}


usage ()
{
	fprintf (stderr, "Usage: fold [-b][-s][-w width][file_name]\n");
	exit (1);
}
