#	START NEW ARIX SCCS HEADER
#
#	@(#) ed.mk: version 25.1 created on 12/2/91 at 14:54:32
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	@(#)ed.mk	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation
#
#	END NEW ARIX SCCS HEADER
#
#	Copyright (c) 1984 AT&T
#	  All Rights Reserved

#	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T
#	The copyright notice above does not evidence any
#	actual or intended publication of such source code.
#	ATT: ident	"ed:ed.mk	1.19"
#	This makefile makes the ed for Domestic, using DCRYPT and
#	-lcrypt

#	Makefile for ed

#ident	"@(#)ed:ed.mk	25.1"

include	$(IROOT)/macdefs

DIR = $(ROOT)/bin

INC = $(ROOT)/usr/include

IFLAG = -n

SIZE = size

MAKEFILE = ed.mk

MAINS = ed ded

OBJECTS =  ed.o ed.s ded.o ded.s

SOURCES =  ed.c edfun

ALL:		$(MAINS)

all : ALL

install: ALL
	$(INS) ed $(DIR)/ed
	chmod 755 $(DIR)/ed
	chgrp bin $(DIR)/ed
	chown bin $(DIR)/ed
	rm -f $(DIR)/red
	ln $(DIR)/ed $(DIR)/red
	$(INS) ded $(DIR)/ded
	chmod 755 $(DIR)/ded
	chgrp bin $(DIR)/ded
	chown bin $(DIR)/ded

ed:		ed.o 
	$(CC) $(CFLAGS) -o ed  ed.o -lgen $(LDFLAGS)

ded:		ded.o 
	$(CC) $(CFLAGS) -o ded  ded.o -lgen -lcrypt  $(LDFLAGS)

ed.o:		 ed.s \
	$(INCRT)/regexp.h $(INCRT)/stdio.h \
		 $(INCRT)/signal.h $(INCRT)/sys/signal.h \
		 $(INCRT)/sys/types.h $(INCRT)/sys/stat.h \
		 $(INCRT)/termio.h $(INCRT)/sys/termio.h \
		 $(INCRT)/ustat.h $(INCRT)/setjmp.h 
	$(CC) -c ed.s

ded.o:		 ded.s \
	$(INCRT)/regexp.h $(INCRT)/stdio.h \
		 $(INCRT)/signal.h $(INCRT)/sys/signal.h \
		 $(INCRT)/sys/types.h $(INCRT)/sys/stat.h \
		 $(INCRT)/termio.h $(INCRT)/sys/termio.h \
		 $(INCRT)/ustat.h $(INCRT)/setjmp.h 
	$(CC) -c ded.s

ed.s:	ed.c
	$(CC) -S $(CFLAGS) ed.c 

ded.s:	ed.c
	$(CC) -S $(CFLAGS) -DCRYPT ed.c 
	mv ed.s ded.s

GLOBALINCS = $(INCRT)/regexp.h $(INCRT)/setjmp.h \
	$(INCRT)/signal.h $(INCRT)/stdio.h $(INCRT)/sys/signal.h \
	$(INCRT)/sys/stat.h $(INCRT)/sys/termio.h \
	$(INCRT)/sys/types.h $(INCRT)/termio.h $(INCRT)/ustat.h 


clean:
	rm -f $(OBJECTS)

clobber:
	rm -f $(OBJECTS) $(MAINS)

size: ALL
	$(SIZE) $(MAINS)

#	These targets are useful but optional

partslist:
	@echo $(MAKEFILE) $(SOURCES) $(LOCALINCS)  |  tr ' ' '\012'  |  sort

productdir:
	@echo $(DIR) | tr ' ' '\012' | sort

product:
	@echo $(MAINS)  |  tr ' ' '\012'  | \
	sed 's;^;$(DIR)/;'

srcaudit:
	@fileaudit $(MAKEFILE) $(LOCALINCS) $(SOURCES) -o $(OBJECTS) $(MAINS)

ctags:	
	ctags	$(SOURCES)
	echo 'grep $$* \\' > greplist
	for i in $(SOURCES)	;\
	do echo "$$i \\"	;\
	done >> greplist
	echo /dev/null >> greplist
	chmod +x greplist

