#ident	"@(#)codeit.c	25.1"
#include <stdio.h>
#define INLENGTH 36
#define OUTLENGTH INLENGTH*2

main(argc, argv)
	int argc;
	char **argv;
{
	/************************************
		convert a binary file to ascii
		the output file will be written
		in hex representation with a line
		length of 72 characters followed by
		a carrage return.  The default is to
		convert from binary to hex.

		flags

		-a	convert from binary to ascii hex (default)
		-b	convert from ascii hex to binary, stripping
			the newline every 72 characters

		default i/o stdio, one file == input file,
		two files == input/output files.

		convert [ -a | -b ] [ -i infile ] [ -o outfile ]

	***************************************/

	int c;
	int ascii_flag = 1;
	extern char *optarg;
	extern int optind;

	while( ( c = getopt( argc, argv, "abi:o:" ) ) != -1 )
	{
		switch( c )
		{
			case 'a':	ascii_flag = 1;
						break;
			case 'b':	ascii_flag = 0;
						break;
			case 'i':	if( freopen( optarg, "r", stdin ) == NULL )
							puke( "Error: cannot open %s", optarg );
						break;

			case 'o':	if( freopen( optarg, "w+", stdout ) == NULL )
							puke( "Error: cannot open %s", optarg );
						break;
			case '?':	
				puke("Usage: %s [ -a | -b ] [ -i infile ] [ -o outfile ]",
					argv[ 0 ] );
		}
	}

	if( ascii_flag )
		ascii();
	else
		binary();
	
	fclose( stdin );
	fclose( stdout );
	exit( 0 );
}

ascii()
{
	/* convert from binary to ascii hex */
	int c;
	int count;

	/* read in chunks of INLENGTH chars and follow with a new-line */
	for( count = 1; ( c = getchar() ) != EOF; count++ )
	{
		printf("%02x", c );
		if( count == INLENGTH )
		{
			putchar( '\n' );
			count = 0;
		}
	}
	if( count != 0 )
		putchar( '\n' );
}

binary()
{
	/* convert from ascii hex to binary */
	/* assume that all lines including a null file have a new-line */
	int c;
	int low;
	int count;
	char outc;

	for( count = 1, low = 1; ( c = getchar() ) != -1; count++ )
	{
		if( (char)c == '\n' )
		{
			/* throw away the new-line */
			count = 0;
			low = 1;
			continue;
		}
		else
		{
			switch( c )
			{
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':	c -= '0';
							break;
				default:	c = c - 'a' + 10;
							break;
			}

			if( low )
			{

				outc = c;
				low = 0;
			}
			else
			{
				low = 1;
				outc = ( outc << 4 ) + (char)c;

				putchar( outc );
			}
		}
	}
}

puke( s1, s2 )
	char *s1;
	char *s2;
{
	fprintf(stderr, s1, s2 );
	fprintf(stderr, "\n");
	exit( 1 );
}

